/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;

class MapEntry
extends AbstractChildNodeEntry
implements Map.Entry<RecordId, RecordId>,
Comparable<MapEntry> {
    @Nonnull
    private final SegmentReader reader;
    @Nonnull
    private final String name;
    @Nonnull
    private final RecordId key;
    @CheckForNull
    private final RecordId value;

    MapEntry(@Nonnull SegmentReader reader, @Nonnull String name, @Nonnull RecordId key, @Nullable RecordId value) {
        this.reader = (SegmentReader)Preconditions.checkNotNull((Object)reader);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.key = (RecordId)Preconditions.checkNotNull((Object)key);
        this.value = value;
    }

    public int getHash() {
        return MapRecord.getHash(this.name);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public SegmentNodeState getNodeState() {
        Preconditions.checkState((this.value != null ? 1 : 0) != 0);
        return this.reader.readNode(this.value);
    }

    @Override
    @Nonnull
    public RecordId getKey() {
        return this.key;
    }

    @Override
    @CheckForNull
    public RecordId getValue() {
        return this.value;
    }

    @Override
    public RecordId setValue(RecordId value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(@Nonnull MapEntry that) {
        return ComparisonChain.start().compare((long)this.getHash() & 0xFFFFFFFFL, (long)that.getHash() & 0xFFFFFFFFL).compare((Comparable)((Object)this.name), (Comparable)((Object)that.name)).compare((Comparable)this.value, (Comparable)that.value).result();
    }
}

