/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import org.apache.jackrabbit.oak.osgi.ObserverTracker;
import org.apache.jackrabbit.oak.spi.whiteboard.AbstractServiceTracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;

class Closeables
implements Closeable {
    private final Closer closer;

    Closeables(Closer closer) {
        this.closer = closer;
    }

    void add(Closeable c) {
        this.closer.register(c);
    }

    void add(final AbstractServiceTracker<?> t) {
        this.add(new Closeable(){

            @Override
            public void close() {
                t.stop();
            }
        });
    }

    void add(final Registration r) {
        this.add(new Closeable(){

            @Override
            public void close() {
                r.unregister();
            }
        });
    }

    void add(final ObserverTracker t) {
        this.add(new Closeable(){

            @Override
            public void close() {
                t.stop();
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

