/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool.iotrace;

import com.google.common.base.Preconditions;
import java.io.Writer;
import java.util.List;
import java.util.function.Function;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.tool.iotrace.DefaultIOTraceWriter;
import org.apache.jackrabbit.oak.segment.tool.iotrace.IOTraceMonitor;
import org.apache.jackrabbit.oak.segment.tool.iotrace.Trace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IOTracer {
    @NotNull
    private final Function<IOMonitor, FileStore> fileStoreFactory;
    @NotNull
    private final IOTraceMonitor ioMonitor;

    private IOTracer(@NotNull Function<IOMonitor, FileStore> fileStoreFactory, @NotNull Writer output, @Nullable String contextSpec) {
        this.fileStoreFactory = (Function)Preconditions.checkNotNull(fileStoreFactory);
        this.ioMonitor = new IOTraceMonitor(new DefaultIOTraceWriter(output), contextSpec);
    }

    @NotNull
    public static IOTracer newIOTracer(@NotNull Function<IOMonitor, FileStore> fileStoreFactory, @NotNull Writer output, @Nullable String contextSpec) {
        return new IOTracer(fileStoreFactory, output, contextSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectTrace(@NotNull Trace trace) {
        Preconditions.checkNotNull((Object)trace);
        try (FileStore fileStore = (FileStore)((Function)Preconditions.checkNotNull(this.fileStoreFactory)).apply((IOMonitor)Preconditions.checkNotNull((Object)this.ioMonitor));){
            trace.run(fileStore.getHead());
        }
        finally {
            this.ioMonitor.flush();
        }
    }

    public void setContext(@NotNull List<String> context) {
        this.ioMonitor.setContext(context);
    }
}

