/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tooling;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.file.JournalEntry;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

public class ConsistencyChecker {
    private static NodeState getDescendantOrNull(NodeState root, String path) {
        NodeState descendant = NodeStateUtils.getNode((NodeState)root, (String)path);
        if (descendant.exists()) {
            return descendant;
        }
        return null;
    }

    protected void onCheckRevision(String revision) {
    }

    protected void onCheckHead() {
    }

    protected void onCheckChekpoints() {
    }

    protected void onCheckCheckpoint(String checkpoint) {
    }

    protected void onCheckpointNotFoundInRevision(String checkpoint) {
    }

    protected void onCheckRevisionError(String revision, Exception e) {
    }

    protected void onConsistentPath(String path) {
    }

    protected void onPathNotFound(String path) {
    }

    protected void onCheckTree(String path, boolean head) {
    }

    protected void onCheckTreeEnd(boolean head) {
    }

    protected void onCheckNode(String path) {
    }

    protected void onCheckProperty() {
    }

    protected void onCheckPropertyEnd(String path, PropertyState property) {
    }

    protected void onCheckNodeError(String path, Exception e) {
    }

    protected void onCheckTreeError(String path, Exception e) {
    }

    private boolean isPathInvalid(NodeState root, String path, boolean binaries) {
        NodeState node = ConsistencyChecker.getDescendantOrNull(root, path);
        if (node == null) {
            this.onPathNotFound(path);
            return true;
        }
        return this.checkNode(node, path, binaries) != null;
    }

    private String findFirstCorruptedPathInSet(NodeState root, Set<String> corruptedPaths, boolean binaries) {
        for (String corruptedPath : corruptedPaths) {
            if (!this.isPathInvalid(root, corruptedPath, binaries)) continue;
            return corruptedPath;
        }
        return null;
    }

    private String findFirstCorruptedPathInTree(NodeState root, String path, boolean binaries) {
        NodeState node = ConsistencyChecker.getDescendantOrNull(root, path);
        if (node == null) {
            this.onPathNotFound(path);
            return path;
        }
        return this.checkNodeAndDescendants(node, path, binaries);
    }

    private String checkTreeConsistency(NodeState root, String path, Set<String> corruptedPaths, boolean binaries, boolean head) {
        String corruptedPath = this.findFirstCorruptedPathInSet(root, corruptedPaths, binaries);
        if (corruptedPath != null) {
            return corruptedPath;
        }
        this.onCheckTree(path, head);
        corruptedPath = this.findFirstCorruptedPathInTree(root, path, binaries);
        this.onCheckTreeEnd(head);
        return corruptedPath;
    }

    private boolean checkPathConsistency(NodeState root, PathToCheck ptc, JournalEntry entry, boolean binaries, boolean head) {
        if (ptc.journalEntry != null) {
            return true;
        }
        String corruptPath = this.checkTreeConsistency(root, ptc.path, ptc.corruptPaths, binaries, head);
        if (corruptPath != null) {
            ptc.corruptPaths.add(corruptPath);
            return false;
        }
        this.onConsistentPath(ptc.path);
        ptc.journalEntry = entry;
        return true;
    }

    private boolean checkAllPathsConsistency(NodeState root, List<PathToCheck> paths, JournalEntry entry, boolean binaries, boolean head) {
        boolean result = true;
        for (PathToCheck ptc : paths) {
            if (this.checkPathConsistency(root, ptc, entry, binaries, head)) continue;
            result = false;
        }
        return result;
    }

    private boolean checkHeadConsistency(SegmentNodeStore store, List<PathToCheck> paths, JournalEntry entry, boolean binaries) {
        boolean allConsistent = paths.stream().allMatch(p -> p.journalEntry != null);
        if (allConsistent) {
            return true;
        }
        this.onCheckHead();
        return this.checkAllPathsConsistency(store.getRoot(), paths, entry, binaries, true);
    }

    private boolean checkCheckpointConsistency(SegmentNodeStore store, String checkpoint, List<PathToCheck> paths, JournalEntry entry, boolean binaries) {
        boolean allConsistent = paths.stream().allMatch(p -> p.journalEntry != null);
        if (allConsistent) {
            return true;
        }
        this.onCheckCheckpoint(checkpoint);
        NodeState root = store.retrieve(checkpoint);
        if (root == null) {
            this.onCheckpointNotFoundInRevision(checkpoint);
            return false;
        }
        return this.checkAllPathsConsistency(root, paths, entry, binaries, false);
    }

    private boolean checkCheckpointsConsistency(SegmentNodeStore store, Map<String, List<PathToCheck>> paths, JournalEntry entry, boolean binaries) {
        boolean result = true;
        for (Map.Entry<String, List<PathToCheck>> e : paths.entrySet()) {
            if (this.checkCheckpointConsistency(store, e.getKey(), e.getValue(), entry, binaries)) continue;
            result = false;
        }
        return result;
    }

    private boolean allPathsConsistent(List<PathToCheck> headPaths, Map<String, List<PathToCheck>> checkpointPaths) {
        for (PathToCheck pathToCheck : headPaths) {
            if (pathToCheck.journalEntry != null) continue;
            return false;
        }
        for (Map.Entry entry : checkpointPaths.entrySet()) {
            for (PathToCheck path : (List)entry.getValue()) {
                if (path.journalEntry != null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean shouldCheckCheckpointsConsistency(Map<String, List<PathToCheck>> paths) {
        return paths.values().stream().flatMap(Collection::stream).anyMatch(p -> p.journalEntry == null);
    }

    public String checkTreeConsistency(NodeState root, Set<String> corruptedPaths, boolean binaries) {
        return this.checkTreeConsistency(root, "/", corruptedPaths, binaries, true);
    }

    public final ConsistencyCheckResult checkConsistency(ReadOnlyFileStore store, Iterator<JournalEntry> journal, boolean head, Set<String> checkpoints, Set<String> paths, boolean binaries, Integer revisionsCount) {
        ArrayList<PathToCheck> headPaths = new ArrayList<PathToCheck>();
        HashMap<String, List<PathToCheck>> checkpointPaths = new HashMap<String, List<PathToCheck>>();
        int checkedRevisionsCount = 0;
        for (String path : paths) {
            if (head) {
                headPaths.add(new PathToCheck(path));
            }
            for (String checkpoint : checkpoints) {
                checkpointPaths.computeIfAbsent(checkpoint, k -> new ArrayList()).add(new PathToCheck(path));
            }
        }
        JournalEntry lastValidJournalEntry = null;
        SegmentNodeStore sns = SegmentNodeStoreBuilders.builder(store).build();
        while (journal.hasNext()) {
            JournalEntry journalEntry = journal.next();
            String revision = journalEntry.getRevision();
            try {
                ++checkedRevisionsCount;
                store.setRevision(revision);
                this.onCheckRevision(revision);
                boolean overall = this.checkHeadConsistency(sns, headPaths, journalEntry, binaries);
                if (this.shouldCheckCheckpointsConsistency(checkpointPaths)) {
                    this.onCheckChekpoints();
                    boolean bl = overall = overall && this.checkCheckpointsConsistency(sns, checkpointPaths, journalEntry, binaries);
                }
                if (overall) {
                    lastValidJournalEntry = journalEntry;
                }
                if (!this.allPathsConsistent(headPaths, checkpointPaths) && checkedRevisionsCount != revisionsCount) continue;
                break;
            }
            catch (IllegalArgumentException | SegmentNotFoundException e) {
                this.onCheckRevisionError(revision, (Exception)e);
            }
        }
        ConsistencyCheckResult result = new ConsistencyCheckResult();
        result.checkedRevisionsCount = checkedRevisionsCount;
        result.overallRevision = ConsistencyChecker.newRevisionOrNull(lastValidJournalEntry);
        for (PathToCheck path : headPaths) {
            result.headRevisions.put(path.path, ConsistencyChecker.newRevisionOrNull(path.journalEntry));
        }
        for (String checkpoint : checkpoints) {
            for (PathToCheck path : (List)checkpointPaths.get(checkpoint)) {
                result.checkpointRevisions.computeIfAbsent(checkpoint, s -> new HashMap()).put(path.path, ConsistencyChecker.newRevisionOrNull(path.journalEntry));
            }
        }
        return result;
    }

    private static Revision newRevisionOrNull(JournalEntry entry) {
        if (entry == null) {
            return null;
        }
        return new Revision(entry.getRevision(), entry.getTimestamp());
    }

    private String checkNode(NodeState node, String path, boolean checkBinaries) {
        try {
            this.onCheckNode(path);
            for (PropertyState propertyState : node.getProperties()) {
                Type type = propertyState.getType();
                boolean checked = false;
                if (type == Type.BINARY) {
                    checked = this.traverse((Blob)propertyState.getValue(Type.BINARY), checkBinaries);
                } else if (type == Type.BINARIES) {
                    for (Blob blob : (Iterable)propertyState.getValue(Type.BINARIES)) {
                        checked |= this.traverse(blob, checkBinaries);
                    }
                } else {
                    propertyState.getValue(type);
                    this.onCheckProperty();
                    checked = true;
                }
                if (!checked) continue;
                this.onCheckPropertyEnd(path, propertyState);
            }
            return null;
        }
        catch (IOException | RuntimeException e) {
            this.onCheckNodeError(path, e);
            return path;
        }
    }

    private String checkNodeAndDescendants(NodeState node, String path, boolean checkBinaries) {
        String result = this.checkNode(node, path, checkBinaries);
        if (result != null) {
            return result;
        }
        try {
            for (ChildNodeEntry cne : node.getChildNodeEntries()) {
                String childName = cne.getName();
                NodeState child = cne.getNodeState();
                result = this.checkNodeAndDescendants(child, PathUtils.concat((String)path, (String)childName), checkBinaries);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        catch (RuntimeException e) {
            this.onCheckTreeError(path, e);
            return path;
        }
    }

    private boolean traverse(Blob blob, boolean checkBinaries) throws IOException {
        if (checkBinaries && !ConsistencyChecker.isExternal(blob)) {
            try (InputStream s = blob.getNewStream();){
                byte[] buffer = new byte[8192];
                int l = s.read(buffer, 0, buffer.length);
                while (l >= 0) {
                    l = s.read(buffer, 0, buffer.length);
                }
            }
            this.onCheckProperty();
            return true;
        }
        return false;
    }

    private static boolean isExternal(Blob b) {
        if (b instanceof SegmentBlob) {
            return ((SegmentBlob)b).isExternal();
        }
        return false;
    }

    public static class ConsistencyCheckResult {
        private final Map<String, Revision> headRevisions = new HashMap<String, Revision>();
        private final Map<String, Map<String, Revision>> checkpointRevisions = new HashMap<String, Map<String, Revision>>();
        private Revision overallRevision;
        private int checkedRevisionsCount;

        private ConsistencyCheckResult() {
        }

        public int getCheckedRevisionsCount() {
            return this.checkedRevisionsCount;
        }

        public Revision getOverallRevision() {
            return this.overallRevision;
        }

        public Map<String, Revision> getHeadRevisions() {
            return this.headRevisions;
        }

        public Map<String, Map<String, Revision>> getCheckpointRevisions() {
            return this.checkpointRevisions;
        }
    }

    public static class Revision {
        private final String revision;
        private final long timestamp;

        private Revision(String revision, long timestamp) {
            this.revision = revision;
            this.timestamp = timestamp;
        }

        public String getRevision() {
            return this.revision;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private static class PathToCheck {
        final String path;
        JournalEntry journalEntry;
        Set<String> corruptPaths = new LinkedHashSet<String>();

        PathToCheck(String path) {
            this.path = path;
        }
    }
}

