/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.jetbrains.annotations.NotNull;

class Reclaimers {
    private Reclaimers() {
    }

    static Predicate<GCGeneration> newOldReclaimer(@NotNull SegmentGCOptions.GCType lastGCType, @NotNull GCGeneration referenceGeneration, int retainedGenerations) {
        switch ((SegmentGCOptions.GCType)((Object)Preconditions.checkNotNull((Object)((Object)lastGCType)))) {
            case FULL: {
                return Reclaimers.newOldFullReclaimer(referenceGeneration, retainedGenerations);
            }
            case TAIL: {
                return Reclaimers.newOldTailReclaimer(referenceGeneration, retainedGenerations);
            }
        }
        throw new IllegalArgumentException("Invalid gc type: " + (Object)((Object)lastGCType));
    }

    private static Predicate<GCGeneration> newOldFullReclaimer(final @NotNull GCGeneration referenceGeneration, final int retainedGenerations) {
        return new Predicate<GCGeneration>(){

            public boolean apply(GCGeneration generation) {
                return this.isOldFull(generation) || this.isOld(generation) && !generation.isCompacted();
            }

            private boolean isOld(GCGeneration generation) {
                return referenceGeneration.compareWith(generation) >= retainedGenerations;
            }

            private boolean isOldFull(GCGeneration generation) {
                return referenceGeneration.compareFullGenerationWith(generation) >= retainedGenerations;
            }

            public String toString() {
                return String.format("(full generation older than %d.%d, with %d retained generations)", referenceGeneration.getGeneration(), referenceGeneration.getFullGeneration(), retainedGenerations);
            }
        };
    }

    private static Predicate<GCGeneration> newOldTailReclaimer(final @NotNull GCGeneration referenceGeneration, final int retainedGenerations) {
        return new Predicate<GCGeneration>(){

            public boolean apply(GCGeneration generation) {
                return this.isOld(generation) && !this.sameCompactedTail(generation);
            }

            private boolean isOld(GCGeneration generation) {
                return referenceGeneration.compareWith(generation) >= retainedGenerations;
            }

            private boolean sameCompactedTail(GCGeneration generation) {
                return generation.isCompacted() && generation.getFullGeneration() == referenceGeneration.getFullGeneration();
            }

            public String toString() {
                return String.format("(generation older than %d.%d, with %d retained generations and not in the same compacted tail)", referenceGeneration.getGeneration(), referenceGeneration.getFullGeneration(), retainedGenerations);
            }
        };
    }

    static Predicate<GCGeneration> newExactReclaimer(final @NotNull GCGeneration referenceGeneration) {
        return new Predicate<GCGeneration>(){

            public boolean apply(GCGeneration generation) {
                return generation.equals(referenceGeneration);
            }

            public String toString() {
                return "(generation==" + referenceGeneration + ")";
            }
        };
    }
}

