/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.segment.ListRecord;
import org.apache.jackrabbit.oak.segment.MapEntry;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.Record;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.Template;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.NoopStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SegmentNodeState
extends Record
implements NodeState {
    @NotNull
    private final SegmentReader reader;
    @Nullable
    private final BlobStore blobStore;
    @NotNull
    private final Supplier<SegmentWriter> writer;
    private final MeterStats readStats;
    private volatile RecordId templateId = null;
    private volatile Template template = null;

    SegmentNodeState(@NotNull SegmentReader reader, @NotNull Supplier<SegmentWriter> writer, @Nullable BlobStore blobStore, @NotNull RecordId id, MeterStats readStats) {
        super(id);
        this.reader = (SegmentReader)Preconditions.checkNotNull((Object)reader);
        this.writer = (Supplier)Preconditions.checkNotNull((Object)Suppliers.memoize(writer));
        this.blobStore = blobStore;
        this.readStats = readStats;
    }

    public SegmentNodeState(@NotNull SegmentReader reader, @NotNull SegmentWriter writer, @Nullable BlobStore blobStore, @NotNull RecordId id) {
        this(reader, (Supplier<SegmentWriter>)Suppliers.ofInstance((Object)writer), blobStore, id, (MeterStats)NoopStats.INSTANCE);
    }

    public SegmentNodeState(@NotNull SegmentReader reader, @NotNull SegmentWriter writer, @Nullable BlobStore blobStore, @NotNull RecordId id, MeterStats readStats) {
        this(reader, (Supplier<SegmentWriter>)Suppliers.ofInstance((Object)writer), blobStore, id, readStats);
    }

    RecordId getTemplateId() {
        if (this.templateId == null) {
            this.templateId = this.getSegment().readRecordId(this.getRecordNumber(), 0, 1);
        }
        return this.templateId;
    }

    Template getTemplate() {
        if (this.template == null) {
            this.template = this.reader.readTemplate(this.getTemplateId());
        }
        return this.template;
    }

    MapRecord getChildNodeMap() {
        Segment segment = this.getSegment();
        return this.reader.readMap(segment.readRecordId(this.getRecordNumber(), 0, 2));
    }

    @NotNull
    static String getStableId(@NotNull Buffer stableId) {
        Buffer buffer = stableId.duplicate();
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        int offset = buffer.getInt();
        return new UUID(msb, lsb) + ":" + offset;
    }

    public String getStableId() {
        return SegmentNodeState.getStableId(this.getStableIdBytes());
    }

    public Buffer getStableIdBytes() {
        RecordId id = this.getSegment().readRecordId(this.getRecordNumber());
        if (id.equals(this.getRecordId())) {
            return id.getBytes();
        }
        return id.getSegment().readBytes(id.getRecordNumber(), 0, 20);
    }

    public boolean exists() {
        return true;
    }

    public long getPropertyCount() {
        this.readStats.mark();
        Template template = this.getTemplate();
        long count = template.getPropertyTemplates().length;
        if (template.getPrimaryType() != null) {
            ++count;
        }
        if (template.getMixinTypes() != null) {
            ++count;
        }
        return count;
    }

    public boolean hasProperty(@NotNull String name) {
        this.readStats.mark();
        Preconditions.checkNotNull((Object)name);
        Template template = this.getTemplate();
        switch (name) {
            case "jcr:primaryType": {
                return template.getPrimaryType() != null;
            }
            case "jcr:mixinTypes": {
                return template.getMixinTypes() != null;
            }
        }
        return template.getPropertyTemplate(name) != null;
    }

    @Nullable
    public PropertyState getProperty(@NotNull String name) {
        this.readStats.mark();
        Preconditions.checkNotNull((Object)name);
        Template template = this.getTemplate();
        PropertyState property = null;
        if ("jcr:primaryType".equals(name)) {
            property = template.getPrimaryType();
        } else if ("jcr:mixinTypes".equals(name)) {
            property = template.getMixinTypes();
        }
        if (property != null) {
            return property;
        }
        PropertyTemplate propertyTemplate = template.getPropertyTemplate(name);
        if (propertyTemplate != null) {
            Segment segment = this.getSegment();
            RecordId id = this.getRecordId(segment, template, propertyTemplate);
            return this.reader.readProperty(id, propertyTemplate);
        }
        return null;
    }

    private RecordId getRecordId(Segment segment, Template template, PropertyTemplate propertyTemplate) {
        int ids = 2;
        if (template.getChildName() != Template.ZERO_CHILD_NODES) {
            ++ids;
        }
        RecordId rid = segment.readRecordId(this.getRecordNumber(), 0, ids);
        ListRecord pIds = new ListRecord(rid, template.getPropertyTemplates().length);
        return pIds.getEntry(propertyTemplate.getIndex());
    }

    @NotNull
    public Iterable<PropertyState> getProperties() {
        PropertyState mixinTypes;
        this.readStats.mark();
        Template template = this.getTemplate();
        PropertyTemplate[] propertyTemplates = template.getPropertyTemplates();
        ArrayList list = Lists.newArrayListWithCapacity((int)(propertyTemplates.length + 2));
        PropertyState primaryType = template.getPrimaryType();
        if (primaryType != null) {
            list.add(primaryType);
        }
        if ((mixinTypes = template.getMixinTypes()) != null) {
            list.add(mixinTypes);
        }
        Segment segment = this.getSegment();
        int ids = 2;
        if (template.getChildName() != Template.ZERO_CHILD_NODES) {
            ++ids;
        }
        if (propertyTemplates.length > 0) {
            ListRecord pIds = new ListRecord(segment.readRecordId(this.getRecordNumber(), 0, ids), propertyTemplates.length);
            for (int i = 0; i < propertyTemplates.length; ++i) {
                RecordId propertyId = pIds.getEntry(i);
                list.add(this.reader.readProperty(propertyId, propertyTemplates[i]));
            }
        }
        return list;
    }

    public boolean getBoolean(@NotNull String name) {
        this.readStats.mark();
        return Boolean.TRUE.toString().equals(this.getValueAsString(name, Type.BOOLEAN));
    }

    public long getLong(String name) {
        this.readStats.mark();
        String value = this.getValueAsString(name, Type.LONG);
        if (value != null) {
            return Long.parseLong(value);
        }
        return 0L;
    }

    @Nullable
    public String getString(String name) {
        this.readStats.mark();
        return this.getValueAsString(name, Type.STRING);
    }

    @NotNull
    public Iterable<String> getStrings(@NotNull String name) {
        this.readStats.mark();
        return this.getValuesAsStrings(name, Type.STRINGS);
    }

    @Nullable
    public String getName(@NotNull String name) {
        this.readStats.mark();
        return this.getValueAsString(name, Type.NAME);
    }

    @NotNull
    public Iterable<String> getNames(@NotNull String name) {
        this.readStats.mark();
        return this.getValuesAsStrings(name, Type.NAMES);
    }

    @Nullable
    private String getValueAsString(String name, Type<?> type) {
        PropertyTemplate propertyTemplate;
        Preconditions.checkArgument((!type.isArray() ? 1 : 0) != 0);
        Template template = this.getTemplate();
        if ("jcr:primaryType".equals(name)) {
            PropertyState primary = template.getPrimaryType();
            if (primary != null) {
                if (type == Type.NAME) {
                    return (String)primary.getValue(Type.NAME);
                }
                return null;
            }
        } else if ("jcr:mixinTypes".equals(name) && template.getMixinTypes() != null) {
            return null;
        }
        if ((propertyTemplate = template.getPropertyTemplate(name)) == null || propertyTemplate.getType() != type) {
            return null;
        }
        Segment segment = this.getSegment();
        RecordId id = this.getRecordId(segment, template, propertyTemplate);
        return this.reader.readString(id);
    }

    @NotNull
    private Iterable<String> getValuesAsStrings(String name, Type<?> type) {
        PropertyTemplate propertyTemplate;
        Preconditions.checkArgument((boolean)type.isArray());
        Template template = this.getTemplate();
        if ("jcr:mixinTypes".equals(name)) {
            PropertyState mixin = template.getMixinTypes();
            if (type == Type.NAMES && mixin != null) {
                return (Iterable)mixin.getValue(Type.NAMES);
            }
            if (type == Type.NAMES || mixin != null) {
                return Collections.emptyList();
            }
        } else if ("jcr:primaryType".equals(name) && template.getPrimaryType() != null) {
            return Collections.emptyList();
        }
        if ((propertyTemplate = template.getPropertyTemplate(name)) == null || propertyTemplate.getType() != type) {
            return Collections.emptyList();
        }
        Segment segment = this.getSegment();
        RecordId id = this.getRecordId(segment, template, propertyTemplate);
        int size = (segment = id.getSegment()).readInt(id.getRecordNumber());
        if (size == 0) {
            return Collections.emptyList();
        }
        id = segment.readRecordId(id.getRecordNumber(), 4);
        if (size == 1) {
            return Collections.singletonList(this.reader.readString(id));
        }
        ArrayList values = Lists.newArrayListWithCapacity((int)size);
        ListRecord list = new ListRecord(id, size);
        for (RecordId value : list.getEntries()) {
            values.add(this.reader.readString(value));
        }
        return values;
    }

    public long getChildNodeCount(long max) {
        this.readStats.mark();
        String childName = this.getTemplate().getChildName();
        if (childName == Template.ZERO_CHILD_NODES) {
            return 0L;
        }
        if (childName == "") {
            return this.getChildNodeMap().size();
        }
        return 1L;
    }

    public boolean hasChildNode(@NotNull String name) {
        this.readStats.mark();
        String childName = this.getTemplate().getChildName();
        if (childName == Template.ZERO_CHILD_NODES) {
            return false;
        }
        if (childName == "") {
            return this.getChildNodeMap().getEntry(name) != null;
        }
        return childName.equals(name);
    }

    @NotNull
    public NodeState getChildNode(@NotNull String name) {
        this.readStats.mark();
        String childName = this.getTemplate().getChildName();
        if (childName == "") {
            MapEntry child = this.getChildNodeMap().getEntry(name);
            if (child != null) {
                return child.getNodeState();
            }
        } else if (childName != Template.ZERO_CHILD_NODES && childName.equals(name)) {
            RecordId childNodeId = this.getSegment().readRecordId(this.getRecordNumber(), 0, 2);
            return this.reader.readNode(childNodeId);
        }
        AbstractNodeState.checkValidName((String)name);
        return EmptyNodeState.MISSING_NODE;
    }

    @NotNull
    public Iterable<String> getChildNodeNames() {
        this.readStats.mark();
        String childName = this.getTemplate().getChildName();
        if (childName == Template.ZERO_CHILD_NODES) {
            return Collections.emptyList();
        }
        if (childName == "") {
            return this.getChildNodeMap().getKeys();
        }
        return Collections.singletonList(childName);
    }

    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        this.readStats.mark();
        String childName = this.getTemplate().getChildName();
        if (childName == Template.ZERO_CHILD_NODES) {
            return Collections.emptyList();
        }
        if (childName == "") {
            return this.getChildNodeMap().getEntries();
        }
        RecordId childNodeId = this.getSegment().readRecordId(this.getRecordNumber(), 0, 2);
        return Collections.singletonList(new MemoryChildNodeEntry(childName, (NodeState)this.reader.readNode(childNodeId)));
    }

    @NotNull
    public SegmentNodeBuilder builder() {
        return new SegmentNodeBuilder(this, this.blobStore, this.reader, (SegmentWriter)this.writer.get(), this.readStats);
    }

    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        this.readStats.mark();
        if (this == base || SegmentNodeState.fastEquals(this, base)) {
            return true;
        }
        if (base == EmptyNodeState.EMPTY_NODE || !base.exists()) {
            return EmptyNodeState.compareAgainstEmptyState((NodeState)this, (NodeStateDiff)diff);
        }
        if (!(base instanceof SegmentNodeState)) {
            return AbstractNodeState.compareAgainstBaseState((NodeState)this, (NodeState)base, (NodeStateDiff)diff);
        }
        SegmentNodeState that = (SegmentNodeState)base;
        Template beforeTemplate = that.getTemplate();
        RecordId beforeId = that.getRecordId();
        Template afterTemplate = this.getTemplate();
        RecordId afterId = this.getRecordId();
        if (!SegmentNodeState.compareProperties(beforeTemplate.getPrimaryType(), afterTemplate.getPrimaryType(), diff)) {
            return false;
        }
        if (!SegmentNodeState.compareProperties(beforeTemplate.getMixinTypes(), afterTemplate.getMixinTypes(), diff)) {
            return false;
        }
        int beforeIndex = 0;
        int afterIndex = 0;
        PropertyTemplate[] beforeProperties = beforeTemplate.getPropertyTemplates();
        PropertyTemplate[] afterProperties = afterTemplate.getPropertyTemplates();
        while (beforeIndex < beforeProperties.length && afterIndex < afterProperties.length) {
            int d = Integer.valueOf(afterProperties[afterIndex].hashCode()).compareTo(beforeProperties[beforeIndex].hashCode());
            if (d == 0) {
                d = afterProperties[afterIndex].getName().compareTo(beforeProperties[beforeIndex].getName());
            }
            SegmentPropertyState beforeProperty = null;
            Object afterProperty = null;
            if (d < 0) {
                afterProperty = afterTemplate.getProperty(afterId, afterIndex++);
            } else if (d > 0) {
                beforeProperty = beforeTemplate.getProperty(beforeId, beforeIndex++);
            } else {
                afterProperty = afterTemplate.getProperty(afterId, afterIndex++);
                beforeProperty = beforeTemplate.getProperty(beforeId, beforeIndex++);
            }
            if (SegmentNodeState.compareProperties(beforeProperty, (PropertyState)afterProperty, diff)) continue;
            return false;
        }
        while (afterIndex < afterProperties.length) {
            if (diff.propertyAdded((PropertyState)afterTemplate.getProperty(afterId, afterIndex++))) continue;
            return false;
        }
        while (beforeIndex < beforeProperties.length) {
            SegmentPropertyState beforeProperty;
            if (diff.propertyDeleted((PropertyState)(beforeProperty = beforeTemplate.getProperty(beforeId, beforeIndex++)))) continue;
            return false;
        }
        String beforeChildName = beforeTemplate.getChildName();
        String afterChildName = afterTemplate.getChildName();
        if (afterChildName == Template.ZERO_CHILD_NODES) {
            if (beforeChildName != Template.ZERO_CHILD_NODES) {
                for (ChildNodeEntry childNodeEntry : beforeTemplate.getChildNodeEntries(beforeId)) {
                    if (diff.childNodeDeleted(childNodeEntry.getName(), childNodeEntry.getNodeState())) continue;
                    return false;
                }
            }
        } else if (afterChildName != "") {
            NodeState afterNode = afterTemplate.getChildNode(afterChildName, afterId);
            NodeState nodeState = beforeTemplate.getChildNode(afterChildName, beforeId);
            if (!nodeState.exists() ? !diff.childNodeAdded(afterChildName, afterNode) : !SegmentNodeState.fastEquals(afterNode, nodeState) && !diff.childNodeChanged(afterChildName, nodeState, afterNode)) {
                return false;
            }
            if (beforeChildName == "" || beforeChildName != Template.ZERO_CHILD_NODES && !nodeState.exists()) {
                for (ChildNodeEntry childNodeEntry : beforeTemplate.getChildNodeEntries(beforeId)) {
                    if (afterChildName.equals(childNodeEntry.getName()) || diff.childNodeDeleted(childNodeEntry.getName(), childNodeEntry.getNodeState())) continue;
                    return false;
                }
            }
        } else if (beforeChildName == Template.ZERO_CHILD_NODES) {
            for (ChildNodeEntry childNodeEntry : afterTemplate.getChildNodeEntries(afterId)) {
                if (diff.childNodeAdded(childNodeEntry.getName(), childNodeEntry.getNodeState())) continue;
                return false;
            }
        } else if (beforeChildName != "") {
            boolean beforeChildRemoved = true;
            NodeState nodeState = beforeTemplate.getChildNode(beforeChildName, beforeId);
            for (ChildNodeEntry childNodeEntry : afterTemplate.getChildNodeEntries(afterId)) {
                String childName = childNodeEntry.getName();
                NodeState afterChild = childNodeEntry.getNodeState();
                if (beforeChildName.equals(childName)) {
                    beforeChildRemoved = false;
                    if (SegmentNodeState.fastEquals(afterChild, nodeState) || diff.childNodeChanged(childName, nodeState, afterChild)) continue;
                    return false;
                }
                if (diff.childNodeAdded(childName, afterChild)) continue;
                return false;
            }
            if (beforeChildRemoved && !diff.childNodeDeleted(beforeChildName, nodeState)) {
                return false;
            }
        } else {
            MapRecord afterMap = afterTemplate.getChildNodeMap(afterId);
            MapRecord mapRecord = beforeTemplate.getChildNodeMap(beforeId);
            return afterMap.compare(mapRecord, diff);
        }
        return true;
    }

    private static boolean compareProperties(PropertyState before, PropertyState after, NodeStateDiff diff) {
        if (before == null) {
            return after == null || diff.propertyAdded(after);
        }
        if (after == null) {
            return diff.propertyDeleted(before);
        }
        return before.equals(after) || diff.propertyChanged(before, after);
    }

    public static boolean fastEquals(NodeState a, NodeState b) {
        if (Record.fastEquals(a, (Object)b)) {
            return true;
        }
        return a instanceof SegmentNodeState && b instanceof SegmentNodeState && ((SegmentNodeState)a).getStableId().equals(((SegmentNodeState)b).getStableId());
    }

    @Override
    public int hashCode() {
        return this.getStableId().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SegmentNodeState) {
            SegmentNodeState that = (SegmentNodeState)object;
            if (SegmentNodeState.fastEquals(this, that)) {
                return true;
            }
            Template template = this.getTemplate();
            return template.equals(that.getTemplate()) && template.compare(this.getRecordId(), that.getRecordId());
        }
        return object instanceof NodeState && AbstractNodeState.equals((NodeState)this, (NodeState)((NodeState)object));
    }

    @Override
    public String toString() {
        return AbstractNodeState.toString((NodeState)this);
    }
}

