/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.memory;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.CachingSegmentReader;
import org.apache.jackrabbit.oak.segment.DefaultSegmentWriterBuilder;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentIdFactory;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentTracker;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.memory.MemoryStoreRevisions;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.NoopStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryStore
implements SegmentStore {
    @NotNull
    private final SegmentTracker tracker;
    @NotNull
    private final MemoryStoreRevisions revisions;
    @NotNull
    private final SegmentReader segmentReader;
    @NotNull
    private final SegmentWriter segmentWriter;
    private final ConcurrentMap<SegmentId, Segment> segments = Maps.newConcurrentMap();

    public MemoryStore() throws IOException {
        this.tracker = new SegmentTracker(new SegmentIdFactory(){

            @Override
            @NotNull
            public SegmentId newSegmentId(long msb, long lsb) {
                return new SegmentId(MemoryStore.this, msb, lsb);
            }
        });
        this.revisions = new MemoryStoreRevisions();
        this.segmentReader = new CachingSegmentReader((Supplier<SegmentWriter>)((Supplier)this::getWriter), null, 16L, 2L, (MeterStats)NoopStats.INSTANCE);
        this.segmentWriter = DefaultSegmentWriterBuilder.defaultSegmentWriterBuilder("sys").withWriterPool().build(this);
        this.revisions.bind(this);
        this.segmentWriter.flush();
    }

    @NotNull
    public SegmentWriter getWriter() {
        return this.segmentWriter;
    }

    @NotNull
    public SegmentReader getReader() {
        return this.segmentReader;
    }

    @NotNull
    public SegmentIdProvider getSegmentIdProvider() {
        return this.tracker;
    }

    @NotNull
    public Revisions getRevisions() {
        return this.revisions;
    }

    @Override
    public boolean containsSegment(SegmentId id) {
        return id.sameStore(this) || this.segments.containsKey(id);
    }

    @Override
    @NotNull
    public Segment readSegment(SegmentId id) {
        Segment segment = (Segment)this.segments.get(id);
        if (segment != null) {
            return segment;
        }
        throw new SegmentNotFoundException(id);
    }

    @Override
    public void writeSegment(SegmentId id, byte[] data, int offset, int length) throws IOException {
        Buffer buffer = Buffer.allocate((int)length);
        buffer.put(data, offset, length);
        buffer.rewind();
        Segment segment = new Segment(this.tracker, this.segmentReader, id, buffer);
        if (this.segments.putIfAbsent(id, segment) != null) {
            throw new IOException("Segment override: " + id);
        }
    }

    @Nullable
    public BlobStore getBlobStore() {
        return null;
    }

    public void gc() {
        System.gc();
        this.segments.keySet().retainAll(this.tracker.getReferencedSegmentIds());
    }

    public Set<SegmentId> getReferencedSegmentIds() {
        return this.tracker.getReferencedSegmentIds();
    }
}

