/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.proc;

import com.google.common.collect.ImmutableList;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.segment.file.proc.AbstractNode;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.apache.jackrabbit.oak.segment.file.proc.SegmentEntry;
import org.apache.jackrabbit.oak.segment.file.proc.SegmentNode;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class TarNode
extends AbstractNode {
    private final Proc.Backend backend;
    private final String name;

    TarNode(Proc.Backend backend, String name) {
        this.backend = backend;
        this.name = name;
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return ImmutableList.of((Object)PropertyStates.createProperty((String)"name", (Object)this.name), (Object)PropertyStates.createProperty((String)"size", (Object)this.backend.getTarSize(this.name).orElse(-1L)));
    }

    @Override
    public boolean hasChildNode(@NotNull String name) {
        return this.backend.segmentExists(this.name, name);
    }

    @Override
    @NotNull
    public NodeState getChildNode(@NotNull String name) throws IllegalArgumentException {
        if (this.backend.segmentExists(this.name, name)) {
            return SegmentNode.newSegmentNode(this.backend, name);
        }
        return EmptyNodeState.MISSING_NODE;
    }

    @Override
    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return StreamSupport.stream(this.backend.getSegmentIds(this.name).spliterator(), false).map(this::newSegmentEntry).collect(Collectors.toList());
    }

    ChildNodeEntry newSegmentEntry(String segmentId) {
        return new SegmentEntry(this.backend, segmentId);
    }
}

