/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.Manifest;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;

public class ManifestChecker {
    private final ManifestFile file;
    private final boolean shouldExist;
    private final int minStoreVersion;
    private final int maxStoreVersion;

    public static ManifestChecker newManifestChecker(ManifestFile file, boolean shouldExist, int minStoreVersion, int maxStoreVersion) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"file");
        Preconditions.checkArgument((minStoreVersion > 0 ? 1 : 0) != 0, (Object)"minStoreVersion");
        Preconditions.checkArgument((maxStoreVersion > 0 ? 1 : 0) != 0, (Object)"maxStoreVersion");
        return new ManifestChecker(file, shouldExist, minStoreVersion, maxStoreVersion);
    }

    private ManifestChecker(ManifestFile file, boolean shouldExist, int minStoreVersion, int maxStoreVersion) {
        this.file = file;
        this.shouldExist = shouldExist;
        this.minStoreVersion = minStoreVersion;
        this.maxStoreVersion = maxStoreVersion;
    }

    void checkAndUpdateManifest() throws IOException, InvalidFileStoreVersionException {
        Manifest manifest = this.openManifest();
        this.checkManifest(manifest);
        this.updateManifest(manifest);
    }

    public void checkManifest() throws IOException, InvalidFileStoreVersionException {
        this.checkManifest(this.openManifest());
    }

    private Manifest openManifest() throws IOException, InvalidFileStoreVersionException {
        if (this.file.exists()) {
            return Manifest.load(this.file);
        }
        if (this.shouldExist) {
            throw new InvalidFileStoreVersionException("Using oak-segment-tar, but oak-segment should be used");
        }
        return Manifest.empty();
    }

    private void checkManifest(Manifest manifest) throws InvalidFileStoreVersionException {
        this.checkStoreVersion(manifest.getStoreVersion(this.maxStoreVersion));
    }

    private void checkStoreVersion(int storeVersion) throws InvalidFileStoreVersionException {
        if (storeVersion <= 0) {
            throw new IllegalStateException("Invalid store version");
        }
        if (storeVersion < this.minStoreVersion) {
            throw new InvalidFileStoreVersionException("Using a too recent version of oak-segment-tar");
        }
        if (storeVersion > this.maxStoreVersion) {
            throw new InvalidFileStoreVersionException("Using a too old version of oak-segment tar");
        }
    }

    private void updateManifest(Manifest manifest) throws IOException {
        manifest.setStoreVersion(this.maxStoreVersion);
        manifest.save(this.file);
    }
}

