/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentReferences;
import org.jetbrains.annotations.NotNull;

class MutableSegmentReferences
implements SegmentReferences {
    private final Object lock = new Object();
    private final List<SegmentId> ids = Lists.newArrayList();
    private final Map<SegmentId, Integer> numbers = Maps.newHashMap();

    MutableSegmentReferences() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentId getSegmentId(int reference) {
        SegmentId id = this.ids.get(reference - 1);
        if (id != null) {
            return id;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.ids.get(reference - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addOrReference(SegmentId id) {
        Integer number = this.numbers.get(id);
        if (number != null) {
            return number;
        }
        Object object = this.lock;
        synchronized (object) {
            number = this.numbers.get(id);
            if (number != null) {
                return number;
            }
            this.ids.add(id);
            number = this.ids.size();
            this.numbers.put(id, number);
            return number;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.numbers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(SegmentId id) {
        boolean contains = this.numbers.containsKey(id);
        if (contains) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.numbers.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterator<SegmentId> iterator() {
        Object object = this.lock;
        synchronized (object) {
            return this.ids.iterator();
        }
    }
}

