/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.file.tar.index.Index;
import org.apache.jackrabbit.oak.segment.file.tar.index.IndexEntryV1;

class IndexV1
implements Index {
    static final int FOOTER_SIZE = 16;
    private final Buffer entries;

    IndexV1(Buffer entries) {
        this.entries = entries;
    }

    @Override
    public Set<UUID> getUUIDs() {
        HashSet uuids = Sets.newHashSetWithExpectedSize((int)(this.entries.remaining() / 28));
        for (int position = this.entries.position(); position < this.entries.limit(); position += 28) {
            long msb = this.entries.getLong(position);
            long lsb = this.entries.getLong(position + 8);
            uuids.add(new UUID(msb, lsb));
        }
        return uuids;
    }

    @Override
    public int findEntry(long msb, long lsb) {
        int lowIndex = 0;
        int highIndex = this.entries.remaining() / 28 - 1;
        float lowValue = -9.223372E18f;
        float highValue = 9.223372E18f;
        float targetValue = msb;
        while (lowIndex <= highIndex) {
            int guessIndex = lowIndex + Math.round((float)(highIndex - lowIndex) * (targetValue - lowValue) / (highValue - lowValue));
            int position = this.entries.position() + guessIndex * 28;
            long m = this.entries.getLong(position);
            if (msb < m) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (msb > m) {
                lowIndex = guessIndex + 1;
                lowValue = m;
                continue;
            }
            long l = this.entries.getLong(position + 8);
            if (lsb < l) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (lsb > l) {
                lowIndex = guessIndex + 1;
                lowValue = m;
                continue;
            }
            return position / 28;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.entries.remaining() + 16;
    }

    @Override
    public int count() {
        return this.entries.remaining() / 28;
    }

    @Override
    public IndexEntryV1 entry(int i) {
        return new IndexEntryV1(this.entries, Preconditions.checkElementIndex((int)i, (int)this.count()) * 28);
    }
}

