/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Map;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MapEntry
extends AbstractChildNodeEntry
implements Map.Entry<RecordId, RecordId>,
Comparable<MapEntry> {
    @NotNull
    private final SegmentReader reader;
    @NotNull
    private final String name;
    @NotNull
    private final RecordId key;
    @Nullable
    private final RecordId value;

    private MapEntry(@NotNull SegmentReader reader, @NotNull String name, @NotNull RecordId key, @Nullable RecordId value) {
        this.reader = (SegmentReader)Preconditions.checkNotNull((Object)reader);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.key = (RecordId)Preconditions.checkNotNull((Object)key);
        this.value = value;
    }

    static MapEntry newMapEntry(@NotNull SegmentReader reader, @NotNull String name, @NotNull RecordId key, @NotNull RecordId value) {
        return new MapEntry(reader, name, key, (RecordId)Preconditions.checkNotNull((Object)value));
    }

    static MapEntry newModifiedMapEntry(@NotNull SegmentReader reader, @NotNull String name, @NotNull RecordId key, @Nullable RecordId value) {
        return new MapEntry(reader, name, key, value);
    }

    public int getHash() {
        return MapRecord.getHash(this.name);
    }

    boolean isDeleted() {
        return this.value == null;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public SegmentNodeState getNodeState() {
        Preconditions.checkState((this.value != null ? 1 : 0) != 0);
        return this.reader.readNode(this.value);
    }

    @Override
    @NotNull
    public RecordId getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public RecordId getValue() {
        Preconditions.checkState((this.value != null ? 1 : 0) != 0);
        return this.value;
    }

    @Override
    public RecordId setValue(RecordId value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(@NotNull MapEntry that) {
        return ComparisonChain.start().compare((long)this.getHash() & 0xFFFFFFFFL, (long)that.getHash() & 0xFFFFFFFFL).compare((Comparable)((Object)this.name), (Comparable)((Object)that.name)).compare((Object)this.value, (Object)that.value, (Comparator)Ordering.natural().nullsLast()).result();
    }
}

