/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.remote;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.segment.remote.RemoteSegmentArchiveEntry;
import org.jetbrains.annotations.NotNull;

public final class RemoteUtilities {
    public static final boolean OFF_HEAP = Boolean.getBoolean("access.off.heap");
    public static final String SEGMENT_FILE_NAME_PATTERN = "^([0-9a-f]{4})\\.([0-9a-f-]+)$";
    private static final Pattern PATTERN = Pattern.compile("^([0-9a-f]{4})\\.([0-9a-f-]+)$");

    private RemoteUtilities() {
    }

    public static String getSegmentFileName(RemoteSegmentArchiveEntry indexEntry) {
        return RemoteUtilities.getSegmentFileName(indexEntry.getPosition(), indexEntry.getMsb(), indexEntry.getLsb());
    }

    public static String getSegmentFileName(long offset, long msb, long lsb) {
        return String.format("%04x.%s", offset, new UUID(msb, lsb).toString());
    }

    public static UUID getSegmentUUID(@NotNull String segmentFileName) {
        Matcher m = PATTERN.matcher(segmentFileName);
        if (!m.matches()) {
            return null;
        }
        return UUID.fromString(m.group(2));
    }
}

