/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.remote.persistentcache;

import com.google.common.base.Stopwatch;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.remote.RemoteUtilities;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.AbstractPersistentCache;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.SegmentCacheStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.params.SetParams;

public class PersistentRedisCache
extends AbstractPersistentCache {
    private static final Logger logger = LoggerFactory.getLogger(PersistentRedisCache.class);
    public static final int DEFAULT_REDIS_CACHE_EXPIRE_SECONDS = 172800;
    public static final String NAME = "Segment Redis Cache";
    private static final String REDIS_PREFIX = "SEGMENT";
    private final IOMonitor redisCacheIOMonitor;
    private JedisPool redisPool;
    private SetParams setParamsWithExpire;

    public PersistentRedisCache(String redisHost, int redisPort, int redisExpireSeconds, int redisSocketTimeout, int redisConnectionTimeout, int redisMinConnections, int redisMaxConnections, int redisMaxTotalConnections, int redisDBIndex, IOMonitor redisCacheIOMonitor) {
        this.redisCacheIOMonitor = redisCacheIOMonitor;
        int redisExpireSeconds1 = redisExpireSeconds < 0 ? 172800 : redisExpireSeconds;
        this.setParamsWithExpire = SetParams.setParams().ex(redisExpireSeconds1);
        if (redisPort == 0) {
            redisPort = 6379;
        }
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setTestOnBorrow(true);
        jedisPoolConfig.setMaxWaitMillis((long)redisSocketTimeout);
        jedisPoolConfig.setMinIdle(redisMinConnections);
        jedisPoolConfig.setMaxIdle(redisMaxConnections);
        jedisPoolConfig.setMaxTotal(redisMaxTotalConnections);
        this.redisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, redisHost, redisPort, redisConnectionTimeout, redisSocketTimeout, null, redisDBIndex, null);
        this.segmentCacheStats = new SegmentCacheStats(NAME, this::getRedisMaxMemory, this::getCacheElementCount, this::getCurrentWeight, this::getNumberOfEvictedKeys);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getCacheElementCount() {
        try (Jedis redis = this.redisPool.getResource();){
            long l = redis.dbSize();
            return l;
        }
        catch (JedisException e) {
            logger.error("Error getting number of elements in redis", (Throwable)e);
            return -1L;
        }
    }

    private long getRedisMaxMemory() {
        try {
            return Long.parseLong(this.getRedisProperty("memory", "maxmemory"));
        }
        catch (IOException | JedisException e) {
            logger.error("Error getting redis configuration value for 'maxmemory'", e);
            return -1L;
        }
    }

    private long getCurrentWeight() {
        try {
            return Long.parseLong(this.getRedisProperty("memory", "used_memory"));
        }
        catch (IOException | JedisException e) {
            logger.error("Error getting number of elements in redis", e);
            return -1L;
        }
    }

    private long getNumberOfEvictedKeys() {
        try {
            return Long.parseLong(this.getRedisProperty("stats", "evicted_keys"));
        }
        catch (IOException | JedisException e) {
            logger.error("Error getting number of evicted elements in redis", e);
            return -1L;
        }
    }

    private String getRedisProperty(String section, String propertyName) throws IOException {
        try (Jedis redis = this.redisPool.getResource();){
            String redisInfoString = redis.info(section);
            Properties props = new Properties();
            props.load(new StringReader(redisInfoString));
            String string = (String)props.get(propertyName);
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Buffer readSegmentInternal(long msb, long lsb) {
        String segmentId = new UUID(msb, lsb).toString();
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (Jedis redis = this.redisPool.getResource();){
            Buffer buffer2;
            this.redisCacheIOMonitor.beforeSegmentRead(null, msb, lsb, 0);
            byte[] bytes = redis.get(("SEGMENT:" + segmentId).getBytes());
            if (bytes == null) return null;
            long elapsed = stopwatch.elapsed(TimeUnit.NANOSECONDS);
            this.redisCacheIOMonitor.afterSegmentRead(null, msb, lsb, bytes.length, elapsed);
            if (RemoteUtilities.OFF_HEAP) {
                Buffer buffer22 = Buffer.allocateDirect((int)bytes.length);
            } else {
                buffer2 = Buffer.allocate((int)bytes.length);
            }
            buffer2.put(bytes);
            buffer2.flip();
            Buffer buffer = buffer2;
            return buffer;
        }
        catch (Exception e) {
            logger.error("Error loading segment {} from cache", (Object)segmentId, (Object)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsSegment(long msb, long lsb) {
        String segmentId = new UUID(msb, lsb).toString();
        try (Jedis redis = this.redisPool.getResource();){
            boolean bl = redis.exists(("SEGMENT:" + segmentId).getBytes());
            return bl;
        }
        catch (JedisException e) {
            logger.error("Error checking segment existence {} in cache: {}", (Object)segmentId, (Object)e);
            return false;
        }
    }

    public void writeSegment(long msb, long lsb, Buffer buffer) {
        String segmentId = new UUID(msb, lsb).toString();
        Buffer bufferCopy = buffer.duplicate();
        Runnable task = () -> {
            if (this.writesPending.add(segmentId)) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try (WritableByteChannel channel = Channels.newChannel(bos);
                     Jedis redis = this.redisPool.getResource();){
                    while (bufferCopy.hasRemaining()) {
                        bufferCopy.write(channel);
                    }
                    byte[] key = ("SEGMENT:" + segmentId).getBytes();
                    redis.set(key, bos.toByteArray(), this.setParamsWithExpire);
                    this.cacheSize.addAndGet(bos.size());
                }
                catch (Throwable t) {
                    logger.debug("Unable to write segment {} to cache: {}", (Object)segmentId, (Object)t.getMessage());
                }
                finally {
                    this.writesPending.remove(segmentId);
                }
            }
        };
        this.executor.execute(task);
    }

    public void cleanUp() {
    }
}

