/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.remote.persistentcache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.AbstractPersistentCache;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.SegmentCacheStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentDiskCache
extends AbstractPersistentCache {
    private static final Logger logger = LoggerFactory.getLogger(PersistentDiskCache.class);
    public static final int DEFAULT_MAX_CACHE_SIZE_MB = 512;
    public static final String NAME = "Segment Disk Cache";
    private final File directory;
    private final long maxCacheSizeBytes;
    private final IOMonitor diskCacheIOMonitor;
    final AtomicBoolean cleanupInProgress = new AtomicBoolean(false);
    final AtomicLong evictionCount = new AtomicLong();
    private static final Comparator<Path> sortedByAccessTime = (path1, path2) -> {
        try {
            FileTime lastAccessFile1 = Files.readAttributes(path1, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
            FileTime lastAccessFile2 = Files.readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
            return lastAccessFile1.compareTo(lastAccessFile2);
        }
        catch (IOException e) {
            logger.error("A problem occurred while cleaning up the cache: ", (Throwable)e);
            return 0;
        }
    };

    public PersistentDiskCache(File directory, int cacheMaxSizeMB, IOMonitor diskCacheIOMonitor) {
        this.directory = directory;
        this.maxCacheSizeBytes = (long)cacheMaxSizeMB * 1024L * 1024L;
        this.diskCacheIOMonitor = diskCacheIOMonitor;
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.segmentCacheStats = new SegmentCacheStats(NAME, () -> this.maxCacheSizeBytes, () -> directory.listFiles().length, () -> FileUtils.sizeOfDirectory((File)directory), () -> this.evictionCount.get());
    }

    /*
     * Exception decompiling
     */
    protected Buffer readSegmentInternal(long msb, long lsb) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean containsSegment(long msb, long lsb) {
        return new File(this.directory, new UUID(msb, lsb).toString()).exists();
    }

    public void writeSegment(long msb, long lsb, Buffer buffer) {
        String segmentId = new UUID(msb, lsb).toString();
        File segmentFile = new File(this.directory, segmentId);
        File tempSegmentFile = new File(this.directory, segmentId + System.nanoTime() + ".part");
        Buffer bufferCopy = buffer.duplicate();
        Runnable task = () -> {
            if (this.writesPending.add(segmentId)) {
                try {
                    int fileSize;
                    try (FileChannel channel = new FileOutputStream(tempSegmentFile).getChannel();){
                        fileSize = bufferCopy.write((WritableByteChannel)channel);
                    }
                    try {
                        Files.move(tempSegmentFile.toPath(), segmentFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (AtomicMoveNotSupportedException e) {
                        Files.move(tempSegmentFile.toPath(), segmentFile.toPath(), new CopyOption[0]);
                    }
                    this.cacheSize.addAndGet(fileSize);
                }
                catch (Exception e) {
                    logger.error("Error writing segment {} to cache: {}", (Object)segmentId, (Object)e);
                    try {
                        Files.deleteIfExists(segmentFile.toPath());
                        Files.deleteIfExists(tempSegmentFile.toPath());
                    }
                    catch (IOException i) {
                        logger.error("Error while deleting corrupted segment file {}", (Object)segmentId, (Object)i);
                    }
                }
                finally {
                    this.writesPending.remove(segmentId);
                }
            }
            this.cleanUp();
        };
        this.executor.execute(task);
    }

    private boolean isCacheFull() {
        return this.cacheSize.get() >= this.maxCacheSizeBytes;
    }

    public void cleanUp() {
        if (!this.cleanupInProgress.getAndSet(true)) {
            try {
                this.cleanUpInternal();
            }
            finally {
                this.cleanupInProgress.set(false);
            }
        }
    }

    private void cleanUpInternal() {
        if (this.isCacheFull()) {
            try {
                Stream<Path> segmentsPaths = Files.walk(this.directory.toPath(), new FileVisitOption[0]).sorted(sortedByAccessTime).filter(filePath -> !filePath.toFile().isDirectory());
                StreamConsumer.forEach(segmentsPaths, (path, breaker) -> {
                    if ((double)this.cacheSize.get() > (double)this.maxCacheSizeBytes * 0.66) {
                        this.cacheSize.addAndGet(-path.toFile().length());
                        path.toFile().delete();
                        this.evictionCount.incrementAndGet();
                    } else {
                        breaker.stop();
                    }
                });
            }
            catch (IOException e) {
                logger.error("A problem occurred while cleaning up the cache: ", (Throwable)e);
            }
        }
    }

    static class StreamConsumer {
        StreamConsumer() {
        }

        public static <T> void forEach(Stream<T> stream, BiConsumer<T, Breaker> consumer) {
            Spliterator<Object> spliterator = stream.spliterator();
            boolean hadNext = true;
            Breaker breaker = new Breaker();
            while (hadNext && !breaker.get()) {
                hadNext = spliterator.tryAdvance(elem -> consumer.accept(elem, breaker));
            }
        }

        public static class Breaker {
            private boolean shouldBreak = false;

            public void stop() {
                this.shouldBreak = true;
            }

            boolean get() {
                return this.shouldBreak;
            }
        }
    }
}

