/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure.tool;

import com.google.common.base.Stopwatch;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.azure.AzurePersistence;
import org.apache.jackrabbit.oak.segment.azure.AzureUtilities;
import org.apache.jackrabbit.oak.segment.azure.util.AzureConfigurationParserUtils;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.tar.TarPersistence;
import org.apache.jackrabbit.oak.segment.remote.persistentcache.PersistentDiskCache;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.CachingPersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.PersistentCache;

public class ToolUtils {
    private ToolUtils() {
    }

    public static FileStore newFileStore(SegmentNodeStorePersistence persistence, File directory, boolean strictVersionCheck, int segmentCacheSize, long gcLogInterval, SegmentGCOptions.CompactorType compactorType) throws IOException, InvalidFileStoreVersionException, URISyntaxException, StorageException {
        FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder((File)directory).withCustomPersistence(persistence).withMemoryMapping(false).withStrictVersionCheck(strictVersionCheck).withSegmentCacheSize(segmentCacheSize).withGCOptions(SegmentGCOptions.defaultGCOptions().setOffline().setGCLogInterval(gcLogInterval).setCompactorType(compactorType));
        return builder.build();
    }

    public static SegmentNodeStorePersistence newSegmentNodeStorePersistence(SegmentStoreType storeType, String pathOrUri, String persistentCachePath, Integer persistentCacheSize) {
        TarPersistence persistence = null;
        switch (storeType) {
            case AZURE: {
                CloudBlobDirectory cloudBlobDirectory = ToolUtils.createCloudBlobDirectory(pathOrUri.substring(3));
                AzurePersistence basePersistence = new AzurePersistence(cloudBlobDirectory);
                PersistentDiskCache persistentCache = new PersistentDiskCache(new File(persistentCachePath), persistentCacheSize * 1024, (IOMonitor)new IOMonitorAdapter());
                persistence = new CachingPersistence((PersistentCache)persistentCache, (SegmentNodeStorePersistence)basePersistence);
                break;
            }
            default: {
                persistence = new TarPersistence(new File(pathOrUri));
            }
        }
        return persistence;
    }

    public static SegmentNodeStorePersistence newSegmentNodeStorePersistence(SegmentStoreType storeType, String pathOrUri) {
        Object persistence = null;
        switch (storeType) {
            case AZURE: {
                CloudBlobDirectory cloudBlobDirectory = ToolUtils.createCloudBlobDirectory(pathOrUri.substring(3));
                persistence = new AzurePersistence(cloudBlobDirectory);
                break;
            }
            default: {
                persistence = new TarPersistence(new File(pathOrUri));
            }
        }
        return persistence;
    }

    public static SegmentArchiveManager createArchiveManager(SegmentNodeStorePersistence persistence) {
        SegmentArchiveManager archiveManager = null;
        try {
            archiveManager = persistence.createArchiveManager(false, false, (IOMonitor)new IOMonitorAdapter(), (FileStoreMonitor)new FileStoreMonitorAdapter(), (RemoteStoreMonitor)new RemoteStoreMonitorAdapter());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not access the Azure Storage. Please verify the path provided!");
        }
        return archiveManager;
    }

    public static CloudBlobDirectory createCloudBlobDirectory(String path) {
        Map<String, String> config = AzureConfigurationParserUtils.parseAzureConfigurationFromUri(path);
        String accountName = config.get("accountName");
        String key = System.getenv("AZURE_SECRET_KEY");
        StorageCredentialsAccountAndKey credentials = null;
        try {
            credentials = new StorageCredentialsAccountAndKey(accountName, key);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not connect to the Azure Storage. Please verify if AZURE_SECRET_KEY environment variable is correctly set!");
        }
        String uri = config.get("storageUri");
        String dir = config.get("directory");
        try {
            return AzureUtilities.cloudBlobDirectoryFrom(credentials, uri, dir);
        }
        catch (StorageException | URISyntaxException e) {
            throw new IllegalArgumentException("Could not connect to the Azure Storage. Please verify the path provided!");
        }
    }

    public static SegmentStoreType storeTypeFromPathOrUri(String pathOrUri) {
        if (pathOrUri.startsWith("az:")) {
            return SegmentStoreType.AZURE;
        }
        return SegmentStoreType.TAR;
    }

    public static String storeDescription(SegmentStoreType storeType, String pathOrUri) {
        return storeType.description(pathOrUri);
    }

    public static String printableStopwatch(Stopwatch s) {
        return String.format("%s (%ds)", s, s.elapsed(TimeUnit.SECONDS));
    }

    public static void printMessage(PrintWriter pw, String format, Object ... arg) {
        pw.println(MessageFormat.format(format, arg));
    }

    public static byte[] fetchByteArray(Buffer buffer) throws IOException {
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        return data;
    }

    public static enum SegmentStoreType {
        TAR("TarMK Segment Store"),
        AZURE("Azure Segment Store");

        private String type;

        private SegmentStoreType(String type) {
            this.type = type;
        }

        public String description(String pathOrUri) {
            String location = pathOrUri;
            if (pathOrUri.startsWith("az:")) {
                location = pathOrUri.substring(3);
            }
            return this.type + "@" + location;
        }
    }
}

