/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure.tool;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.azure.tool.SegmentStoreMigrator;
import org.apache.jackrabbit.oak.segment.azure.tool.ToolUtils;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;

public class SegmentCopy {
    private static final int READ_THREADS = 20;
    private final String source;
    private final String destination;
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private final Integer revisionCount;
    private final Boolean flat;
    private final Integer maxSizeGb;
    private SegmentNodeStorePersistence srcPersistence;
    private SegmentNodeStorePersistence destPersistence;
    private ExecutorService executor = Executors.newFixedThreadPool(21);

    public static Builder builder() {
        return new Builder();
    }

    public SegmentCopy(Builder builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.srcPersistence = builder.srcPersistence;
        this.destPersistence = builder.destPersistence;
        this.revisionCount = builder.revisionsCount;
        this.flat = builder.flat;
        this.maxSizeGb = builder.maxSizeGb;
        this.outWriter = builder.outWriter;
        this.errWriter = builder.errWriter;
    }

    public int run() {
        Stopwatch watch = Stopwatch.createStarted();
        ToolUtils.SegmentStoreType srcType = ToolUtils.storeTypeFromPathOrUri(this.source);
        ToolUtils.SegmentStoreType destType = ToolUtils.storeTypeFromPathOrUri(this.destination);
        String srcDescription = ToolUtils.storeDescription(srcType, this.source);
        String destDescription = ToolUtils.storeDescription(destType, this.destination);
        if (this.flat.booleanValue() && destType == ToolUtils.SegmentStoreType.TAR) {
            try {
                this.srcPersistence = ToolUtils.newSegmentNodeStorePersistence(srcType, this.source);
                SegmentArchiveManager sourceManager = this.srcPersistence.createArchiveManager(false, false, (IOMonitor)new IOMonitorAdapter(), (FileStoreMonitor)new FileStoreMonitorAdapter(), (RemoteStoreMonitor)new RemoteStoreMonitorAdapter());
                int maxArchives = this.maxSizeGb * 4;
                int count = 0;
                List archivesList = sourceManager.listArchives();
                archivesList.sort(Collections.reverseOrder());
                for (String archiveName : archivesList) {
                    if (count == maxArchives - 1) {
                        ToolUtils.printMessage(this.outWriter, "Stopping transfer after reaching {0} GB at archive {1}", this.maxSizeGb, archiveName);
                    }
                    ToolUtils.printMessage(this.outWriter, "{0}/{1} -> {2}", this.source, archiveName, this.destination);
                    SegmentArchiveReader reader = sourceManager.forceOpen(archiveName);
                    ArrayList<Future<SegmentStoreMigrator.Segment>> futures = new ArrayList<Future<SegmentStoreMigrator.Segment>>();
                    for (SegmentArchiveEntry entry : reader.listSegments()) {
                        futures.add(this.executor.submit(() -> SegmentStoreMigrator.runWithRetry(() -> {
                            SegmentStoreMigrator.Segment segment = new SegmentStoreMigrator.Segment(entry);
                            segment.read(reader);
                            return segment;
                        }, 16, 5)));
                    }
                    File directory = new File(this.destination);
                    directory.mkdir();
                    for (Future future : futures) {
                        SegmentStoreMigrator.Segment segment = (SegmentStoreMigrator.Segment)future.get();
                        SegmentStoreMigrator.runWithRetry(() -> {
                            byte[] array = segment.data.array();
                            String segmentId = new UUID(segment.entry.getMsb(), segment.entry.getLsb()).toString();
                            File segmentFile = new File(directory, segmentId);
                            File tempSegmentFile = new File(directory, segmentId + System.nanoTime() + ".part");
                            Buffer buffer = Buffer.wrap((byte[])array);
                            Buffer bufferCopy = buffer.duplicate();
                            try {
                                try (FileChannel channel = new FileOutputStream(tempSegmentFile).getChannel();){
                                    bufferCopy.write((WritableByteChannel)channel);
                                }
                                try {
                                    Files.move(tempSegmentFile.toPath(), segmentFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                                }
                                catch (AtomicMoveNotSupportedException e) {
                                    Files.move(tempSegmentFile.toPath(), segmentFile.toPath(), new CopyOption[0]);
                                }
                            }
                            catch (Exception e) {
                                ToolUtils.printMessage(this.errWriter, "Error writing segment {0} to cache: {1} ", segmentId, e);
                                e.printStackTrace(this.errWriter);
                                try {
                                    Files.deleteIfExists(segmentFile.toPath());
                                    Files.deleteIfExists(tempSegmentFile.toPath());
                                }
                                catch (IOException i) {
                                    ToolUtils.printMessage(this.errWriter, "Error while deleting corrupted segment file {0} {1}", segmentId, i);
                                }
                            }
                            return null;
                        }, 16, 5);
                    }
                    ++count;
                }
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                watch.stop();
                ToolUtils.printMessage(this.errWriter, "A problem occured while copying archives from {0} to {1} ", this.source, this.destination);
                e.printStackTrace(this.errWriter);
                return 1;
            }
        } else {
            try {
                if (this.srcPersistence == null || this.destPersistence == null) {
                    this.srcPersistence = ToolUtils.newSegmentNodeStorePersistence(srcType, this.source);
                    this.destPersistence = ToolUtils.newSegmentNodeStorePersistence(destType, this.destination);
                }
                ToolUtils.printMessage(this.outWriter, "Started segment-copy transfer!", new Object[0]);
                ToolUtils.printMessage(this.outWriter, "Source: {0}", srcDescription);
                ToolUtils.printMessage(this.outWriter, "Destination: {0}", destDescription);
                SegmentStoreMigrator migrator = new SegmentStoreMigrator.Builder().withSourcePersistence(this.srcPersistence, srcDescription).withTargetPersistence(this.destPersistence, destDescription).withRevisionCount(this.revisionCount).build();
                migrator.migrate();
            }
            catch (Exception e) {
                watch.stop();
                ToolUtils.printMessage(this.errWriter, "A problem occured while copying archives from {0} to {1} ", this.source, this.destination);
                e.printStackTrace(this.errWriter);
                return 1;
            }
        }
        watch.stop();
        ToolUtils.printMessage(this.outWriter, "Segment-copy succeeded in {0}", ToolUtils.printableStopwatch(watch));
        return 0;
    }

    public static class Builder {
        private String source;
        private String destination;
        private SegmentNodeStorePersistence srcPersistence;
        private SegmentNodeStorePersistence destPersistence;
        private PrintWriter outWriter;
        private PrintWriter errWriter;
        private Integer revisionsCount = Integer.MAX_VALUE;
        private Boolean flat = false;
        private Integer maxSizeGb = 1;

        private Builder() {
        }

        public Builder withSource(String source) {
            this.source = (String)Preconditions.checkNotNull((Object)source);
            return this;
        }

        public Builder withDestination(String destination) {
            this.destination = (String)Preconditions.checkNotNull((Object)destination);
            return this;
        }

        public Builder withSrcPersistencee(SegmentNodeStorePersistence srcPersistence) {
            this.srcPersistence = (SegmentNodeStorePersistence)Preconditions.checkNotNull((Object)srcPersistence);
            return this;
        }

        public Builder withDestPersistence(SegmentNodeStorePersistence destPersistence) {
            this.destPersistence = (SegmentNodeStorePersistence)Preconditions.checkNotNull((Object)destPersistence);
            return this;
        }

        public Builder withOutWriter(PrintWriter outWriter) {
            this.outWriter = outWriter;
            return this;
        }

        public Builder withErrWriter(PrintWriter errWriter) {
            this.errWriter = errWriter;
            return this;
        }

        public Builder withRevisionsCount(Integer revisionsCount) {
            this.revisionsCount = revisionsCount;
            return this;
        }

        public Builder withFlat(Boolean flat) {
            this.flat = flat;
            return this;
        }

        public Builder withMaxSizeGb(Integer maxSizeGb) {
            this.maxSizeGb = maxSizeGb;
            return this;
        }

        public SegmentCopy build() {
            if (this.srcPersistence == null && this.destPersistence == null) {
                Preconditions.checkNotNull((Object)this.source);
                Preconditions.checkNotNull((Object)this.destination);
            }
            return new SegmentCopy(this);
        }
    }
}

