/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure.tool;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.jackrabbit.oak.segment.azure.tool.ToolUtils;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.split.SplitPersistence;

public class AzureCompact {
    private final String path;
    private final String targetPath;
    private final int segmentCacheSize;
    private final boolean strictVersionCheck;
    private final long gcLogInterval;
    private final SegmentGCOptions.CompactorType compactorType;
    private String persistentCachePath;
    private Integer persistentCacheSizeGb;

    public static Builder builder() {
        return new Builder();
    }

    private AzureCompact(Builder builder) {
        this.path = builder.path;
        this.targetPath = builder.targetPath;
        this.segmentCacheSize = builder.segmentCacheSize;
        this.strictVersionCheck = !builder.force;
        this.gcLogInterval = builder.gcLogInterval;
        this.compactorType = builder.compactorType;
        this.persistentCachePath = builder.persistentCachePath;
        this.persistentCacheSizeGb = builder.persistentCacheSizeGb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run() throws IOException, StorageException, URISyntaxException {
        Stopwatch watch = Stopwatch.createStarted();
        SegmentNodeStorePersistence roPersistence = ToolUtils.newSegmentNodeStorePersistence(ToolUtils.SegmentStoreType.AZURE, this.path, this.persistentCachePath, this.persistentCacheSizeGb);
        SegmentNodeStorePersistence rwPersistence = ToolUtils.newSegmentNodeStorePersistence(ToolUtils.SegmentStoreType.AZURE, this.targetPath);
        SplitPersistence splitPersistence = new SplitPersistence(roPersistence, rwPersistence);
        SegmentArchiveManager roArchiveManager = ToolUtils.createArchiveManager(roPersistence);
        SegmentArchiveManager rwArchiveManager = ToolUtils.createArchiveManager(rwPersistence);
        System.out.printf("Compacting %s\n", this.path);
        System.out.printf(" to %s\n", this.targetPath);
        System.out.printf("    before\n", new Object[0]);
        List beforeArchives = Collections.emptyList();
        try {
            beforeArchives = roArchiveManager.listArchives();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        AzureCompact.printArchives(System.out, beforeArchives);
        System.out.printf("    -> compacting\n", new Object[0]);
        try (FileStore store = ToolUtils.newFileStore((SegmentNodeStorePersistence)splitPersistence, Files.createTempDir(), this.strictVersionCheck, this.segmentCacheSize, this.gcLogInterval, this.compactorType);){
            if (!store.compactFull()) {
                System.out.printf("Compaction cancelled after %s.\n", ToolUtils.printableStopwatch(watch));
                int n = 1;
                return n;
            }
            System.out.printf("    -> [skipping] cleaning up\n", new Object[0]);
        }
        catch (Exception e) {
            watch.stop();
            e.printStackTrace(System.err);
            System.out.printf("Compaction failed after %s.\n", ToolUtils.printableStopwatch(watch));
            return 1;
        }
        watch.stop();
        System.out.printf("    after\n", new Object[0]);
        List afterArchives = Collections.emptyList();
        try {
            afterArchives = rwArchiveManager.listArchives();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        AzureCompact.printArchives(System.out, afterArchives);
        System.out.printf("Compaction succeeded in %s.\n", ToolUtils.printableStopwatch(watch));
        CloudBlobDirectory targetDirectory = ToolUtils.createCloudBlobDirectory(this.targetPath.substring(3));
        CloudBlobContainer targetContainer = targetDirectory.getContainer();
        this.printTargetRepoSizeInfo(targetContainer);
        return 0;
    }

    private long printTargetRepoSizeInfo(CloudBlobContainer container) {
        System.out.printf("Calculating the size of container %s\n", container.getName());
        long size = 0L;
        for (ListBlobItem i : container.listBlobs(null, true, EnumSet.of(BlobListingDetails.METADATA), null, null)) {
            if (!(i instanceof CloudBlob)) continue;
            size += ((CloudBlob)i).getProperties().getLength();
        }
        System.out.printf("The size is: %d MB \n", size / 1024L / 1024L);
        return size;
    }

    private static void printArchives(PrintStream s, List<String> archives) {
        for (String a : archives) {
            s.printf("        %s\n", a);
        }
    }

    public static class Builder {
        private String path;
        private String targetPath;
        private boolean force;
        private long gcLogInterval = 150000L;
        private int segmentCacheSize = 2048;
        private SegmentGCOptions.CompactorType compactorType = SegmentGCOptions.CompactorType.CHECKPOINT_COMPACTOR;
        private String persistentCachePath;
        private Integer persistentCacheSizeGb;

        private Builder() {
        }

        public Builder withPath(String path) {
            this.path = (String)Preconditions.checkNotNull((Object)path);
            return this;
        }

        public Builder withTargetPath(String targetPath) {
            this.targetPath = (String)Preconditions.checkNotNull((Object)targetPath);
            return this;
        }

        public Builder withForce(boolean force) {
            this.force = force;
            return this;
        }

        public Builder withSegmentCacheSize(int segmentCacheSize) {
            Preconditions.checkArgument((segmentCacheSize > 0 ? 1 : 0) != 0, (Object)"segmentCacheSize must be strictly positive");
            this.segmentCacheSize = segmentCacheSize;
            return this;
        }

        public Builder withGCLogInterval(long gcLogInterval) {
            this.gcLogInterval = gcLogInterval;
            return this;
        }

        public Builder withCompactorType(SegmentGCOptions.CompactorType compactorType) {
            this.compactorType = compactorType;
            return this;
        }

        public Builder withPersistentCachePath(String persistentCachePath) {
            this.persistentCachePath = (String)Preconditions.checkNotNull((Object)persistentCachePath);
            return this;
        }

        public Builder withPersistentCacheSizeGb(Integer persistentCacheSizeGb) {
            this.persistentCacheSizeGb = (Integer)Preconditions.checkNotNull((Object)persistentCacheSizeGb);
            return this;
        }

        public AzureCompact build() {
            Preconditions.checkNotNull((Object)this.path);
            return new AzureCompact(this);
        }
    }
}

