/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.UUID;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.azure.AzureBlobMetadata;
import org.apache.jackrabbit.oak.segment.azure.AzureUtilities;
import org.apache.jackrabbit.oak.segment.remote.AbstractRemoteSegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.remote.RemoteSegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;

public class AzureSegmentArchiveReader
extends AbstractRemoteSegmentArchiveReader {
    private final CloudBlobDirectory archiveDirectory;
    private final long length;

    AzureSegmentArchiveReader(CloudBlobDirectory archiveDirectory, IOMonitor ioMonitor) throws IOException {
        super(ioMonitor);
        this.archiveDirectory = archiveDirectory;
        this.length = this.computeArchiveIndexAndLength();
    }

    public long length() {
        return this.length;
    }

    public String getName() {
        return AzureUtilities.getName(this.archiveDirectory);
    }

    protected long computeArchiveIndexAndLength() throws IOException {
        long length = 0L;
        for (CloudBlob blob : AzureUtilities.getBlobs(this.archiveDirectory)) {
            HashMap<String, String> metadata = blob.getMetadata();
            if (AzureBlobMetadata.isSegment(metadata)) {
                RemoteSegmentArchiveEntry indexEntry = AzureBlobMetadata.toIndexEntry(metadata, (int)blob.getProperties().getLength());
                this.index.put(new UUID(indexEntry.getMsb(), indexEntry.getLsb()), indexEntry);
            }
            length += blob.getProperties().getLength();
        }
        return length;
    }

    protected void doReadSegmentToBuffer(String segmentFileName, Buffer buffer) throws IOException {
        AzureUtilities.readBufferFully(this.getBlob(segmentFileName), buffer);
    }

    protected Buffer doReadDataFile(String extension) throws IOException {
        return this.readBlob(this.getName() + extension);
    }

    protected File archivePathAsFile() {
        return new File(this.archiveDirectory.getUri().getPath());
    }

    private CloudBlockBlob getBlob(String name) throws IOException {
        try {
            return this.archiveDirectory.getBlockBlobReference(name);
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private Buffer readBlob(String name) throws IOException {
        try {
            CloudBlockBlob blob = this.getBlob(name);
            if (!blob.exists()) {
                return null;
            }
            long length = blob.getProperties().getLength();
            Buffer buffer = Buffer.allocate((int)((int)length));
            AzureUtilities.readBufferFully(blob, buffer);
            return buffer;
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }
}

