/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3Directory {
    private static final Logger log = LoggerFactory.getLogger(AwsContext.class);
    private final AmazonS3 s3;
    private final String bucketName;
    private final String rootDirectory;

    public S3Directory(AmazonS3 s3, String bucketName, String rootDirectory) {
        this.s3 = s3;
        this.bucketName = bucketName;
        rootDirectory = rootDirectory.startsWith("/") ? rootDirectory.substring(1) : rootDirectory;
        this.rootDirectory = rootDirectory.endsWith("/") ? rootDirectory : rootDirectory + "/";
    }

    public S3Directory withDirectory(String childDirectory) {
        return new S3Directory(this.s3, this.bucketName, this.rootDirectory + childDirectory);
    }

    public void ensureBucket() throws IOException {
        try {
            if (!this.s3.doesBucketExistV2(this.bucketName)) {
                this.s3.createBucket(this.bucketName);
            }
        }
        catch (AmazonServiceException e) {
            throw new IOException(e);
        }
    }

    public String getConfig() {
        return this.bucketName + ";" + this.rootDirectory;
    }

    public String getPath() {
        return this.rootDirectory;
    }

    public boolean doesObjectExist(String name) {
        try {
            return this.s3.doesObjectExist(this.bucketName, this.rootDirectory + name);
        }
        catch (AmazonServiceException e) {
            log.error("Can't check if the manifest exists", (Throwable)e);
            return false;
        }
    }

    public S3Object getObject(String name) throws IOException {
        try {
            GetObjectRequest request = new GetObjectRequest(this.bucketName, this.rootDirectory + name);
            return this.s3.getObject(request);
        }
        catch (AmazonServiceException e) {
            throw new IOException(e);
        }
    }

    public ObjectMetadata getObjectMetadata(String key) {
        return this.s3.getObjectMetadata(this.bucketName, key);
    }

    public Buffer readObjectToBuffer(String name, boolean offHeap) throws IOException {
        byte[] data = this.readObject(this.rootDirectory + name);
        Buffer buffer = offHeap ? Buffer.allocateDirect((int)data.length) : Buffer.allocate((int)data.length);
        buffer.put(data);
        buffer.flip();
        return buffer;
    }

    public void readObjectToBuffer(String name, Buffer buffer) throws IOException {
        byte[] data = this.readObject(this.rootDirectory + name);
        buffer.put(data);
        buffer.flip();
    }

    public byte[] readObject(String key) throws IOException {
        byte[] byArray;
        block17: {
            S3Object object = this.s3.getObject(this.bucketName, key);
            try {
                int length = (int)object.getObjectMetadata().getContentLength();
                byte[] data = new byte[length];
                if (length > 0) {
                    try (S3ObjectInputStream stream = object.getObjectContent();){
                        int read;
                        int off = 0;
                        for (int remaining = length; remaining > 0; remaining -= read) {
                            read = ((InputStream)stream).read(data, off, remaining);
                            off += read;
                        }
                    }
                }
                byArray = data;
                if (object == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AmazonServiceException e) {
                    throw new IOException(e);
                }
            }
            object.close();
        }
        return byArray;
    }

    public void writeObject(String name, byte[] data) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(data.length);
        PutObjectRequest request = new PutObjectRequest(this.bucketName, this.rootDirectory + name, input, metadata);
        try {
            this.s3.putObject(request);
        }
        catch (AmazonServiceException e) {
            throw new IOException(e);
        }
    }

    public void putObject(String name, InputStream input) throws IOException {
        try {
            byte[] bytes = IOUtils.toByteArray(input);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(bytes.length);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            PutObjectRequest request = new PutObjectRequest(this.bucketName, this.rootDirectory + name, byteArrayInputStream, metadata);
            this.s3.putObject(request);
        }
        catch (AmazonServiceException e) {
            throw new IOException(e);
        }
    }

    public void copyObject(S3Directory from, String fromKey) throws IOException {
        String toKey = this.rootDirectory + fromKey.substring(from.rootDirectory.length());
        try {
            this.s3.copyObject(new CopyObjectRequest(from.bucketName, fromKey, this.bucketName, toKey));
        }
        catch (AmazonServiceException e) {
            throw new IOException(e);
        }
    }

    public boolean deleteObjects(List<DeleteObjectsRequest.KeyVersion> keys) {
        try {
            DeleteObjectsRequest request = new DeleteObjectsRequest(this.bucketName).withKeys(keys);
            this.s3.deleteObjects(request);
            return true;
        }
        catch (AmazonServiceException e) {
            log.error("Can't delete objects from {}", (Object)this.rootDirectory, (Object)e);
            return false;
        }
    }

    public boolean deleteAllObjects() {
        try {
            List<DeleteObjectsRequest.KeyVersion> keys = this.listObjects("").stream().map(i -> new DeleteObjectsRequest.KeyVersion(i.getKey())).collect(Collectors.toList());
            return this.deleteObjects(keys);
        }
        catch (IOException e) {
            log.error("Can't delete objects from {}", (Object)this.rootDirectory, (Object)e);
            return false;
        }
    }

    public List<String> listPrefixes() throws IOException {
        return this.listObjectsInternal("", result -> result.getCommonPrefixes());
    }

    public List<S3ObjectSummary> listObjects(String prefix) throws IOException {
        return this.listObjectsInternal(prefix, result -> result.getObjectSummaries());
    }

    private <T> List<T> listObjectsInternal(String prefix, Function<ListObjectsV2Result, List<T>> callback) throws IOException {
        ListObjectsV2Result result;
        ArrayList objects = new ArrayList();
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(this.bucketName).withPrefix(this.rootDirectory + prefix).withDelimiter("/");
        do {
            try {
                result = this.s3.listObjectsV2(request);
            }
            catch (AmazonServiceException e) {
                throw new IOException(e);
            }
            objects.addAll(callback.apply(result));
            request.setContinuationToken(result.getContinuationToken());
        } while (result.isTruncated());
        return objects;
    }
}

