/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.services.dynamodbv2.document.Item;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.oak.segment.aws.DynamoDBClient;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsJournalFile
implements JournalFile {
    private static final Logger log = LoggerFactory.getLogger(AwsJournalFile.class);
    private final DynamoDBClient dynamoDBClient;
    private final String fileName;

    public AwsJournalFile(DynamoDBClient dynamoDBClient, String fileName) {
        this.dynamoDBClient = dynamoDBClient;
        this.fileName = fileName;
    }

    public JournalFileReader openJournalReader() throws IOException {
        return new AwsFileReader(this.dynamoDBClient, this.fileName);
    }

    public JournalFileWriter openJournalWriter() throws IOException {
        return new AwsFileWriter(this.dynamoDBClient, this.fileName);
    }

    public String getName() {
        return this.fileName;
    }

    public boolean exists() {
        try {
            return this.openJournalReader().readLine() != null;
        }
        catch (IOException e) {
            log.error("Can't check if the file exists", (Throwable)e);
            return false;
        }
    }

    private static class AwsFileReader
    implements JournalFileReader {
        private final DynamoDBClient dynamoDBClient;
        private final String fileName;
        private Iterator<Item> iterator;

        public AwsFileReader(DynamoDBClient dynamoDBClient, String fileName) {
            this.dynamoDBClient = dynamoDBClient;
            this.fileName = fileName;
        }

        public void close() {
        }

        public String readLine() throws IOException {
            if (this.iterator == null) {
                this.iterator = this.dynamoDBClient.getDocumentsStream(this.fileName).iterator();
            }
            if (this.iterator.hasNext()) {
                return this.iterator.next().getString("content");
            }
            return null;
        }
    }

    private static class AwsFileWriter
    implements JournalFileWriter {
        private final DynamoDBClient dynamoDBClient;
        private final String fileName;

        public AwsFileWriter(DynamoDBClient dynamoDBClient, String fileName) {
            this.dynamoDBClient = dynamoDBClient;
            this.fileName = fileName;
        }

        public void close() {
        }

        public void truncate() throws IOException {
            this.dynamoDBClient.deleteAllDocuments(this.fileName);
        }

        public void writeLine(String line) throws IOException {
            this.dynamoDBClient.putDocument(this.fileName, line);
        }

        public void batchWriteLines(List<String> lines) throws IOException {
            this.dynamoDBClient.batchPutDocument(this.fileName, lines);
        }
    }
}

