/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws.tool;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.apache.jackrabbit.oak.segment.aws.AwsPersistence;
import org.apache.jackrabbit.oak.segment.aws.Configuration;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.tar.TarPersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;

public class AwsToolUtils {
    private AwsToolUtils() {
    }

    public static FileStore newFileStore(SegmentNodeStorePersistence persistence, File directory, boolean strictVersionCheck, int segmentCacheSize, long gcLogInterval) throws IOException, InvalidFileStoreVersionException, URISyntaxException {
        FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder((File)directory).withCustomPersistence(persistence).withMemoryMapping(false).withStrictVersionCheck(strictVersionCheck).withSegmentCacheSize(segmentCacheSize).withGCOptions(SegmentGCOptions.defaultGCOptions().setOffline().setGCLogInterval(gcLogInterval));
        return builder.build();
    }

    public static SegmentNodeStorePersistence newSegmentNodeStorePersistence(SegmentStoreType storeType, String pathOrUri) throws IOException {
        Object persistence = null;
        switch (storeType) {
            case AWS: {
                final String[] parts = pathOrUri.substring(4).split(";");
                Configuration configuration = new Configuration(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return null;
                    }

                    @Override
                    public String sessionToken() {
                        return null;
                    }

                    @Override
                    public String secretKey() {
                        return null;
                    }

                    @Override
                    public String rootDirectory() {
                        return parts[1];
                    }

                    @Override
                    public String region() {
                        return null;
                    }

                    @Override
                    public String lockTableName() {
                        return parts[3];
                    }

                    @Override
                    public String journalTableName() {
                        return parts[2];
                    }

                    @Override
                    public String bucketName() {
                        return parts[0];
                    }

                    @Override
                    public String accessKey() {
                        return null;
                    }
                };
                AwsContext awsContext = AwsContext.create(configuration);
                persistence = new AwsPersistence(awsContext);
                break;
            }
            default: {
                persistence = new TarPersistence(new File(pathOrUri));
            }
        }
        return persistence;
    }

    public static SegmentStoreType storeTypeFromPathOrUri(String pathOrUri) {
        if (pathOrUri.startsWith("aws:")) {
            return SegmentStoreType.AWS;
        }
        return SegmentStoreType.TAR;
    }

    public static String storeDescription(SegmentStoreType storeType, String pathOrUri) {
        return storeType.description(pathOrUri);
    }

    public static String printableStopwatch(Stopwatch s) {
        return String.format("%s (%ds)", s, s.elapsed(TimeUnit.SECONDS));
    }

    public static void printMessage(PrintWriter pw, String format, Object ... arg) {
        pw.println(MessageFormat.format(format, arg));
    }

    public static byte[] fetchByteArray(Buffer buffer) throws IOException {
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        return data;
    }

    public static enum SegmentStoreType {
        TAR("TarMK Segment Store"),
        AWS("AWS Segment Store");

        private String type;

        private SegmentStoreType(String type) {
            this.type = type;
        }

        public String description(String pathOrUri) {
            String location = pathOrUri;
            if (pathOrUri.startsWith("aws:")) {
                location = pathOrUri.substring(3);
            }
            return this.type + "@" + location;
        }
    }
}

