/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.S3Object;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;
import org.apache.jackrabbit.oak.segment.aws.S3Directory;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;

public class AwsManifestFile
implements ManifestFile {
    private final S3Directory directory;
    private final String manifestFile;

    public AwsManifestFile(S3Directory directory, String manifestFile) throws IOException {
        this.directory = directory;
        this.manifestFile = manifestFile;
    }

    public boolean exists() {
        return this.directory.doesObjectExist(this.manifestFile);
    }

    public Properties load() throws IOException {
        Properties properties = new Properties();
        if (this.exists()) {
            try (S3Object object = this.directory.getObject(this.manifestFile);){
                properties.load(object.getObjectContent());
            }
            catch (AmazonServiceException e) {
                throw new IOException(e);
            }
        }
        return properties;
    }

    public void save(Properties properties) throws IOException {
        try (PipedInputStream input = new PipedInputStream();){
            try (PipedOutputStream src = new PipedOutputStream(input);){
                properties.store(src, null);
            }
            this.directory.putObject(this.manifestFile, input);
        }
    }
}

