/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws.tool;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import com.amazonaws.services.s3.AmazonS3;
import java.io.IOException;
import java.util.Date;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.apache.jackrabbit.oak.segment.aws.S3MockRule;
import org.apache.jackrabbit.oak.segment.aws.tool.SegmentCopyTestBase;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.junit.Before;
import org.junit.ClassRule;

public class SegmentCopyTarToAwsTest
extends SegmentCopyTestBase {
    @ClassRule
    public static final S3MockRule s3Mock = new S3MockRule();

    @Before
    public void setUp() throws IOException {
        AmazonS3 s3 = s3Mock.createClient();
        AmazonDynamoDB ddb = DynamoDBEmbedded.create().amazonDynamoDB();
        long time = new Date().getTime();
        this.bucketName = "bucket-" + time;
        this.rootDirectory = "repository";
        this.journalTable = "journaltable-" + time;
        this.lockTable = "locktable-" + time;
        this.awsContext = AwsContext.create((AmazonS3)s3, (String)this.bucketName, (String)"repository", (AmazonDynamoDB)ddb, (String)this.journalTable, (String)this.lockTable);
    }

    @Override
    protected SegmentNodeStorePersistence getSrcPersistence() throws IOException {
        return this.getTarPersistence();
    }

    @Override
    protected SegmentNodeStorePersistence getDestPersistence() throws IOException {
        return this.getAwsPersistence();
    }

    @Override
    protected String getSrcPathOrUri() {
        return this.folder.getRoot().getAbsolutePath();
    }

    @Override
    protected String getDestPathOrUri() {
        return this.awsContext.getConfig();
    }
}

