/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import java.io.IOException;
import java.util.Date;
import org.apache.jackrabbit.oak.segment.aws.AwsJournalFile;
import org.apache.jackrabbit.oak.segment.aws.DynamoDBClient;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AwsJournalFileTest {
    private AwsJournalFile journal;

    @Before
    public void setup() throws IOException {
        AmazonDynamoDB ddb = DynamoDBEmbedded.create().amazonDynamoDB();
        long time = new Date().getTime();
        DynamoDBClient dynamoDBClient = new DynamoDBClient(ddb, "journaltable-" + time, "locktable-" + time);
        dynamoDBClient.ensureTables();
        this.journal = new AwsJournalFile(dynamoDBClient, "journal.log");
    }

    @Test
    public void testReadFromJournalFile() throws IOException, InterruptedException {
        Assert.assertFalse((boolean)this.journal.exists());
        JournalFileWriter writer = this.journal.openJournalWriter();
        for (int i = 0; i < 100; ++i) {
            writer.writeLine("line " + i);
        }
        JournalFileReader reader = this.journal.openJournalReader();
        for (int i = 99; i >= 0; --i) {
            Assert.assertEquals((Object)("line " + i), (Object)reader.readLine());
        }
    }

    @Test
    public void testTruncateJournalFile() throws IOException {
        Assert.assertFalse((boolean)this.journal.exists());
        JournalFileWriter writer = this.journal.openJournalWriter();
        for (int i = 0; i < 100; ++i) {
            writer.writeLine("line " + i);
        }
        Assert.assertTrue((boolean)this.journal.exists());
        writer.truncate();
        Assert.assertFalse((boolean)this.journal.exists());
    }
}

