/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import java.io.IOException;
import java.util.Date;
import org.apache.jackrabbit.oak.segment.aws.AwsGCJournalFile;
import org.apache.jackrabbit.oak.segment.aws.DynamoDBClient;
import org.apache.jackrabbit.oak.segment.file.GcJournalTest;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.GCJournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.RepositoryLock;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class AwsGCJournalFileTest
extends GcJournalTest {
    private DynamoDBClient dynamoDBClient;

    @Before
    public void setup() throws IOException {
        AmazonDynamoDB ddb = DynamoDBEmbedded.create().amazonDynamoDB();
        long time = new Date().getTime();
        this.dynamoDBClient = new DynamoDBClient(ddb, "journaltable-" + time, "locktable-" + time);
        this.dynamoDBClient.ensureTables();
    }

    protected SegmentNodeStorePersistence getPersistence() throws Exception {
        return new MockPersistence(this.dynamoDBClient);
    }

    @Test
    public void tarGcJournal() throws Exception {
        super.tarGcJournal();
    }

    @Test
    @Ignore
    public void testReadOak16GCLog() throws Exception {
        super.testReadOak16GCLog();
    }

    @Test
    @Ignore
    public void testUpdateOak16GCLog() throws Exception {
        super.testUpdateOak16GCLog();
    }

    private static class MockPersistence
    implements SegmentNodeStorePersistence {
        private final DynamoDBClient dynamoDBClient;

        public MockPersistence(DynamoDBClient dynamoDBClient) {
            this.dynamoDBClient = dynamoDBClient;
        }

        public SegmentArchiveManager createArchiveManager(boolean arg0, boolean arg1, IOMonitor arg2, FileStoreMonitor arg3, RemoteStoreMonitor arg4) throws IOException {
            throw new IOException();
        }

        public GCJournalFile getGCJournalFile() throws IOException {
            return new AwsGCJournalFile(this.dynamoDBClient, "gc.log");
        }

        public JournalFile getJournalFile() {
            return null;
        }

        public ManifestFile getManifestFile() throws IOException {
            throw new IOException();
        }

        public RepositoryLock lockRepository() throws IOException {
            throw new IOException();
        }

        public boolean segmentFilesExist() {
            return true;
        }
    }
}

