/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.split;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import com.amazonaws.services.s3.AmazonS3;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.OakFileDataStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.aws.AwsContext;
import org.apache.jackrabbit.oak.segment.aws.AwsPersistence;
import org.apache.jackrabbit.oak.segment.aws.S3MockRule;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.tar.TarPersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.split.SplitPersistence;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SplitPersistenceBlobTest {
    @ClassRule
    public static final S3MockRule s3Mock = new S3MockRule();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder(new File("target"));
    private SegmentNodeStore base;
    private SegmentNodeStore split;
    private FileStore baseFileStore;
    private FileStore splitFileStore;
    private String baseBlobId;
    private SegmentNodeStorePersistence splitPersistence;

    @Before
    public void setup() throws IOException, InvalidFileStoreVersionException, CommitFailedException {
        AmazonS3 s3 = s3Mock.createClient();
        AmazonDynamoDB ddb = DynamoDBEmbedded.create().amazonDynamoDB();
        long time = new Date().getTime();
        AwsContext awsContext = AwsContext.create((AmazonS3)s3, (String)("bucket-" + time), (String)"oak", (AmazonDynamoDB)ddb, (String)("journaltable-" + time), (String)("locktable-" + time));
        AwsPersistence sharedPersistence = new AwsPersistence(awsContext);
        File dataStoreDir = new File(this.folder.getRoot(), "blobstore");
        BlobStore blobStore = SplitPersistenceBlobTest.newBlobStore(dataStoreDir);
        this.baseFileStore = FileStoreBuilder.fileStoreBuilder((File)this.folder.newFolder()).withCustomPersistence((SegmentNodeStorePersistence)sharedPersistence).withBlobStore(blobStore).build();
        this.base = SegmentNodeStoreBuilders.builder((FileStore)this.baseFileStore).build();
        NodeBuilder builder = this.base.getRoot().builder();
        builder.child("foo").child("bar").setProperty("version", (Object)"v1");
        this.base.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        this.baseBlobId = this.createLoad(this.base, this.baseFileStore).getContentIdentity();
        this.baseFileStore.flush();
        this.baseFileStore.close();
        this.baseFileStore = FileStoreBuilder.fileStoreBuilder((File)this.folder.newFolder()).withCustomPersistence((SegmentNodeStorePersistence)sharedPersistence).withBlobStore(blobStore).build();
        this.base = SegmentNodeStoreBuilders.builder((FileStore)this.baseFileStore).build();
        this.createLoad(this.base, this.baseFileStore).getContentIdentity();
        this.baseFileStore.flush();
        TarPersistence localPersistence = new TarPersistence(this.folder.newFolder());
        this.splitPersistence = new SplitPersistence((SegmentNodeStorePersistence)sharedPersistence, (SegmentNodeStorePersistence)localPersistence);
        this.splitFileStore = FileStoreBuilder.fileStoreBuilder((File)this.folder.newFolder()).withCustomPersistence(this.splitPersistence).withBlobStore(blobStore).build();
        this.split = SegmentNodeStoreBuilders.builder((FileStore)this.splitFileStore).build();
    }

    @After
    public void tearDown() {
        this.baseFileStore.close();
    }

    @Test
    public void collectReferences() throws IOException, CommitFailedException {
        String blobId = this.createLoad(this.split, this.splitFileStore).getContentIdentity();
        this.assertReferences(2, Sets.newHashSet((Object[])new String[]{this.baseBlobId, blobId}));
    }

    private static Blob createBlob(NodeStore nodeStore, int size) throws IOException {
        byte[] data = new byte[size];
        new Random().nextBytes(data);
        return nodeStore.createBlob((InputStream)new ByteArrayInputStream(data));
    }

    private static BlobStore newBlobStore(File directory) {
        OakFileDataStore delegate = new OakFileDataStore();
        delegate.setPath(directory.getAbsolutePath());
        delegate.init(null);
        return new DataStoreBlobStore((DataStore)delegate);
    }

    private Blob createLoad(SegmentNodeStore store, FileStore fileStore) throws IOException, CommitFailedException {
        NodeBuilder builder = store.getRoot().builder();
        Blob blob = SplitPersistenceBlobTest.createBlob((NodeStore)store, 18000);
        builder.setProperty("bin", (Object)blob);
        store.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        fileStore.flush();
        return blob;
    }

    private void assertReferences(int count, Set<String> blobIds) throws IOException {
        HashSet actualReferences = Sets.newHashSet();
        this.splitFileStore.collectBlobReferences(actualReferences::add);
        Assert.assertEquals((String)"visible references different", (long)count, (long)actualReferences.size());
        Assert.assertEquals((String)"Binary reference returned should be same", blobIds, (Object)actualReferences);
    }
}

