/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.privilege;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;

public final class PrivilegeBits
implements PrivilegeConstants {
    private static final long NO_PRIVILEGE = 0L;
    private static final long READ_NODES = 1L;
    private static final long READ_PROPERTIES = 2L;
    private static final long ADD_PROPERTIES = 4L;
    private static final long ALTER_PROPERTIES = 8L;
    private static final long REMOVE_PROPERTIES = 16L;
    private static final long ADD_CHILD_NODES = 32L;
    private static final long REMOVE_CHILD_NODES = 64L;
    private static final long REMOVE_NODE = 128L;
    private static final long READ_AC = 256L;
    private static final long MODIFY_AC = 512L;
    private static final long NODE_TYPE_MNGMT = 1024L;
    private static final long VERSION_MNGMT = 2048L;
    private static final long LOCK_MNGMT = 4096L;
    private static final long LIFECYCLE_MNGMT = 8192L;
    private static final long RETENTION_MNGMT = 16384L;
    private static final long WORKSPACE_MNGMT = 32768L;
    private static final long NODE_TYPE_DEF_MNGMT = 65536L;
    private static final long NAMESPACE_MNGMT = 131072L;
    private static final long PRIVILEGE_MNGMT = 262144L;
    private static final long USER_MNGMT = 524288L;
    private static final long INDEX_DEFINITION_MNGMT = 0x100000L;
    private static final long READ = 3L;
    private static final long MODIFY_PROPERTIES = 28L;
    private static final long WRITE = 252L;
    private static final long WRITE2 = 1276L;
    public static final PrivilegeBits EMPTY = new PrivilegeBits(UnmodifiableData.access$000());
    public static final Map<String, PrivilegeBits> BUILT_IN = new HashMap<String, PrivilegeBits>();
    public static final PrivilegeBits NEXT_AFTER_BUILT_INS;
    private final Data d;

    private PrivilegeBits(Data d) {
        this.d = d;
    }

    public static PrivilegeBits getInstance() {
        return new PrivilegeBits(new ModifiableData());
    }

    @Nonnull
    public static PrivilegeBits getInstance(PrivilegeBits ... base) {
        PrivilegeBits bts = PrivilegeBits.getInstance();
        for (PrivilegeBits baseBits : base) {
            bts.add(baseBits);
        }
        return bts;
    }

    @Nonnull
    public static PrivilegeBits getInstance(@Nullable PropertyState property) {
        if (property == null) {
            return EMPTY;
        }
        int size = property.count();
        if (size == 1) {
            return PrivilegeBits.getInstance((Long)property.getValue(Type.LONG, 0));
        }
        long[] longs = new long[size];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = (Long)property.getValue(Type.LONG, i);
        }
        return PrivilegeBits.getInstance(longs);
    }

    @Nonnull
    public static PrivilegeBits getInstance(@Nullable Tree tree) {
        if (tree == null) {
            return EMPTY;
        }
        String privName = tree.getName();
        if (BUILT_IN.containsKey(privName)) {
            return BUILT_IN.get(privName);
        }
        if ("rep:privileges".equals(privName)) {
            return PrivilegeBits.getInstance(tree.getProperty("rep:next"));
        }
        return PrivilegeBits.getInstance(tree.getProperty("rep:bits"));
    }

    @Nonnull
    private static PrivilegeBits getInstance(long bits) {
        if (bits == 0L) {
            return EMPTY;
        }
        Preconditions.checkArgument((bits > 0L ? 1 : 0) != 0);
        return new PrivilegeBits(new UnmodifiableData(bits));
    }

    @Nonnull
    private static PrivilegeBits getInstance(long[] bits) {
        return new PrivilegeBits(new UnmodifiableData(bits));
    }

    public static long calculatePermissions(@Nonnull PrivilegeBits bits, @Nonnull PrivilegeBits parentBits, boolean isAllow) {
        long privs = bits.d.longValue();
        long parentPrivs = parentBits.d.longValue();
        long perm = 0L;
        if ((privs & 3L) == 3L) {
            perm |= 3L;
        } else if ((privs & 1L) == 1L) {
            perm |= 1L;
        } else if ((privs & 2L) == 2L) {
            perm |= 2L;
        }
        if ((privs & 0x1CL) == 28L) {
            perm |= 0x1CL;
        } else {
            if ((privs & 4L) == 4L) {
                perm |= 4L;
            }
            if ((privs & 8L) == 8L) {
                perm |= 8L;
            }
            if ((privs & 0x10L) == 16L) {
                perm |= 0x10L;
            }
        }
        if ((parentPrivs & 0x20L) == 32L) {
            perm |= 0x20L;
        }
        if (isAllow) {
            if ((parentPrivs & 0x40L) == 64L && (privs & 0x80L) == 128L) {
                perm |= 0x40L;
            }
        } else if ((parentPrivs & 0x40L) == 64L || (privs & 0x80L) == 128L) {
            perm |= 0x40L;
        }
        if ((privs & 0x20L) == 32L && (privs & 0x40L) == 64L) {
            perm |= 0x4000L;
        }
        if ((privs & 0x100L) == 256L) {
            perm |= 0x80L;
        }
        if ((privs & 0x200L) == 512L) {
            perm |= 0x100L;
        }
        if ((privs & 0x2000L) == 8192L) {
            perm |= 0x1000L;
        }
        if ((privs & 0x1000L) == 4096L) {
            perm |= 0x800L;
        }
        if ((privs & 0x400L) == 1024L) {
            perm |= 0x200L;
        }
        if ((privs & 0x4000L) == 16384L) {
            perm |= 0x2000L;
        }
        if ((privs & 0x800L) == 2048L) {
            perm |= 0x400L;
        }
        if ((privs & 0x8000L) == 32768L) {
            perm |= 0x20000L;
        }
        if ((privs & 0x10000L) == 65536L) {
            perm |= 0x8000L;
        }
        if ((privs & 0x20000L) == 131072L) {
            perm |= 0x10000L;
        }
        if ((privs & 0x40000L) == 262144L) {
            perm |= 0x40000L;
        }
        if ((privs & 0x80000L) == 524288L) {
            perm |= 0x80000L;
        }
        if ((privs & 0x100000L) == 0x100000L) {
            perm |= 0x100000L;
        }
        return perm;
    }

    public boolean isEmpty() {
        return this.d.isEmpty();
    }

    @Nonnull
    public PrivilegeBits unmodifiable() {
        if (this.d instanceof ModifiableData) {
            if (this.d.isSimple()) {
                return PrivilegeBits.getInstance(this.d.longValue());
            }
            long[] bits = this.d.longValues();
            long[] copy = new long[bits.length];
            System.arraycopy(bits, 0, copy, 0, bits.length);
            return PrivilegeBits.getInstance(copy);
        }
        return this;
    }

    @Nonnull
    public PrivilegeBits modifiable() {
        if (this.d instanceof ModifiableData) {
            return this;
        }
        return PrivilegeBits.getInstance(this);
    }

    public boolean includes(@Nonnull PrivilegeBits otherBits) {
        return this.d.includes(otherBits.d);
    }

    @Nonnull
    public PrivilegeBits add(@Nonnull PrivilegeBits other) {
        if (this.d instanceof ModifiableData) {
            ((ModifiableData)this.d).add(other.d);
            return this;
        }
        throw PrivilegeBits.unsupported();
    }

    @Nonnull
    public PrivilegeBits diff(@Nonnull PrivilegeBits other) {
        if (this.d instanceof ModifiableData) {
            ((ModifiableData)this.d).diff(other.d);
            return this;
        }
        throw PrivilegeBits.unsupported();
    }

    @Nonnull
    public PrivilegeBits addDifference(@Nonnull PrivilegeBits a, @Nonnull PrivilegeBits b) {
        if (this.d instanceof ModifiableData) {
            ((ModifiableData)this.d).addDifference(a.d, b.d);
            return this;
        }
        throw PrivilegeBits.unsupported();
    }

    @Nonnull
    public PrivilegeBits retain(@Nonnull PrivilegeBits other) {
        if (this.d instanceof ModifiableData) {
            ((ModifiableData)this.d).retain(other.d);
            return this;
        }
        throw PrivilegeBits.unsupported();
    }

    @Nonnull
    public PropertyState asPropertyState(String name) {
        return PropertyStates.createProperty((String)name, (Object)Longs.asList((long[])this.d.longValues()), (Type)Type.LONGS);
    }

    @Nonnull
    public PrivilegeBits nextBits() {
        if (this == EMPTY) {
            return EMPTY;
        }
        return new PrivilegeBits(this.d.next());
    }

    public void writeTo(@Nonnull Tree tree) {
        String name = "rep:privileges".equals(tree.getName()) ? "rep:next" : "rep:bits";
        tree.setProperty(this.asPropertyState(name));
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("immutable privilege bits");
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PrivilegeBits) {
            return this.d.equals(((PrivilegeBits)o).d);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PrivilegeBits: ");
        if (this.d.isSimple()) {
            sb.append(this.d.longValue());
        } else {
            sb.append(Arrays.toString(this.d.longValues()));
        }
        return sb.toString();
    }

    static {
        BUILT_IN.put("rep:readNodes", PrivilegeBits.getInstance(1L));
        BUILT_IN.put("rep:readProperties", PrivilegeBits.getInstance(2L));
        BUILT_IN.put("rep:addProperties", PrivilegeBits.getInstance(4L));
        BUILT_IN.put("rep:alterProperties", PrivilegeBits.getInstance(8L));
        BUILT_IN.put("rep:removeProperties", PrivilegeBits.getInstance(16L));
        BUILT_IN.put("jcr:addChildNodes", PrivilegeBits.getInstance(32L));
        BUILT_IN.put("jcr:removeChildNodes", PrivilegeBits.getInstance(64L));
        BUILT_IN.put("jcr:removeNode", PrivilegeBits.getInstance(128L));
        BUILT_IN.put("jcr:readAccessControl", PrivilegeBits.getInstance(256L));
        BUILT_IN.put("jcr:modifyAccessControl", PrivilegeBits.getInstance(512L));
        BUILT_IN.put("jcr:nodeTypeManagement", PrivilegeBits.getInstance(1024L));
        BUILT_IN.put("jcr:versionManagement", PrivilegeBits.getInstance(2048L));
        BUILT_IN.put("jcr:lockManagement", PrivilegeBits.getInstance(4096L));
        BUILT_IN.put("jcr:lifecycleManagement", PrivilegeBits.getInstance(8192L));
        BUILT_IN.put("jcr:retentionManagement", PrivilegeBits.getInstance(16384L));
        BUILT_IN.put("jcr:workspaceManagement", PrivilegeBits.getInstance(32768L));
        BUILT_IN.put("jcr:nodeTypeDefinitionManagement", PrivilegeBits.getInstance(65536L));
        BUILT_IN.put("jcr:namespaceManagement", PrivilegeBits.getInstance(131072L));
        BUILT_IN.put("rep:privilegeManagement", PrivilegeBits.getInstance(262144L));
        BUILT_IN.put("rep:userManagement", PrivilegeBits.getInstance(524288L));
        BUILT_IN.put("rep:indexDefinitionManagement", PrivilegeBits.getInstance(0x100000L));
        BUILT_IN.put("jcr:read", PrivilegeBits.getInstance(3L));
        BUILT_IN.put("jcr:modifyProperties", PrivilegeBits.getInstance(28L));
        BUILT_IN.put("jcr:write", PrivilegeBits.getInstance(252L));
        BUILT_IN.put("rep:write", PrivilegeBits.getInstance(1276L));
        NEXT_AFTER_BUILT_INS = PrivilegeBits.getInstance(0x100000L).nextBits();
    }

    private static final class ModifiableData
    extends Data {
        private long[] bits = new long[]{0L};

        private ModifiableData() {
        }

        @Override
        boolean isEmpty() {
            return this.bits.length == 1 && this.bits[0] == 0L;
        }

        @Override
        long longValue() {
            return this.bits.length == 1 ? this.bits[0] : 0L;
        }

        @Override
        long[] longValues() {
            return this.bits;
        }

        @Override
        boolean isSimple() {
            return this.bits.length == 1;
        }

        @Override
        Data next() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        boolean includes(Data other) {
            if (this.bits.length == 1) {
                return other.isSimple() && ModifiableData.includes(this.bits[0], other.longValue());
            }
            return ModifiableData.includes(this.bits, other.longValues());
        }

        private void add(Data other) {
            if (other != this) {
                if (this.bits.length == 1 && other.isSimple()) {
                    this.bits[0] = this.bits[0] | other.longValue();
                } else {
                    this.or(other.longValues());
                }
            }
        }

        private void diff(Data other) {
            if (this.bits.length == 1 && other.isSimple()) {
                this.bits[0] = this.bits[0] & (other.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                this.bits = ModifiableData.diff(this.bits, other.longValues());
            }
        }

        private void addDifference(Data a, Data b) {
            if (a.isSimple() && b.isSimple()) {
                this.bits[0] = this.bits[0] | a.longValue() & (b.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                long[] diff = ModifiableData.diff(a.longValues(), b.longValues());
                this.or(diff);
            }
        }

        private void or(long[] b) {
            if (b.length > this.bits.length) {
                long[] res = new long[b.length];
                System.arraycopy(this.bits, 0, res, 0, this.bits.length);
                this.bits = res;
            }
            for (int i = 0; i < b.length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] | b[i];
            }
        }

        private void retain(Data other) {
            if (this.isSimple()) {
                this.bits[0] = this.bits[0] & other.longValue();
            } else {
                long[] bLvs;
                long[] lvs = this.longValues();
                long[] res = lvs.length <= (bLvs = other.longValues()).length ? new long[lvs.length] : new long[bLvs.length];
                int compactSize = -1;
                for (int i = 0; i < res.length; ++i) {
                    res[i] = lvs[i] & bLvs[i];
                    if (res[i] == 0L) {
                        if (compactSize != -1) continue;
                        compactSize = i + 1;
                        continue;
                    }
                    compactSize = -1;
                }
                this.bits = compactSize != -1 && res.length > compactSize ? Arrays.copyOfRange(res, 0, compactSize) : res;
            }
        }

        private static long[] diff(long[] a, long[] b) {
            int index = -1;
            long[] res = new long[a.length > b.length ? a.length : b.length];
            for (int i = 0; i < res.length; ++i) {
                if (i < a.length && i < b.length) {
                    res[i] = a[i] & (b[i] ^ 0xFFFFFFFFFFFFFFFFL);
                } else {
                    long l = res[i] = i < a.length ? a[i] : 0L;
                }
                if (res[i] != 0L) {
                    index = -1;
                    continue;
                }
                if (index != -1) continue;
                index = i;
            }
            switch (index) {
                case -1: {
                    return res;
                }
                case 0: {
                    return new long[]{0L};
                }
            }
            long[] r2 = new long[index];
            System.arraycopy(res, 0, r2, 0, index);
            return r2;
        }
    }

    private static final class UnmodifiableData
    extends Data {
        private static final long MAX = 0x3FFFFFFFFFFFFFFFL;
        private static final UnmodifiableData EMPTY = new UnmodifiableData(0L);
        private final long bits;
        private final long[] bitsArr;
        private final boolean isSimple;

        private UnmodifiableData(long bits) {
            this.bits = bits;
            this.bitsArr = new long[]{bits};
            this.isSimple = true;
        }

        private UnmodifiableData(long[] bitsArr) {
            this.bits = 0L;
            this.bitsArr = bitsArr;
            this.isSimple = false;
        }

        @Override
        boolean isEmpty() {
            return this == EMPTY;
        }

        @Override
        long longValue() {
            return this.bits;
        }

        @Override
        long[] longValues() {
            return this.bitsArr;
        }

        @Override
        boolean isSimple() {
            return this.isSimple;
        }

        @Override
        Data next() {
            long[] bts;
            if (this == EMPTY) {
                return EMPTY;
            }
            if (this.isSimple) {
                if (this.bits < 0x3FFFFFFFFFFFFFFFL) {
                    long b = this.bits << 1;
                    return new UnmodifiableData(b);
                }
                return new UnmodifiableData(new long[]{this.bits}).next();
            }
            long last = this.bitsArr[this.bitsArr.length - 1];
            if (last < 0x3FFFFFFFFFFFFFFFL) {
                bts = new long[this.bitsArr.length];
                System.arraycopy(this.bitsArr, 0, bts, 0, this.bitsArr.length);
                bts[bts.length - 1] = last << 1;
            } else {
                bts = new long[this.bitsArr.length + 1];
                bts[bts.length - 1] = 1L;
            }
            return new UnmodifiableData(bts);
        }

        @Override
        boolean includes(Data other) {
            if (this.isSimple) {
                return other.isSimple() && UnmodifiableData.includes(this.bits, other.longValue());
            }
            return UnmodifiableData.includes(this.bitsArr, other.longValues());
        }

        public int hashCode() {
            return this.isSimple ? Long.valueOf(this.bits).hashCode() : Arrays.hashCode(this.bitsArr);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof UnmodifiableData) {
                UnmodifiableData d = (UnmodifiableData)o;
                if (this.isSimple != d.isSimple) {
                    return false;
                }
                if (this.isSimple) {
                    return this.bits == d.bits;
                }
                return Arrays.equals(this.bitsArr, d.bitsArr);
            }
            return false;
        }

        static /* synthetic */ UnmodifiableData access$000() {
            return EMPTY;
        }
    }

    private static abstract class Data {
        private Data() {
        }

        abstract boolean isEmpty();

        abstract long longValue();

        abstract long[] longValues();

        abstract boolean isSimple();

        abstract Data next();

        abstract boolean includes(Data var1);

        static boolean includes(long bits, long otherBits) {
            return (bits | otherBits ^ 0xFFFFFFFFFFFFFFFFL) == -1L;
        }

        static boolean includes(long[] bits, long[] otherBits) {
            if (otherBits.length <= bits.length) {
                for (int i = 0; i < otherBits.length; ++i) {
                    if ((bits[i] | otherBits[i] ^ 0xFFFFFFFFFFFFFFFFL) == -1L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

