/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.GroupPrincipalWrapper;

public final class GroupPrincipals {
    private static final GroupTransformer TRANSFORMER = new GroupTransformer();

    private GroupPrincipals() {
    }

    public static boolean isGroup(@Nonnull Principal principal) {
        return principal instanceof Group || principal instanceof GroupPrincipal;
    }

    public static Enumeration<? extends Principal> members(@Nonnull Principal principal) {
        if (principal instanceof Group) {
            return ((Group)principal).members();
        }
        if (principal instanceof GroupPrincipal) {
            return ((GroupPrincipal)principal).members();
        }
        return Collections.emptyEnumeration();
    }

    public static boolean isMember(@Nonnull Principal principal, @Nonnull Principal member) {
        if (principal instanceof Group) {
            return ((Group)principal).isMember(member);
        }
        if (principal instanceof GroupPrincipal) {
            return ((GroupPrincipal)principal).isMember(member);
        }
        return false;
    }

    public static Set<Principal> transform(Set<Group> groups) {
        ImmutableSet.Builder g2 = ImmutableSet.builder();
        for (Group g : groups) {
            g2.add((Object)new GroupPrincipalWrapper(g));
        }
        return g2.build();
    }

    public static Enumeration<? extends Principal> transform(Enumeration<? extends Principal> members) {
        Iterator m2 = Iterators.transform((Iterator)Iterators.forEnumeration(members), (Function)TRANSFORMER);
        return Iterators.asEnumeration((Iterator)m2);
    }

    private static class GroupTransformer
    implements Function<Principal, Principal> {
        private GroupTransformer() {
        }

        public Principal apply(Principal input) {
            if (input instanceof Group) {
                return new GroupPrincipalWrapper((Group)input);
            }
            return input;
        }
    }
}

