/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.credentials;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Credentials;

public abstract class AbstractCredentials
implements Credentials {
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    protected final String userId;

    public AbstractCredentials(@Nonnull String userId) {
        this.userId = userId;
    }

    @Nonnull
    public String getUserId() {
        return this.userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(@Nonnull String name, @Nullable Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public Object getAttribute(@Nonnull String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(@Nonnull String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.remove(name);
        }
    }

    @Nonnull
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(@Nonnull Map<String, Object> attributes) {
        Map<String, Object> map = attributes;
        synchronized (map) {
            this.attributes.putAll(attributes);
        }
    }
}

