/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;

public abstract class TreeLocation {
    public static TreeLocation create(@Nonnull Tree tree) {
        return new NodeLocation(tree);
    }

    public static TreeLocation create(Root root, String path) {
        Preconditions.checkArgument((boolean)PathUtils.isAbsolute((String)path));
        TreeLocation location = TreeLocation.create(root.getTree("/"));
        for (String name : PathUtils.elements((String)path)) {
            location = location.getChild(name);
        }
        return location;
    }

    public static TreeLocation create(Root root) {
        return TreeLocation.create(root, "/");
    }

    @Nonnull
    public abstract TreeLocation getParent();

    public abstract boolean exists();

    @Nonnull
    public abstract String getName();

    @Nonnull
    public abstract String getPath();

    public abstract boolean remove();

    @Nonnull
    public TreeLocation getChild(String name) {
        return new NullLocation(this, name);
    }

    @CheckForNull
    public Tree getTree() {
        return null;
    }

    @CheckForNull
    public PropertyState getProperty() {
        return null;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("path", (Object)this.getPath()).toString();
    }

    private static final class NullLocation
    extends TreeLocation {
        public static final NullLocation NULL = new NullLocation();
        private final TreeLocation parent;
        private final String name;

        public NullLocation(TreeLocation parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        private NullLocation() {
            this.parent = this;
            this.name = "";
        }

        @Override
        @Nonnull
        public TreeLocation getParent() {
            return this.parent;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        @Nonnull
        public String getPath() {
            return this.parent == this ? "" : PathUtils.concat((String)this.parent.getPath(), (String)this.name);
        }

        @Override
        public boolean remove() {
            return false;
        }
    }

    private static class PropertyLocation
    extends TreeLocation {
        private final Tree parent;
        private final String name;

        public PropertyLocation(Tree parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        @Override
        @Nonnull
        public TreeLocation getParent() {
            return new NodeLocation(this.parent);
        }

        @Override
        public boolean exists() {
            return this.parent.hasProperty(this.name);
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public PropertyState getProperty() {
            return this.parent.getProperty(this.name);
        }

        @Override
        @Nonnull
        public String getPath() {
            return PathUtils.concat((String)this.parent.getPath(), (String)this.name);
        }

        @Override
        public boolean remove() {
            this.parent.removeProperty(this.name);
            return true;
        }
    }

    private static class NodeLocation
    extends TreeLocation {
        private final Tree tree;

        public NodeLocation(Tree tree) {
            this.tree = tree;
        }

        @Override
        @Nonnull
        public TreeLocation getParent() {
            return this.tree.isRoot() ? NullLocation.NULL : new NodeLocation(this.tree.getParent());
        }

        @Override
        @Nonnull
        public TreeLocation getChild(String name) {
            if (this.tree.hasProperty(name)) {
                return new PropertyLocation(this.tree, name);
            }
            return new NodeLocation(this.tree.getChild(name));
        }

        @Override
        public boolean exists() {
            return this.tree.exists();
        }

        @Override
        @Nonnull
        public String getName() {
            return this.tree.getName();
        }

        @Override
        public Tree getTree() {
            return this.exists() ? this.tree : null;
        }

        @Override
        @Nonnull
        public String getPath() {
            return this.tree.getPath();
        }

        @Override
        public boolean remove() {
            return this.exists() && this.tree.remove();
        }
    }
}

