/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.LazyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.UUIDUtils;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.ReadOnly;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeUtil {
    private TreeUtil() {
    }

    @Nullable
    public static String getPrimaryTypeName(@NotNull Tree tree) {
        return TreeUtil.getStringInternal(tree, "jcr:primaryType", (Type<String>)Type.NAME);
    }

    @Nullable
    public static String getPrimaryTypeName(@NotNull Tree tree, @NotNull LazyValue<Tree> readOnlyTree) {
        String primaryTypeName = null;
        if (tree.hasProperty("jcr:primaryType")) {
            primaryTypeName = TreeUtil.getPrimaryTypeName(tree);
        } else if (tree.getStatus() != Tree.Status.NEW) {
            primaryTypeName = TreeUtil.getPrimaryTypeName((Tree)readOnlyTree.get());
        }
        return primaryTypeName;
    }

    @NotNull
    public static Iterable<String> getMixinTypeNames(@NotNull Tree tree) {
        return TreeUtil.getNames(tree, "jcr:mixinTypes");
    }

    @NotNull
    public static Iterable<String> getMixinTypeNames(@NotNull Tree tree, @NotNull LazyValue<Tree> readOnlyTree) {
        Iterable<Object> mixinNames = Collections.emptyList();
        if (tree.hasProperty("jcr:mixinTypes")) {
            mixinNames = TreeUtil.getMixinTypeNames(tree);
        } else if (tree.getStatus() != Tree.Status.NEW) {
            mixinNames = TreeUtil.getNames((Tree)readOnlyTree.get(), "jcr:mixinTypes");
        }
        return mixinNames;
    }

    @Nullable
    public static Iterable<String> getStrings(@NotNull Tree tree, @NotNull String propertyName) {
        PropertyState property = tree.getProperty(propertyName);
        if (property == null) {
            return null;
        }
        return (Iterable)property.getValue(Type.STRINGS);
    }

    @Nullable
    public static String getString(@NotNull Tree tree, @NotNull String propertyName) {
        return TreeUtil.getStringInternal(tree, propertyName, (Type<String>)Type.STRING);
    }

    @Nullable
    public static String getString(@NotNull Tree tree, @NotNull String name, @Nullable String defaultValue) {
        String str = TreeUtil.getString(tree, name);
        return str != null ? str : defaultValue;
    }

    @Nullable
    private static String getStringInternal(@NotNull Tree tree, @NotNull String propertyName, @NotNull Type<String> type) {
        PropertyState property = tree.getProperty(propertyName);
        if (property != null && !property.isArray()) {
            return (String)property.getValue(type);
        }
        return null;
    }

    public static boolean getBoolean(@NotNull Tree tree, @NotNull String propertyName) {
        PropertyState property = tree.getProperty(propertyName);
        return property != null && !property.isArray() && (Boolean)property.getValue(Type.BOOLEAN) != false;
    }

    @Nullable
    public static String getName(@NotNull Tree tree, @NotNull String name) {
        PropertyState property = tree.getProperty(name);
        if (property != null && property.getType() == Type.NAME) {
            return (String)property.getValue(Type.NAME);
        }
        return null;
    }

    @NotNull
    public static Iterable<String> getNames(@NotNull Tree tree, @NotNull String name) {
        PropertyState property = tree.getProperty(name);
        if (property != null && property.getType() == Type.NAMES) {
            return (Iterable)property.getValue(Type.NAMES);
        }
        return Collections.emptyList();
    }

    public static long getLong(@NotNull Tree tree, @NotNull String name, long defaultValue) {
        PropertyState property = tree.getProperty(name);
        if (property != null && !property.isArray()) {
            return (Long)property.getValue(Type.LONG);
        }
        return defaultValue;
    }

    @Nullable
    public static Tree getTree(@NotNull Tree tree, @NotNull String path) {
        for (String element : PathUtils.elements((String)path)) {
            if (PathUtils.denotesParent((String)element)) {
                if (tree.isRoot()) {
                    return null;
                }
                tree = tree.getParent();
                continue;
            }
            if (PathUtils.denotesCurrent((String)element)) continue;
            tree = tree.getChild(element);
        }
        return tree;
    }

    @NotNull
    public static Tree addChild(@NotNull Tree parent, @NotNull String name, @Nullable String typeName, @NotNull Tree typeRoot, @Nullable String userID) throws RepositoryException {
        if (typeName == null && (typeName = TreeUtil.getDefaultChildType(typeRoot, parent, name)) == null) {
            String path = PathUtils.concat((String)parent.getPath(), (String)name);
            throw new ConstraintViolationException("No default node type available for " + path);
        }
        Tree type = typeRoot.getChild(typeName);
        if (!type.exists()) {
            throw TreeUtil.noSuchNodeTypeException(typeName);
        }
        if (TreeUtil.getBoolean(type, "jcr:isAbstract") && !typeName.equals(TreeUtil.getDefaultChildType(typeRoot, parent, name))) {
            throw TreeUtil.abstractNodeTypeException(typeName);
        }
        if (TreeUtil.getBoolean(type, "jcr:isMixin")) {
            throw TreeUtil.mixinTypeException(typeName, false);
        }
        Tree child = parent.addChild(name);
        child.setProperty("jcr:primaryType", (Object)typeName, Type.NAME);
        if (TreeUtil.getBoolean(type, "jcr:hasOrderableChildNodes")) {
            child.setOrderableChildren(true);
        }
        TreeUtil.autoCreateItems(child, type, typeRoot, userID);
        return child;
    }

    private static NoSuchNodeTypeException noSuchNodeTypeException(@NotNull String typeName) {
        return new NoSuchNodeTypeException(TreeUtil.exceptionMessage(typeName, "does not exist"));
    }

    private static ConstraintViolationException abstractNodeTypeException(@NotNull String typeName) {
        return new ConstraintViolationException(TreeUtil.exceptionMessage(typeName, "is abstract"));
    }

    private static ConstraintViolationException mixinTypeException(@NotNull String typeName, boolean mixinExpected) {
        String not = mixinExpected ? "not " : "";
        return new ConstraintViolationException(TreeUtil.exceptionMessage(typeName, "is " + not + "a mixin type"));
    }

    private static String exceptionMessage(@NotNull String typeName, @NotNull String reason) {
        return String.format("Node type %s %s", typeName, reason);
    }

    @NotNull
    public static Tree addChild(@NotNull Tree tree, @NotNull String childName, @NotNull String primaryTypeName) throws AccessDeniedException {
        Tree child = tree.addChild(childName);
        if (!child.exists()) {
            throw new AccessDeniedException();
        }
        child.setProperty("jcr:primaryType", (Object)primaryTypeName, Type.NAME);
        return child;
    }

    @NotNull
    public static Tree getOrAddChild(@NotNull Tree tree, @NotNull String childName, @NotNull String primaryTypeName) throws AccessDeniedException {
        Tree child = tree.getChild(childName);
        return child.exists() ? child : TreeUtil.addChild(tree, childName, primaryTypeName);
    }

    public static void addMixin(@NotNull Tree tree, @NotNull String mixinName, @NotNull Tree typeRoot, @Nullable String userID) throws RepositoryException {
        Tree type = typeRoot.getChild(mixinName);
        if (!type.exists()) {
            throw TreeUtil.noSuchNodeTypeException(mixinName);
        }
        if (TreeUtil.getBoolean(type, "jcr:isAbstract")) {
            throw TreeUtil.abstractNodeTypeException(mixinName);
        }
        if (!TreeUtil.getBoolean(type, "jcr:isMixin")) {
            throw TreeUtil.mixinTypeException(mixinName, true);
        }
        ArrayList mixins = Lists.newArrayList();
        String primary = TreeUtil.getName(tree, "jcr:primaryType");
        if (primary != null && Iterables.contains(TreeUtil.getNames(type, "rep:primarySubtypes"), (Object)primary)) {
            return;
        }
        HashSet subMixins = Sets.newHashSet(TreeUtil.getNames(type, "rep:mixinSubtypes"));
        for (String mixin : TreeUtil.getNames(tree, "jcr:mixinTypes")) {
            if (mixinName.equals(mixin) || subMixins.contains(mixin)) {
                return;
            }
            mixins.add(mixin);
        }
        mixins.add(mixinName);
        tree.setProperty("jcr:mixinTypes", (Object)mixins, Type.NAMES);
        TreeUtil.autoCreateItems(tree, type, typeRoot, userID);
    }

    public static void autoCreateItems(@NotNull Tree tree, @NotNull Tree type, @NotNull Tree typeRoot, @Nullable String userID) throws RepositoryException {
        TreeUtil.autoCreateProperties(tree, type, userID);
        Tree childNodes = type.getChild("rep:namedChildNodeDefinitions");
        for (Tree definitions : childNodes.getChildren()) {
            String name = definitions.getName();
            Tree definition = TreeUtil.getAutoCreatedDefinition(definitions);
            if (definition == null || tree.hasChild(name)) continue;
            String typeName = TreeUtil.getName(definition, "jcr:defaultPrimaryType");
            TreeUtil.addChild(tree, name, typeName, typeRoot, userID);
        }
    }

    private static void autoCreateProperties(@NotNull Tree tree, @NotNull Tree type, @Nullable String userID) throws RepositoryException {
        Tree properties = type.getChild("rep:namedPropertyDefinitions");
        for (Tree definitions : properties.getChildren()) {
            Tree definition;
            String name = definitions.getName();
            if (name.equals("rep:primaryType") || name.equals("rep:mixinTypes")) continue;
            if (name.equals("rep:uuid")) {
                name = "jcr:uuid";
            }
            if ((definition = TreeUtil.getAutoCreatedDefinition(definitions)) == null || tree.hasProperty(name)) continue;
            PropertyState property = TreeUtil.autoCreateProperty(name, definition, userID);
            if (property != null) {
                tree.setProperty(property);
                continue;
            }
            throw new RepositoryException("Unable to auto-create value for " + PathUtils.concat((String)tree.getPath(), (String)name));
        }
    }

    @Nullable
    private static Tree getAutoCreatedDefinition(@NotNull Tree definitions) {
        for (Tree definition : definitions.getChildren()) {
            if (!TreeUtil.getBoolean(definition, "jcr:autoCreated")) continue;
            return definition;
        }
        return null;
    }

    @Nullable
    public static PropertyState autoCreateProperty(@NotNull String name, @NotNull Tree definition, @Nullable String userID) {
        switch (name) {
            case "jcr:uuid": {
                return PropertyStates.createProperty((String)name, (Object)UUIDUtils.generateUUID(), (Type)Type.STRING);
            }
            case "jcr:created": 
            case "jcr:lastModified": {
                return PropertyStates.createProperty((String)name, (Object)ISO8601.format((Calendar)Calendar.getInstance()), (Type)Type.DATE);
            }
            case "jcr:createdBy": 
            case "jcr:lastModifiedBy": {
                return PropertyStates.createProperty((String)name, (Object)Strings.nullToEmpty((String)userID), (Type)Type.STRING);
            }
        }
        PropertyState values = definition.getProperty("jcr:defaultValues");
        if (values != null) {
            Type type = values.getType();
            if (TreeUtil.getBoolean(definition, "jcr:multiple")) {
                return PropertyStates.createProperty((String)name, (Object)values.getValue(type), (Type)type);
            }
            if (values.count() > 0) {
                type = type.getBaseType();
                return PropertyStates.createProperty((String)name, (Object)values.getValue(type, 0), (Type)type);
            }
        }
        return null;
    }

    @Nullable
    public static String getDefaultChildType(@NotNull Tree typeRoot, @NotNull Tree parent, @NotNull String childName) {
        String defaultName;
        Tree definitions;
        String name = PathUtils.dropIndexFromName((String)childName);
        boolean sns = !name.equals(childName);
        List<Tree> types = TreeUtil.getEffectiveType(parent, typeRoot);
        for (Tree type : types) {
            definitions = type.getChild("rep:namedChildNodeDefinitions").getChild(name);
            defaultName = TreeUtil.findDefaultPrimaryType(definitions, sns);
            if (defaultName == null) continue;
            return defaultName;
        }
        for (Tree type : types) {
            definitions = type.getChild("rep:residualChildNodeDefinitions");
            defaultName = TreeUtil.findDefaultPrimaryType(definitions, sns);
            if (defaultName == null) continue;
            return defaultName;
        }
        return null;
    }

    @NotNull
    public static List<Tree> getEffectiveType(@NotNull Tree tree, @NotNull Tree typeRoot) {
        Tree type;
        ArrayList types = Lists.newArrayList();
        String primary = TreeUtil.getName(tree, "jcr:primaryType");
        if (primary != null && (type = typeRoot.getChild(primary)).exists()) {
            types.add(type);
        }
        for (String mixin : TreeUtil.getNames(tree, "jcr:mixinTypes")) {
            Tree type2 = typeRoot.getChild(mixin);
            if (!type2.exists()) continue;
            types.add(type2);
        }
        return types;
    }

    @Nullable
    public static String findDefaultPrimaryType(@NotNull Tree definitions, boolean sns) {
        for (Tree definition : definitions.getChildren()) {
            String defaultName = TreeUtil.getName(definition, "jcr:defaultPrimaryType");
            if (defaultName == null || sns && !TreeUtil.getBoolean(definition, "jcr:sameNameSiblings")) continue;
            return defaultName;
        }
        return null;
    }

    public static boolean isNodeType(@NotNull Tree tree, @NotNull String typeName, @NotNull Tree typeRoot) {
        Tree type;
        String primaryName = TreeUtil.getName(tree, "jcr:primaryType");
        if (typeName.equals(primaryName)) {
            return true;
        }
        if (primaryName != null && Iterables.contains(TreeUtil.getNames(type = typeRoot.getChild(primaryName), "rep:supertypes"), (Object)typeName)) {
            return true;
        }
        for (String mixinName : TreeUtil.getNames(tree, "jcr:mixinTypes")) {
            if (typeName.equals(mixinName)) {
                return true;
            }
            Tree type2 = typeRoot.getChild(mixinName);
            if (!Iterables.contains(TreeUtil.getNames(type2, "rep:supertypes"), (Object)typeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadOnlyTree(@NotNull Tree tree) {
        return tree instanceof ReadOnly;
    }
}

