/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.util;

import java.util.Arrays;
import org.apache.jackrabbit.oak.spi.query.Filter;

public class LMSEstimator {
    private static final double DEFAULT_ALPHA = 0.03;
    private static final int DEFAULT_THRESHOLD = 5;
    private double[] weights;
    private final double alpha;
    private final long threshold;

    private LMSEstimator(double alpha, double[] weights, long threshold) {
        this.alpha = alpha;
        this.weights = weights;
        this.threshold = threshold;
    }

    public LMSEstimator() {
        this(0.03, new double[5], 5L);
    }

    public synchronized void update(Filter filter, long numFound) {
        double[] updatedWeights = new double[this.weights.length];
        long estimate = this.estimate(filter);
        long residual = numFound - estimate;
        double delta = Math.pow(residual, 2.0);
        if (Math.abs(delta) > (double)this.threshold) {
            for (int i = 0; i < updatedWeights.length; ++i) {
                updatedWeights[i] = this.weights[i] + this.alpha * (double)residual * (double)this.getInput(filter, i);
            }
            this.weights = Arrays.copyOf(updatedWeights, 5);
        }
    }

    public long estimate(Filter filter) {
        long estimatedEntryCount = 0L;
        for (int i = 0; i < 5; ++i) {
            estimatedEntryCount = (long)((double)estimatedEntryCount + this.weights[i] * (double)this.getInput(filter, i));
        }
        if (Double.isInfinite(estimatedEntryCount) || Double.isNaN(estimatedEntryCount)) {
            estimatedEntryCount = 1L;
            this.weights = new double[5];
        }
        return Math.max(0L, estimatedEntryCount);
    }

    private long getInput(Filter filter, int i) {
        assert (i < 5);
        if (i == 0) {
            return filter.getPropertyRestrictions() != null ? (long)filter.getPropertyRestrictions().size() : 0L;
        }
        if (i == 1) {
            return filter.containsNativeConstraint() ? 1L : 0L;
        }
        if (i == 2) {
            return filter.getPathRestriction() != null ? (long)filter.getPathRestriction().ordinal() : 0L;
        }
        if (i == 3) {
            return filter.getPathRestriction() != null ? (long)filter.getPathRestriction().toString().split("/").length : 0L;
        }
        if (i == 4) {
            return filter.getFullTextConstraint() != null ? (long)filter.getFullTextConstraint().getPrecedence() : 0L;
        }
        return 0L;
    }
}

