/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search;

import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextIndexEditorContext;
import org.apache.jackrabbit.oak.plugins.index.search.util.NodeStateCloner;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexOperations {
    private static final Logger LOG = LoggerFactory.getLogger(ReindexOperations.class);
    private final NodeState root;
    private final NodeBuilder definitionBuilder;
    private final String indexPath;
    private final IndexDefinition.Builder indexDefBuilder;
    private final boolean storedIndexDefinitionEnabled;

    public ReindexOperations(NodeState root, NodeBuilder definitionBuilder, String indexPath, IndexDefinition.Builder indexDefBuilder) {
        this(root, definitionBuilder, indexPath, indexDefBuilder, !IndexDefinition.isDisableStoredIndexDefinition());
    }

    public ReindexOperations(NodeState root, NodeBuilder definitionBuilder, String indexPath, IndexDefinition.Builder indexDefBuilder, boolean storedIndexDefinitionEnabled) {
        this.root = root;
        this.definitionBuilder = definitionBuilder;
        this.indexPath = indexPath;
        this.indexDefBuilder = indexDefBuilder;
        this.storedIndexDefinitionEnabled = storedIndexDefinitionEnabled;
    }

    public IndexDefinition apply(boolean useStateFromBuilder) {
        NodeState defnState;
        IndexFormatVersion version = IndexDefinition.determineVersionForFreshIndex(this.definitionBuilder);
        this.definitionBuilder.setProperty(":version", (Object)version.getVersion());
        NodeState nodeState = defnState = useStateFromBuilder ? this.definitionBuilder.getNodeState() : this.definitionBuilder.getBaseState();
        if (this.storedIndexDefinitionEnabled) {
            this.definitionBuilder.setChildNode(":index-definition", NodeStateCloner.cloneVisibleState(defnState));
            if (this.definitionBuilder.getChildNode(":status").exists()) {
                this.definitionBuilder.getChildNode(":status").removeProperty("reindexCompletionTimestamp");
                LOG.info("{} property removed for index at {}", (Object)"reindexCompletionTimestamp", (Object)this.indexPath);
            }
        }
        String uid = FulltextIndexEditorContext.configureUniqueId(this.definitionBuilder);
        return this.indexDefBuilder.root(this.root).defn(defnState).indexPath(this.indexPath).version(version).uid(uid).reindex().build();
    }
}

