/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexName
implements Comparable<IndexName> {
    private static final Logger LOG = LoggerFactory.getLogger(IndexName.class);
    private static final HashSet<String> LOGGED_WARN = new HashSet();
    private static long nextLogWarnClear;
    private final String nodeName;
    private final String baseName;
    private final boolean isVersioned;
    private final int productVersion;
    private final int customerVersion;
    private final boolean isLegal;

    public static IndexName parse(String nodeName) {
        String baseName = nodeName;
        int index = baseName.lastIndexOf(45);
        if (index < 0) {
            return new IndexName(nodeName, true);
        }
        String last = baseName.substring(index + 1);
        baseName = baseName.substring(0, index);
        try {
            int v1 = Integer.parseInt(last);
            if (!baseName.endsWith("-custom")) {
                return new IndexName(nodeName, baseName, v1, 0);
            }
            index = (baseName = baseName.substring(0, baseName.length() - "-custom".length())).lastIndexOf(45);
            if (index < 0) {
                return new IndexName(nodeName, baseName, 0, v1);
            }
            last = baseName.substring(index + 1);
            baseName = baseName.substring(0, index);
            int v2 = Integer.parseInt(last);
            return new IndexName(nodeName, baseName, v2, v1);
        }
        catch (NumberFormatException e) {
            long now = System.currentTimeMillis();
            if (nextLogWarnClear < now) {
                LOGGED_WARN.clear();
                nextLogWarnClear = now + 300000L;
            }
            if (LOGGED_WARN.add(nodeName)) {
                LOG.warn("Index name format error: " + nodeName);
            }
            return new IndexName(nodeName, false);
        }
    }

    private IndexName(String nodeName, boolean isLegal) {
        this.nodeName = nodeName;
        this.baseName = nodeName;
        this.isVersioned = false;
        this.productVersion = 0;
        this.customerVersion = 0;
        this.isLegal = isLegal;
    }

    private IndexName(String nodeName, String baseName, int productVersion, int customerVersion) {
        this.nodeName = nodeName;
        this.baseName = baseName;
        this.isVersioned = true;
        this.productVersion = productVersion;
        this.customerVersion = customerVersion;
        this.isLegal = true;
    }

    public String toString() {
        return this.nodeName + " base=" + this.baseName + (this.isVersioned ? " versioned" : "") + " product=" + this.productVersion + " custom=" + this.customerVersion + (this.isLegal ? "" : " illegal");
    }

    @Override
    public int compareTo(IndexName o) {
        int comp = this.baseName.compareTo(o.baseName);
        if (comp != 0) {
            return comp;
        }
        comp = Integer.compare(this.productVersion, o.productVersion);
        if (comp != 0) {
            return comp;
        }
        return Integer.compare(this.customerVersion, o.customerVersion);
    }

    public IndexName getLatestCustomized(List<IndexName> all) {
        IndexName latest = null;
        for (IndexName n : all) {
            if (!n.baseName.equals(this.baseName) || n.customerVersion <= 0 || latest != null && n.compareTo(latest) <= 0) continue;
            latest = n;
        }
        return latest;
    }

    public IndexName getLatestProduct(List<IndexName> all) {
        IndexName latest = null;
        for (IndexName n : all) {
            if (!n.baseName.equals(this.baseName) || this.compareTo(n) <= 0 || n.customerVersion != 0 || latest != null && n.compareTo(latest) <= 0) continue;
            latest = n;
        }
        return latest;
    }

    public static Collection<String> filterReplacedIndexes(Collection<String> indexPaths, NodeState rootState) {
        HashMap<String, IndexName> latestVersions = new HashMap<String, IndexName>();
        for (String p : indexPaths) {
            IndexName stored;
            IndexName indexName = IndexName.parse(p);
            if (indexName.isVersioned && !IndexName.isIndexActive(p, rootState) || (stored = (IndexName)latestVersions.get(indexName.baseName)) != null && stored.compareTo(indexName) >= 0) continue;
            latestVersions.put(indexName.baseName, indexName);
        }
        ArrayList<String> result = new ArrayList<String>(latestVersions.size());
        for (IndexName n : latestVersions.values()) {
            result.add(n.nodeName);
        }
        return result;
    }

    public String nextCustomizedName() {
        return this.baseName + "-" + this.productVersion + "-custom-" + (this.customerVersion + 1);
    }

    private static boolean isIndexActive(String indexPath, NodeState rootState) {
        NodeState indexNode = rootState;
        for (String e : PathUtils.elements((String)indexPath)) {
            indexNode = indexNode.getChildNode(e);
        }
        for (String c : indexNode.getChildNodeNames()) {
            if (!c.startsWith(":oak:mount-")) continue;
            return true;
        }
        return IndexName.isIndexActiveMerged(indexNode, rootState);
    }

    private static boolean isIndexActiveMerged(NodeState indexNode, NodeState rootState) {
        PropertyState ps = indexNode.getProperty("merges");
        if (ps == null) {
            return false;
        }
        if (ps.getType() != Type.STRING && ps.getType() != Type.STRINGS) {
            return false;
        }
        for (int i = 0; i < ps.count(); ++i) {
            String indexType;
            String merges = (String)ps.getValue(Type.STRING, i);
            NodeState mergeNode = rootState;
            for (String e : PathUtils.elements((String)merges)) {
                mergeNode = mergeNode.getChildNode(e);
            }
            if (!mergeNode.exists() || "disabled".equals(indexType = mergeNode.getString("type")) || IndexName.isIndexActive(merges, rootState)) continue;
            return false;
        }
        return true;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getCustomerVersion() {
        return this.customerVersion;
    }

    public int getProductVersion() {
        return this.productVersion;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public boolean isVersioned() {
        return this.isVersioned;
    }

    public boolean isLegal() {
        return this.isLegal;
    }
}

