/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.editor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.search.Aggregate;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.spi.binary.FulltextBinaryTextExtractor;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.DocumentMaker;
import org.apache.jackrabbit.oak.plugins.index.search.util.ConfigUtil;
import org.apache.jackrabbit.oak.plugins.index.search.util.FunctionIndexProcessor;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FulltextDocumentMaker<D>
implements DocumentMaker<D> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String WARN_LOG_STRING_SIZE_THRESHOLD_KEY = "oak.repository.property.index.logWarnStringSizeThreshold";
    private static final int DEFAULT_WARN_LOG_STRING_SIZE_THRESHOLD_VALUE = 102400;
    private static final String DYNAMIC_BOOST_TAG_NAME = "name";
    private static final String DYNAMIC_BOOST_TAG_CONFIDENCE = "confidence";
    private final FulltextBinaryTextExtractor textExtractor;
    protected final IndexDefinition definition;
    protected final IndexDefinition.IndexingRule indexingRule;
    protected final String path;
    private final int logWarnStringSizeThreshold;

    public FulltextDocumentMaker(@Nullable FulltextBinaryTextExtractor textExtractor, @NotNull IndexDefinition definition, IndexDefinition.IndexingRule indexingRule, @NotNull String path) {
        this.textExtractor = textExtractor;
        this.definition = (IndexDefinition)Preconditions.checkNotNull((Object)definition);
        this.indexingRule = (IndexDefinition.IndexingRule)Preconditions.checkNotNull((Object)indexingRule);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.logWarnStringSizeThreshold = Integer.getInteger(WARN_LOG_STRING_SIZE_THRESHOLD_KEY, 102400);
    }

    protected abstract D initDoc();

    protected abstract D finalizeDoc(D var1, boolean var2, boolean var3) throws IOException;

    protected abstract boolean isFacetingEnabled();

    protected abstract boolean indexTypeOrderedFields(D var1, String var2, int var3, PropertyState var4, PropertyDefinition var5);

    protected abstract boolean addBinary(D var1, String var2, List<String> var3);

    protected abstract boolean indexFacetProperty(D var1, int var2, PropertyState var3, String var4);

    protected abstract void indexAnalyzedProperty(D var1, String var2, String var3, PropertyDefinition var4);

    protected abstract void indexSuggestValue(D var1, String var2);

    protected abstract void indexSpellcheckValue(D var1, String var2);

    protected abstract void indexFulltextValue(D var1, String var2);

    protected abstract void indexTypedProperty(D var1, PropertyState var2, String var3, PropertyDefinition var4, int var5);

    protected abstract boolean indexDynamicBoost(D var1, String var2, String var3, String var4, double var5);

    protected abstract void indexAncestors(D var1, String var2);

    protected abstract void indexNotNullProperty(D var1, PropertyDefinition var2);

    protected abstract void indexNullProperty(D var1, PropertyDefinition var2);

    protected abstract void indexAggregateValue(D var1, Aggregate.NodeIncludeResult var2, String var3, PropertyDefinition var4);

    protected abstract void indexNodeName(D var1, String var2);

    protected void logLargeStringProperties(String propertyName, String value) {
        if (value.length() > this.logWarnStringSizeThreshold) {
            this.log.warn("String length: {} for property: {} at Node: {} is greater than configured value {}", new Object[]{value.length(), propertyName, this.path, this.logWarnStringSizeThreshold});
        }
    }

    @Nullable
    public D makeDocument(NodeState state) throws IOException {
        return this.makeDocument(state, false, Collections.emptyList());
    }

    @Override
    @Nullable
    public D makeDocument(NodeState state, boolean isUpdate, List<PropertyState> propertiesModified) throws IOException {
        boolean facet = false;
        D document = this.initDoc();
        boolean dirty = false;
        StringPropertyState nodenamePS = new StringPropertyState(":nodeName", PathUtils.getName((String)this.path));
        for (PropertyState property : Iterables.concat((Iterable)state.getProperties(), Collections.singleton(nodenamePS))) {
            PropertyDefinition pd;
            String pname = property.getName();
            if (!FulltextDocumentMaker.isVisible(pname) && !":nodeName".equals(pname) || (pd = this.indexingRule.getConfig(pname)) == null || !pd.index) continue;
            if (pd.ordered) {
                dirty |= this.addTypedOrderedFields(document, property, pname, pd);
            }
            dirty |= this.indexProperty(this.path, document, state, property, pname, pd);
            facet |= pd.facet;
        }
        boolean[] dirties = this.indexAggregates(this.path, document, state);
        dirty |= dirties[0];
        facet |= dirties[1];
        dirty |= this.indexNullCheckEnabledProps(this.path, document, state);
        dirty |= this.indexFunctionRestrictions(this.path, document, state);
        dirty |= this.indexNotNullCheckEnabledProps(this.path, document, state);
        if (!(dirty |= this.augmentCustomFields(this.path, document, state))) {
            dirty = this.indexIfSinglePropertyRemoved(propertiesModified);
        }
        if (isUpdate && !dirty) {
            return null;
        }
        String name = PathUtils.getName((String)this.path);
        if (this.indexingRule.isNodeNameIndexed()) {
            this.addNodeNameField(document, name);
            dirty = true;
        }
        if (!this.indexingRule.indexesAllNodesOfMatchingType() && !dirty) {
            return null;
        }
        if (this.indexingRule.isFulltextEnabled()) {
            boolean shouldAdd;
            Pattern propertyRegex = this.definition.getPropertyRegex();
            boolean bl = shouldAdd = propertyRegex == null || propertyRegex.matcher(name).find();
            if (shouldAdd) {
                this.indexFulltextValue(document, name);
            }
        }
        if (this.definition.evaluatePathRestrictions()) {
            this.indexAncestors(document, this.path);
        }
        return this.finalizeDoc(document, dirty, facet);
    }

    private boolean indexFacets(D doc, PropertyState property, String pname, PropertyDefinition pd) {
        int idxDefinedTag;
        int tag = property.getType().tag();
        if (tag != (idxDefinedTag = pd.getType())) {
            this.log.debug("[{}] Facet property defined with type {} differs from property {} with type {} in path {}", new Object[]{this.getIndexName(), Type.fromTag((int)idxDefinedTag, (boolean)false), property.toString(), Type.fromTag((int)tag, (boolean)false), this.path});
            tag = idxDefinedTag;
        }
        return this.indexFacetProperty(doc, tag, property, pname);
    }

    private boolean indexProperty(String path, D doc, NodeState state, PropertyState property, String pname, PropertyDefinition pd) {
        boolean includeTypeForFullText = this.indexingRule.includePropertyType(property.getType().tag());
        boolean dirty = false;
        if (Type.BINARY.tag() == property.getType().tag() && pd.useInSimilarity) {
            try {
                this.log.trace("indexing similarity binaries for {}", (Object)pd.name);
                this.indexSimilarityBinaries(doc, pd, (Blob)property.getValue(Type.BINARY));
                dirty = true;
            }
            catch (Exception e) {
                this.log.error("could not index similarity field for property {} and definition {}", (Object)property, (Object)pd);
            }
        } else if (Type.BINARY.tag() == property.getType().tag() && includeTypeForFullText) {
            List<String> binaryValues = this.newBinary(property, state, path + "@" + pname);
            this.addBinary(doc, null, binaryValues);
            dirty = true;
        } else {
            if (pd.propertyIndex && pd.includePropertyType(property.getType().tag())) {
                dirty |= this.addTypedFields(doc, property, pname, pd);
            }
            if (pd.dynamicBoost) {
                try {
                    dirty |= this.indexDynamicBoost(doc, pname, pd.nodeName, state);
                }
                catch (Exception e) {
                    this.log.error("Could not index dynamic boost for property {} and definition {}", new Object[]{property, pd, e});
                }
            }
            if (pd.fulltextEnabled() && includeTypeForFullText) {
                for (String value : (Iterable)property.getValue(Type.STRINGS)) {
                    this.logLargeStringProperties(property.getName(), value);
                    if (this.definition.getPropertyRegex() != null && !this.definition.getPropertyRegex().matcher(value).find() || !this.includePropertyValue(value, pd)) continue;
                    if (pd.analyzed && pd.includePropertyType(property.getType().tag())) {
                        this.indexAnalyzedProperty(doc, pname, value, pd);
                    }
                    if (pd.useInSuggest) {
                        this.indexSuggestValue(doc, value);
                    }
                    if (pd.useInSpellcheck) {
                        this.indexSpellcheckValue(doc, value);
                    }
                    if (pd.nodeScopeIndex) {
                        if (this.isFulltextValuePersistedAtNode(pd)) {
                            this.indexFulltextValue(doc, value);
                        }
                        if (pd.useInSimilarity) {
                            this.log.trace("indexing similarity strings for {}", (Object)pd.name);
                            try {
                                this.indexSimilarityStrings(doc, pd, value);
                            }
                            catch (Exception e) {
                                this.log.error("could not index similarity field for property {} and definition {}", (Object)property, (Object)pd);
                            }
                        }
                    }
                    dirty = true;
                }
            }
            if (pd.facet && this.isFacetingEnabled()) {
                dirty |= this.indexFacets(doc, property, pname, pd);
            }
            if (pd.similarityTags) {
                dirty |= this.indexSimilarityTag(doc, property);
            }
        }
        return dirty;
    }

    protected boolean isFulltextValuePersistedAtNode(PropertyDefinition pd) {
        return true;
    }

    protected abstract boolean indexSimilarityTag(D var1, PropertyState var2);

    protected abstract void indexSimilarityBinaries(D var1, PropertyDefinition var2, Blob var3) throws IOException;

    protected abstract void indexSimilarityStrings(D var1, PropertyDefinition var2, String var3) throws IOException;

    private boolean addTypedFields(D doc, PropertyState property, String pname, PropertyDefinition pd) {
        int tag = property.getType().tag();
        boolean fieldAdded = false;
        for (int i = 0; i < property.count(); ++i) {
            if (!this.includePropertyValue(property, i, pd)) continue;
            this.indexTypedProperty(doc, property, pname, pd, i);
            fieldAdded = true;
            if (tag != Type.STRING.tag()) continue;
            this.logLargeStringProperties(property.getName(), (String)property.getValue(Type.STRING, i));
        }
        return fieldAdded;
    }

    private boolean addTypedOrderedFields(D doc, PropertyState property, String pname, PropertyDefinition pd) {
        int idxDefinedTag;
        if (property.getType().isArray()) {
            this.log.warn("[{}] Ignoring ordered property {} of type {} for path {} as multivalued ordered property not supported", new Object[]{this.getIndexName(), pname, Type.fromTag((int)property.getType().tag(), (boolean)true), this.path});
            return false;
        }
        int tag = property.getType().tag();
        if (tag != (idxDefinedTag = pd.getType())) {
            this.log.debug("[{}] Ordered property defined with type {} differs from property {} with type {} in path {}", new Object[]{this.getIndexName(), Type.fromTag((int)idxDefinedTag, (boolean)false), property.toString(), Type.fromTag((int)tag, (boolean)false), this.path});
            tag = idxDefinedTag;
        }
        return this.indexTypeOrderedFields(doc, pname, tag, property, pd);
    }

    protected boolean includePropertyValue(PropertyState property, int i, PropertyDefinition pd) {
        if (property.getType().tag() == 2) {
            return true;
        }
        if (pd.valuePattern.matchesAll()) {
            return true;
        }
        return this.includePropertyValue((String)property.getValue(Type.STRING, i), pd);
    }

    protected boolean includePropertyValue(String value, PropertyDefinition pd) {
        return pd.valuePattern.matches(value);
    }

    private static boolean isVisible(String name) {
        return name.charAt(0) != ':';
    }

    private List<String> newBinary(PropertyState property, NodeState state, String path) {
        if (this.textExtractor == null) {
            return Collections.emptyList();
        }
        return this.textExtractor.newBinary(property, state, path);
    }

    protected abstract boolean augmentCustomFields(String var1, D var2, NodeState var3);

    private boolean indexNotNullCheckEnabledProps(String path, D doc, NodeState state) {
        boolean fieldAdded = false;
        for (PropertyDefinition pd : this.indexingRule.getNotNullCheckEnabledProperties()) {
            if (!this.isPropertyNotNull(state, pd)) continue;
            this.indexNotNullProperty(doc, pd);
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private boolean indexNullCheckEnabledProps(String path, D doc, NodeState state) {
        boolean fieldAdded = false;
        for (PropertyDefinition pd : this.indexingRule.getNullCheckEnabledProperties()) {
            if (!this.isPropertyNull(state, pd)) continue;
            this.indexNullProperty(doc, pd);
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private boolean indexFunctionRestrictions(String path, D fields, NodeState state) {
        boolean fieldAdded = false;
        for (PropertyDefinition pd : this.indexingRule.getFunctionRestrictions()) {
            PropertyState functionValue = this.calculateValue(path, state, pd.functionCode);
            if (functionValue == null) continue;
            if (pd.ordered) {
                this.addTypedOrderedFields(fields, functionValue, pd.function, pd);
            }
            this.addTypedFields(fields, functionValue, pd.function, pd);
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private PropertyState calculateValue(String path, NodeState state, String[] functionCode) {
        try {
            return FunctionIndexProcessor.tryCalculateValue(path, state, functionCode);
        }
        catch (RuntimeException e) {
            this.log.error("Failed to calculate function value for {} at {}", new Object[]{Arrays.toString(functionCode), path, e});
            throw e;
        }
    }

    private boolean indexIfSinglePropertyRemoved(List<PropertyState> propertiesModified) {
        boolean dirty = false;
        for (PropertyState ps : propertiesModified) {
            PropertyDefinition pd = this.indexingRule.getConfig(ps.getName());
            if (pd == null || !pd.index || !pd.includePropertyType(ps.getType().tag()) && !this.indexingRule.includePropertyType(ps.getType().tag())) continue;
            dirty = true;
            break;
        }
        return dirty;
    }

    private boolean isPropertyNull(NodeState state, PropertyDefinition pd) {
        NodeState propertyNode = FulltextDocumentMaker.getPropertyNode(state, pd);
        if (!propertyNode.exists()) {
            return false;
        }
        return !propertyNode.hasProperty(pd.nonRelativeName);
    }

    private boolean isPropertyNotNull(NodeState state, PropertyDefinition pd) {
        NodeState propertyNode = FulltextDocumentMaker.getPropertyNode(state, pd);
        if (!propertyNode.exists()) {
            return false;
        }
        return propertyNode.hasProperty(pd.nonRelativeName);
    }

    private static NodeState getPropertyNode(NodeState nodeState, PropertyDefinition pd) {
        if (!pd.relative) {
            return nodeState;
        }
        NodeState node = nodeState;
        for (String name : pd.ancestors) {
            node = node.getChildNode(name);
        }
        return node;
    }

    private boolean[] indexAggregates(final String path, final D document, final NodeState state) {
        final AtomicBoolean dirtyFlag = new AtomicBoolean();
        final AtomicBoolean facetFlag = new AtomicBoolean();
        this.indexingRule.getAggregate().collectAggregates(state, new Aggregate.ResultCollector(){

            @Override
            public void onResult(Aggregate.NodeIncludeResult result) {
                boolean dirty = FulltextDocumentMaker.this.indexAggregatedNode(path, document, result);
                if (dirty) {
                    dirtyFlag.set(true);
                }
            }

            @Override
            public void onResult(Aggregate.PropertyIncludeResult result) {
                boolean dirty = false;
                if (result.pd.ordered) {
                    dirty |= FulltextDocumentMaker.this.addTypedOrderedFields(document, result.propertyState, result.propertyPath, result.pd);
                }
                dirty |= FulltextDocumentMaker.this.indexProperty(path, document, state, result.propertyState, result.propertyPath, result.pd);
                if (result.pd.facet) {
                    facetFlag.set(true);
                }
                if (dirty) {
                    dirtyFlag.set(true);
                }
            }
        });
        return new boolean[]{dirtyFlag.get(), facetFlag.get()};
    }

    private boolean indexAggregatedNode(String path, D doc, Aggregate.NodeIncludeResult result) {
        IndexDefinition.IndexingRule ruleAggNode = this.definition.getApplicableIndexingRule(ConfigUtil.getPrimaryTypeName(result.nodeState));
        boolean dirty = false;
        for (PropertyState property : result.nodeState.getProperties()) {
            String pname = property.getName();
            String propertyPath = PathUtils.concat((String)result.nodePath, (String)pname);
            if (!FulltextDocumentMaker.isVisible(pname)) continue;
            int type = property.getType().tag();
            if (ruleAggNode == null ? !this.indexingRule.includePropertyType(type) : !ruleAggNode.includePropertyType(type)) continue;
            PropertyDefinition pdForRootNode = this.indexingRule.getConfig(propertyPath);
            if (pdForRootNode != null && (!pdForRootNode.index || pdForRootNode.excludeFromAggregate)) continue;
            if (Type.BINARY == property.getType()) {
                String aggreagtedNodePath = PathUtils.concat((String)path, (String)result.nodePath);
                String nodePath = result.isRelativeNode() ? result.rootIncludePath : null;
                List<String> binaryValues = this.newBinary(property, result.nodeState, aggreagtedNodePath + "@" + pname);
                this.addBinary(doc, nodePath, binaryValues);
                dirty = true;
                continue;
            }
            PropertyDefinition pd = null;
            if (ruleAggNode != null) {
                pd = ruleAggNode.getConfig(pname);
            }
            if (pd != null && !pd.nodeScopeIndex) continue;
            for (String value : (Iterable)property.getValue(Type.STRINGS)) {
                this.indexAggregateValue(doc, result, value, pd);
                dirty = true;
            }
        }
        return dirty;
    }

    protected boolean indexDynamicBoost(D doc, String propertyName, String nodeName, NodeState nodeState) {
        NodeState propertyNode = nodeState;
        String parentName = PathUtils.getParentPath((String)propertyName);
        for (String c : PathUtils.elements((String)parentName)) {
            propertyNode = propertyNode.getChildNode(c);
        }
        boolean added = false;
        for (String childNodeName : propertyNode.getChildNodeNames()) {
            double dynaTagConfidence;
            NodeState dynaTag = propertyNode.getChildNode(childNodeName);
            PropertyState p = dynaTag.getProperty(DYNAMIC_BOOST_TAG_NAME);
            if (p == null) continue;
            if (p.isArray()) {
                this.log.warn(p.getName() + " is an array: {}", (Object)parentName);
                continue;
            }
            String dynaTagValue = (String)p.getValue(Type.STRING);
            p = dynaTag.getProperty(DYNAMIC_BOOST_TAG_CONFIDENCE);
            if (p == null) continue;
            if (p.isArray()) {
                this.log.warn(p.getName() + " is an array: {}", (Object)parentName);
                continue;
            }
            try {
                dynaTagConfidence = (Double)p.getValue(Type.DOUBLE);
            }
            catch (NumberFormatException e) {
                this.log.warn(p.getName() + " parsing failed: {}", (Object)parentName, (Object)e);
                continue;
            }
            if (!Double.isFinite(dynaTagConfidence)) {
                this.log.warn(p.getName() + " is not finite: {}", (Object)parentName);
                continue;
            }
            if (!this.indexDynamicBoost(doc, parentName, nodeName, dynaTagValue, dynaTagConfidence)) continue;
            added = true;
        }
        return added;
    }

    protected String getIndexName() {
        return this.definition.getIndexName();
    }

    private void addNodeNameField(D doc, String name) {
        int colon = name.indexOf(58);
        String value = colon < 0 ? name : name.substring(colon + 1);
        this.indexNodeName(doc, value);
    }
}

