/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.binary;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.search.ExtractedTextCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TextExtractionStats {
    private static final Logger log = LoggerFactory.getLogger(TextExtractionStats.class);
    private static final long LOGGING_THRESHOLD = TimeUnit.MINUTES.toMillis(1L);
    private int count;
    private long totalBytesRead;
    private long totalTime;
    private long totalTextLength;

    TextExtractionStats() {
    }

    public void addStats(long timeInMillis, long bytesRead, int textLength) {
        ++this.count;
        this.totalBytesRead += bytesRead;
        this.totalTime += timeInMillis;
        this.totalTextLength += (long)textLength;
    }

    public void log(boolean reindex) {
        if (log.isDebugEnabled()) {
            log.debug("Text extraction stats {}", (Object)this);
        } else if (this.anyParsingDone() && (reindex || this.isTakingLotsOfTime())) {
            log.info("Text extraction stats {}", (Object)this);
        }
    }

    public void collectStats(ExtractedTextCache cache) {
        cache.addStats(this.count, this.totalTime, this.totalBytesRead, this.totalTextLength);
    }

    private boolean isTakingLotsOfTime() {
        return this.totalTime > LOGGING_THRESHOLD;
    }

    private boolean anyParsingDone() {
        return this.count > 0;
    }

    public String toString() {
        return String.format(" %d (Time Taken %s, Bytes Read %s, Extracted text size %s)", this.count, TextExtractionStats.timeInWords(this.totalTime), IOUtils.humanReadableByteCount((long)this.totalBytesRead), IOUtils.humanReadableByteCount((long)this.totalTextLength));
    }

    private static String timeInWords(long millis) {
        return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
    }
}

