/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.query;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.search.update.ReaderRefreshPolicy;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexNodeManager {
    public static final String ASYNC = ":async";
    private static final AtomicInteger SEARCHER_ID_COUNTER = new AtomicInteger();
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(IndexNodeManager.class.getName() + ".perf")));
    private static final Logger log = LoggerFactory.getLogger(IndexNodeManager.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Semaphore refreshLock = new Semaphore(1);
    private final Runnable refreshCallback = new Runnable(){

        @Override
        public void run() {
            if (IndexNodeManager.this.refreshLock.tryAcquire()) {
                try {
                    IndexNodeManager.this.refreshReaders();
                }
                finally {
                    IndexNodeManager.this.refreshLock.release();
                }
            }
        }
    };
    private boolean closed = false;

    protected abstract IndexNodeManager open(String var1, NodeState var2, NodeState var3);

    protected abstract void releaseResources();

    protected abstract IndexNode getIndexNode();

    protected abstract ReaderRefreshPolicy getReaderRefreshPolicy();

    protected abstract void refreshReaders();

    protected abstract String getName();

    protected abstract IndexDefinition getDefinition();

    static boolean hasAsyncIndexerRun(NodeState root, String indexPath, NodeState defnNodeState) {
        boolean hasAsyncNode = root.hasChildNode(ASYNC);
        String asyncLaneName = IndexUtils.getAsyncLaneName((NodeState)defnNodeState, (String)indexPath, (PropertyState)defnNodeState.getProperty("async"));
        if (asyncLaneName != null) {
            return hasAsyncNode && root.getChildNode(ASYNC).hasProperty(asyncLaneName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    IndexNode acquire() {
        this.lock.readLock().lock();
        if (this.closed) {
            this.lock.readLock().unlock();
            return null;
        }
        boolean success = false;
        try {
            this.getReaderRefreshPolicy().refreshOnReadIfRequired(this.refreshCallback);
            IndexNode indexNode = this.getIndexNode();
            success = true;
            IndexNode indexNode2 = indexNode;
            return indexNode2;
        }
        finally {
            if (!success) {
                this.lock.readLock().unlock();
            }
        }
    }

    private void release() {
        this.lock.readLock().unlock();
    }

    void close() throws IOException {
        this.lock.writeLock().lock();
        try {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            this.closed = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.releaseResources();
    }
}

