/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.index.search.Aggregate;
import org.apache.jackrabbit.oak.plugins.index.search.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.util.ConfigUtil;
import org.apache.jackrabbit.oak.plugins.index.search.util.FunctionIndexProcessor;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexDefinition
implements Aggregate.AggregateMapper {
    private static final String OAK_CHILD_ORDER = ":childOrder";
    private static final Logger log = LoggerFactory.getLogger(IndexDefinition.class);
    private static boolean disableStoredIndexDefinition;
    public static final int DEFAULT_BLOB_SIZE = 1047552;
    public static final long DEFAULT_ENTRY_COUNT = 1000L;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_MAX_EXTRACT_LENGTH = -10;
    public static final String INDEX_VERSION = ":version";
    public static final String INDEX_DEFINITION_NODE = ":index-definition";
    public static final String STATUS_NODE = ":status";
    public static final String STATUS_LAST_UPDATED = "lastUpdated";
    public static final String CREATION_TIMESTAMP = "creationTimestamp";
    public static final String REINDEX_COMPLETION_TIMESTAMP = "reindexCompletionTimestamp";
    public static final String PROP_UID = "uid";
    private static final String TYPES_ALLOW_ALL_NAME = "all";
    static final int TYPES_ALLOW_NONE = 0;
    static final int TYPES_ALLOW_ALL = -1;
    public static final int DEFAULT_SUGGESTER_UPDATE_FREQUENCY_MINUTES = 10;
    static final int DEFAULT_FACET_COUNT = 10;
    public static final QueryIndex.OrderEntry NATIVE_SORT_ORDER;
    protected final boolean fullTextEnabled;
    protected final NodeState definition;
    private final NodeState root;
    private final IndexFormatVersion version;
    private final String funcName;
    private final int blobSize;
    private final long entryCount;
    private final boolean entryCountDefined;
    private final double costPerEntry;
    private final double costPerExecution;
    private final Map<String, List<IndexingRule>> indexRules;
    private final List<IndexingRule> definedRules;
    private final String indexName;
    private final boolean evaluatePathRestrictions;
    private final Map<String, Aggregate> aggregates;
    private final String scorerProviderName;
    private final boolean hasCustomTikaConfig;
    private final Map<String, String> customTikaMimeTypeMappings;
    private final int maxFieldLength;
    private final int maxExtractLength;
    private final int suggesterUpdateFrequencyMinutes;
    private final long reindexCount;
    private final PathFilter pathFilter;
    @Nullable
    private final String[] queryPaths;
    private final boolean suggestAnalyzed;
    private final SecureFacetConfiguration secureFacets;
    private final long randomSeed;
    private final int numberOfTopFacets;
    private final boolean suggestEnabled;
    private final boolean spellcheckEnabled;
    private final String indexPath;
    private final boolean nrtIndexMode;
    private final boolean syncIndexMode;
    private final boolean nodeTypeIndex;
    @Nullable
    private final String uid;
    @Nullable
    private final String[] indexTags;
    private final boolean syncPropertyIndexes;
    private final String useIfExists;
    private final boolean deprecated;
    private final boolean testMode;
    private final Pattern propertyRegex;

    public boolean isTestMode() {
        return this.testMode;
    }

    public static Builder newBuilder(NodeState root, NodeState defn, String indexPath) {
        return new Builder().root(root).defn(defn).indexPath(indexPath);
    }

    public IndexDefinition(NodeState root, NodeState defn, String indexPath) {
        this(root, IndexDefinition.getIndexDefinitionState(defn), IndexDefinition.determineIndexFormatVersion(defn), IndexDefinition.determineUniqueId(defn), indexPath);
    }

    protected IndexDefinition(NodeState root, NodeState defn, IndexFormatVersion version, String uid, String indexPath) {
        try {
            this.root = root;
            this.version = (IndexFormatVersion)((Object)Preconditions.checkNotNull((Object)((Object)version)));
            this.uid = uid;
            this.definition = defn;
            this.indexPath = (String)Preconditions.checkNotNull((Object)indexPath);
            this.indexName = indexPath;
            this.indexTags = IndexDefinition.getOptionalStrings(defn, "tags");
            this.nodeTypeIndex = ConfigUtil.getOptionalValue(defn, "nodeTypeIndex", false);
            this.blobSize = ConfigUtil.getOptionalValue(defn, "blobSize", 1047552);
            this.aggregates = this.nodeTypeIndex ? Collections.emptyMap() : this.collectAggregates(defn);
            NodeState rulesState = defn.getChildNode("indexRules");
            if (!rulesState.exists()) {
                rulesState = IndexDefinition.createIndexRules(defn).getNodeState();
            }
            this.testMode = ConfigUtil.getOptionalValue(defn, "testMode", false);
            ArrayList definedIndexRules = Lists.newArrayList();
            this.indexRules = this.collectIndexRules(rulesState, definedIndexRules);
            this.definedRules = ImmutableList.copyOf((Collection)definedIndexRules);
            this.fullTextEnabled = IndexDefinition.hasFulltextEnabledIndexRule(definedIndexRules);
            this.evaluatePathRestrictions = ConfigUtil.getOptionalValue(defn, "evaluatePathRestrictions", false);
            this.propertyRegex = defn.hasProperty("valueRegex") ? Pattern.compile(ConfigUtil.getOptionalValue(defn, "valueRegex", "")) : null;
            String functionName = ConfigUtil.getOptionalValue(defn, "functionName", null);
            if (this.fullTextEnabled && functionName == null) {
                functionName = this.getDefaultFunctionName();
            }
            String string = this.funcName = functionName != null ? "native*" + functionName : null;
            if (defn.hasProperty("entryCount")) {
                this.entryCountDefined = true;
                this.entryCount = ConfigUtil.getOptionalValue(defn, "entryCount", 1000L);
            } else {
                this.entryCountDefined = false;
                this.entryCount = 1000L;
            }
            this.maxFieldLength = ConfigUtil.getOptionalValue(defn, "maxFieldLength", 10000);
            this.costPerEntry = ConfigUtil.getOptionalValue(defn, "costPerEntry", this.getDefaultCostPerEntry(version));
            this.costPerExecution = ConfigUtil.getOptionalValue(defn, "costPerExecution", 1.0);
            this.hasCustomTikaConfig = this.getTikaConfigNode().exists();
            this.customTikaMimeTypeMappings = IndexDefinition.buildMimeTypeMap(this.definition.getChildNode("tika").getChildNode("mimeTypes"));
            this.maxExtractLength = this.determineMaxExtractLength();
            this.suggesterUpdateFrequencyMinutes = this.evaluateSuggesterUpdateFrequencyMinutes(defn, 10);
            this.scorerProviderName = ConfigUtil.getOptionalValue(defn, "scorerProviderName", null);
            this.reindexCount = ConfigUtil.getOptionalValue(defn, "reindexCount", 0);
            this.pathFilter = PathFilter.from((NodeBuilder)new ReadOnlyBuilder(defn));
            this.queryPaths = IndexDefinition.getOptionalStrings(defn, "queryPaths");
            this.suggestAnalyzed = this.evaluateSuggestAnalyzed(defn, false);
            PropertyState randomPS = defn.getProperty("seed");
            this.randomSeed = randomPS != null && randomPS.getType() == Type.LONG ? ((Long)randomPS.getValue(Type.LONG)).longValue() : UUID.randomUUID().getMostSignificantBits();
            if (defn.hasChildNode("facets")) {
                NodeState facetsConfig = defn.getChildNode("facets");
                this.secureFacets = SecureFacetConfiguration.getInstance(this.randomSeed, facetsConfig);
                this.numberOfTopFacets = ConfigUtil.getOptionalValue(facetsConfig, "topChildren", 10);
            } else {
                this.secureFacets = SecureFacetConfiguration.getInstance(this.randomSeed, null);
                this.numberOfTopFacets = 10;
            }
            this.suggestEnabled = this.evaluateSuggestionEnabled();
            this.spellcheckEnabled = this.evaluateSpellcheckEnabled();
            this.nrtIndexMode = IndexDefinition.supportsNRTIndexing(defn);
            this.syncIndexMode = IndexDefinition.supportsSyncIndexing(defn);
            this.syncPropertyIndexes = this.definedRules.stream().anyMatch(ir -> !((IndexingRule)ir).syncProps.isEmpty());
            this.useIfExists = ConfigUtil.getOptionalValue(defn, "useIfExists", null);
            this.deprecated = ConfigUtil.getOptionalValue(defn, "deprecated", false);
        }
        catch (IllegalStateException e) {
            log.error("Config error for index definition at {} . Please correct the index definition and reindex after correction. Additional Info : {}", new Object[]{indexPath, e.getMessage(), e});
            throw new IllegalStateException(e);
        }
    }

    public NodeState getDefinitionNodeState() {
        return this.definition;
    }

    public boolean isEnabled() {
        if (this.useIfExists == null) {
            return true;
        }
        if (!PathUtils.isValid((String)this.useIfExists)) {
            return false;
        }
        NodeState nodeState = this.root;
        for (String element : PathUtils.elements((String)this.useIfExists)) {
            if (element.startsWith("@")) {
                return nodeState.hasProperty(element.substring(1));
            }
            if ((nodeState = nodeState.getChildNode(element)).exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isFullTextEnabled() {
        return this.fullTextEnabled;
    }

    public String getFunctionName() {
        return this.funcName;
    }

    protected String getDefaultFunctionName() {
        return "fulltext";
    }

    public boolean hasFunctionDefined() {
        return this.funcName != null;
    }

    public int getBlobSize() {
        return this.blobSize;
    }

    public long getReindexCount() {
        return this.reindexCount;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    private int evaluateSuggesterUpdateFrequencyMinutes(NodeState defn, int defaultValue) {
        NodeState suggestionConfig = defn.getChildNode("suggestion");
        if (!suggestionConfig.exists()) {
            return ConfigUtil.getOptionalValue(defn, "suggestUpdateFrequencyMinutes", defaultValue);
        }
        return ConfigUtil.getOptionalValue(suggestionConfig, "suggestUpdateFrequencyMinutes", defaultValue);
    }

    public int getSuggesterUpdateFrequencyMinutes() {
        return this.suggesterUpdateFrequencyMinutes;
    }

    public boolean isEntryCountDefined() {
        return this.entryCountDefined;
    }

    public double getCostPerEntry() {
        return this.costPerEntry;
    }

    protected double getDefaultCostPerEntry(IndexFormatVersion version) {
        return 1.0;
    }

    public double getCostPerExecution() {
        return this.costPerExecution;
    }

    public long getFulltextEntryCount(long numOfDocs) {
        if (this.isEntryCountDefined()) {
            return Math.min(this.getEntryCount(), numOfDocs);
        }
        return numOfDocs;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public IndexFormatVersion getVersion() {
        return this.version;
    }

    public boolean isOfOldFormat() {
        return !IndexDefinition.hasIndexingRules(this.definition);
    }

    public boolean evaluatePathRestrictions() {
        return this.evaluatePathRestrictions;
    }

    public boolean hasCustomTikaConfig() {
        return this.hasCustomTikaConfig;
    }

    public InputStream getTikaConfig() {
        return ConfigUtil.getBlob(this.getTikaConfigNode(), "config.xml").getNewStream();
    }

    public String getTikaMappedMimeType(String type) {
        return this.customTikaMimeTypeMappings.getOrDefault(type, type);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String[] getIndexTags() {
        return this.indexTags;
    }

    public int getMaxExtractLength() {
        return this.maxExtractLength;
    }

    public String getScorerProviderName() {
        return this.scorerProviderName;
    }

    public PathFilter getPathFilter() {
        return this.pathFilter;
    }

    @Nullable
    public String[] getQueryPaths() {
        return this.queryPaths;
    }

    @Nullable
    public String getUniqueId() {
        return this.uid;
    }

    public boolean isNRTIndexingEnabled() {
        return this.nrtIndexMode;
    }

    public boolean isSyncIndexingEnabled() {
        return this.syncIndexMode;
    }

    public boolean hasSyncPropertyDefinitions() {
        return this.syncPropertyIndexes;
    }

    public boolean isPureNodeTypeIndex() {
        return this.nodeTypeIndex;
    }

    public static boolean hasPersistedIndex(NodeState definition) {
        for (String rm : definition.getChildNodeNames()) {
            if (!NodeStateUtils.isHidden((String)rm)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDisableStoredIndexDefinition() {
        return disableStoredIndexDefinition;
    }

    public static void setDisableStoredIndexDefinition(boolean disableStoredIndexDefinitionDefault) {
        disableStoredIndexDefinition = disableStoredIndexDefinitionDefault;
    }

    public Set<String> getRelativeNodeNames() {
        HashSet<String> names = new HashSet<String>();
        for (IndexingRule r : this.definedRules) {
            for (Aggregate.Include include : r.aggregate.getIncludes()) {
                for (int d = 0; d < include.maxDepth(); ++d) {
                    if (include.isPattern(d)) continue;
                    names.add(include.getElementNameIfNotAPattern(d));
                }
            }
        }
        return names;
    }

    public boolean indexesRelativeNodes() {
        for (IndexingRule r : this.definedRules) {
            if (r.aggregate.getIncludes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Fulltext Index : " + this.indexName;
    }

    @Override
    @Nullable
    public Aggregate getAggregate(String nodeType) {
        Aggregate agg = this.aggregates.get(nodeType);
        return agg;
    }

    private Map<String, Aggregate> collectAggregates(NodeState defn) {
        HashMap aggregateMap = Maps.newHashMap();
        for (ChildNodeEntry cne : defn.getChildNode("aggregates").getChildNodeEntries()) {
            String nodeType = cne.getName();
            int recursionLimit = ConfigUtil.getOptionalValue(cne.getNodeState(), "reaggregateLimit", 5);
            ArrayList includes = Lists.newArrayList();
            for (ChildNodeEntry include : cne.getNodeState().getChildNodeEntries()) {
                NodeState is = include.getNodeState();
                String primaryType = is.getString("primaryType");
                String path = is.getString("path");
                boolean relativeNode = ConfigUtil.getOptionalValue(is, "relativeNode", false);
                if (path == null) {
                    log.warn("Aggregate pattern in {} does not have required property [{}]. {} aggregate rule would be ignored", new Object[]{this, "path", include.getName()});
                    continue;
                }
                includes.add(new Aggregate.NodeInclude(this, primaryType, path, relativeNode));
            }
            aggregateMap.put(nodeType, new Aggregate(nodeType, includes, recursionLimit));
        }
        return ImmutableMap.copyOf((Map)aggregateMap);
    }

    public boolean hasMatchingNodeTypeReg(NodeState root) {
        return this.root.getChildNode("jcr:system").getChildNode("jcr:nodeTypes").equals(root.getChildNode("jcr:system").getChildNode("jcr:nodeTypes"));
    }

    public List<IndexingRule> getDefinedRules() {
        return this.definedRules;
    }

    @Nullable
    public IndexingRule getApplicableIndexingRule(String primaryNodeType) {
        ArrayList<IndexingRule> rules = null;
        List<IndexingRule> r = this.indexRules.get(primaryNodeType);
        if (r != null) {
            rules = new ArrayList<IndexingRule>();
            rules.addAll(r);
        }
        if (rules != null) {
            for (IndexingRule rule : rules) {
                if (!rule.appliesTo(primaryNodeType)) continue;
                return rule;
            }
        }
        return null;
    }

    @Nullable
    public IndexingRule getApplicableIndexingRule(NodeState state) {
        ArrayList<IndexingRule> rules = null;
        List<IndexingRule> r = this.indexRules.get(IndexDefinition.getPrimaryTypeName(state));
        if (r != null) {
            rules = new ArrayList<IndexingRule>();
            rules.addAll(r);
        }
        for (String name : IndexDefinition.getMixinTypeNames(state)) {
            r = this.indexRules.get(name);
            if (r == null) continue;
            if (rules == null) {
                rules = new ArrayList();
            }
            rules.addAll(r);
        }
        if (rules != null) {
            for (IndexingRule rule : rules) {
                if (!rule.appliesTo(state)) continue;
                return rule;
            }
        }
        return null;
    }

    private Map<String, List<IndexingRule>> collectIndexRules(NodeState indexRules, List<IndexingRule> definedIndexRules) {
        if (!indexRules.exists()) {
            return Collections.emptyMap();
        }
        if (!IndexDefinition.hasOrderableChildren(indexRules)) {
            log.warn("IndexRule node does not have orderable children in [{}]", (Object)this);
        }
        HashMap nt2rules = Maps.newHashMap();
        ReadOnlyNodeTypeManager ntReg = IndexDefinition.createNodeTypeManager(RootFactory.createReadOnlyRoot((NodeState)this.root));
        Tree ruleTree = TreeFactory.createReadOnlyTree((NodeState)indexRules);
        List<String> allNames = IndexDefinition.getAllNodeTypes(ntReg);
        for (Tree tree : ruleTree.getChildren()) {
            IndexingRule rule = new IndexingRule(tree.getName(), indexRules.getChildNode(tree.getName()));
            definedIndexRules.add(rule);
            log.trace("Found rule '{}' for NodeType '{}'", (Object)rule, (Object)rule.getNodeTypeName());
            List<String> ntNames = allNames;
            if (!rule.inherited) {
                ntNames = Collections.singletonList(rule.getNodeTypeName());
            }
            for (String ntName : ntNames) {
                if (!ntReg.isNodeType(ntName, rule.getNodeTypeName())) continue;
                ArrayList<IndexingRule> perNtConfig = (ArrayList<IndexingRule>)nt2rules.get(ntName);
                if (perNtConfig == null) {
                    perNtConfig = new ArrayList<IndexingRule>();
                    nt2rules.put(ntName, perNtConfig);
                }
                log.trace("Registering rule '{}' for name '{}'", (Object)rule, (Object)ntName);
                perNtConfig.add(new IndexingRule(rule, ntName));
            }
        }
        for (Map.Entry entry : nt2rules.entrySet()) {
            entry.setValue(ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
        }
        return ImmutableMap.copyOf((Map)nt2rules);
    }

    private boolean areAllTypesIndexed() {
        IndexingRule ntBaseRule = this.getApplicableIndexingRule("nt:base");
        return ntBaseRule != null;
    }

    private boolean evaluateSuggestionEnabled() {
        for (IndexingRule indexingRule : this.definedRules) {
            for (PropertyDefinition propertyDefinition : indexingRule.propConfigs.values()) {
                if (!propertyDefinition.useInSuggest) continue;
                return true;
            }
            for (NamePattern np : indexingRule.namePatterns) {
                if (!np.getConfig().useInSuggest) continue;
                return true;
            }
        }
        return false;
    }

    public Pattern getPropertyRegex() {
        return this.propertyRegex;
    }

    public boolean isSuggestEnabled() {
        return this.suggestEnabled;
    }

    private boolean evaluateSpellcheckEnabled() {
        for (IndexingRule indexingRule : this.definedRules) {
            for (PropertyDefinition propertyDefinition : indexingRule.propConfigs.values()) {
                if (!propertyDefinition.useInSpellcheck) continue;
                return true;
            }
            for (NamePattern np : indexingRule.namePatterns) {
                if (!np.getConfig().useInSpellcheck) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSpellcheckEnabled() {
        return this.spellcheckEnabled;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    private boolean evaluateSuggestAnalyzed(NodeState defn, boolean defaultValue) {
        NodeState suggestionConfig = defn.getChildNode("suggestion");
        if (!suggestionConfig.exists()) {
            return ConfigUtil.getOptionalValue(defn, "suggestAnalyzed", defaultValue);
        }
        return ConfigUtil.getOptionalValue(suggestionConfig, "suggestAnalyzed", defaultValue);
    }

    public boolean isSuggestAnalyzed() {
        return this.suggestAnalyzed;
    }

    public SecureFacetConfiguration getSecureFacetConfiguration() {
        return this.secureFacets;
    }

    public int getNumberOfTopFacets() {
        return this.numberOfTopFacets;
    }

    public static NodeBuilder updateDefinition(NodeBuilder indexDefn) {
        return IndexDefinition.updateDefinition(indexDefn, "unknown");
    }

    public static NodeBuilder updateDefinition(NodeBuilder indexDefn, String indexPath) {
        NodeState defn = indexDefn.getBaseState();
        if (!IndexDefinition.hasIndexingRules(defn)) {
            NodeState rulesState = IndexDefinition.createIndexRules(defn).getNodeState();
            indexDefn.setChildNode("indexRules", rulesState);
            indexDefn.setProperty(INDEX_VERSION, (Object)IndexDefinition.determineIndexFormatVersion(defn).getVersion());
            indexDefn.removeProperty("declaringNodeTypes");
            indexDefn.removeProperty("includePropertyNames");
            indexDefn.removeProperty("excludePropertyNames");
            indexDefn.removeProperty("orderedProps");
            indexDefn.removeProperty("fulltextEnabled");
            indexDefn.child("properties").remove();
            log.info("Updated index definition for {}", (Object)indexPath);
        }
        return indexDefn;
    }

    private static NodeBuilder createIndexRules(NodeState defn) {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        Set<String> declaringNodeTypes = IndexDefinition.getMultiProperty(defn, "declaringNodeTypes");
        Set<String> includes = IndexDefinition.getMultiProperty(defn, "includePropertyNames");
        Set<String> excludes = IndexDefinition.toLowerCase(IndexDefinition.getMultiProperty(defn, "excludePropertyNames"));
        Set<String> orderedProps = IndexDefinition.getMultiProperty(defn, "orderedProps");
        boolean fullTextEnabled = ConfigUtil.getOptionalValue(defn, "fulltextEnabled", true);
        boolean storageEnabled = ConfigUtil.getOptionalValue(defn, "oak.experimental.storage", true);
        NodeState propNodeState = defn.getChildNode("properties");
        if (declaringNodeTypes.isEmpty()) {
            declaringNodeTypes = Collections.singleton("nt:base");
        }
        HashSet propNamesSet = Sets.newHashSet();
        propNamesSet.addAll(includes);
        propNamesSet.addAll(excludes);
        propNamesSet.addAll(orderedProps);
        for (ChildNodeEntry cne : propNodeState.getChildNodeEntries()) {
            if (propNamesSet.contains(cne.getName()) || !Iterables.isEmpty((Iterable)cne.getNodeState().getChildNodeNames())) continue;
            propNamesSet.add(cne.getName());
        }
        ArrayList<String> propNames = new ArrayList<String>(propNamesSet);
        String includeAllProp = "^[^\\/]*$";
        if (fullTextEnabled && includes.isEmpty()) {
            propNames.add("^[^\\/]*$");
        }
        for (String typeName : declaringNodeTypes) {
            NodeBuilder rule = builder.child(typeName);
            IndexDefinition.markAsNtUnstructured(rule);
            ArrayList propNodeNames = Lists.newArrayListWithCapacity((int)propNamesSet.size());
            NodeBuilder propNodes = rule.child("properties");
            int i = 0;
            Iterator iterator = propNames.iterator();
            while (iterator.hasNext()) {
                String propName;
                String propNodeName = propName = (String)iterator.next();
                if (PropertyDefinition.isRelativeProperty(propName) || propName.equals("^[^\\/]*$")) {
                    propNodeName = "prop" + i++;
                }
                propNodeNames.add(propNodeName);
                NodeBuilder prop = propNodes.child(propNodeName);
                IndexDefinition.markAsNtUnstructured(prop);
                prop.setProperty("name", (Object)propName);
                if (excludes.contains(propName)) {
                    prop.setProperty("index", (Object)false);
                } else if (fullTextEnabled) {
                    prop.setProperty("analyzed", (Object)true);
                    prop.setProperty("nodeScopeIndex", (Object)true);
                    prop.setProperty("useInExcerpt", (Object)storageEnabled);
                    prop.setProperty("propertyIndex", (Object)false);
                } else {
                    prop.setProperty("propertyIndex", (Object)true);
                    if (orderedProps.contains(propName)) {
                        prop.setProperty("ordered", (Object)true);
                    }
                }
                if (propName.equals("^[^\\/]*$")) {
                    prop.setProperty("isRegexp", (Object)true);
                    continue;
                }
                NodeState propDefNode = IndexDefinition.getPropDefnNode(defn, propName);
                if (propDefNode == null) continue;
                for (PropertyState ps : propDefNode.getProperties()) {
                    prop.setProperty(ps);
                }
            }
            PropertyState supportedTypes = defn.getProperty("includePropertyTypes");
            if (supportedTypes == null) {
                supportedTypes = PropertyStates.createProperty((String)"includePropertyTypes", (Object)TYPES_ALLOW_ALL_NAME);
            }
            rule.setProperty(supportedTypes);
            if (!"nt:base".equals(typeName)) {
                rule.setProperty("inherited", (Object)false);
            }
            propNodes.setProperty(OAK_CHILD_ORDER, (Object)propNodeNames, Type.NAMES);
            IndexDefinition.markAsNtUnstructured(propNodes);
        }
        IndexDefinition.markAsNtUnstructured(builder);
        builder.setProperty(OAK_CHILD_ORDER, declaringNodeTypes, Type.NAMES);
        return builder;
    }

    private static NodeState getPropDefnNode(NodeState defn, String propName) {
        NodeState propDefNode;
        NodeState propNode = defn.getChildNode("properties");
        if (PropertyDefinition.isRelativeProperty(propName)) {
            NodeState result = propNode;
            for (String name : PathUtils.elements((String)propName)) {
                result = result.getChildNode(name);
            }
            propDefNode = result;
        } else {
            propDefNode = propNode.getChildNode(propName);
        }
        return propDefNode.exists() ? propDefNode : null;
    }

    private int determineMaxExtractLength() {
        int length = ConfigUtil.getOptionalValue(this.definition.getChildNode("tika"), "maxExtractLength", -10);
        if (length < 0) {
            return -length * this.maxFieldLength;
        }
        return length;
    }

    private NodeState getTikaConfigNode() {
        return this.definition.getChildNode("tika").getChildNode("config.xml");
    }

    private static Set<String> getMultiProperty(NodeState definition, String propName) {
        PropertyState pse = definition.getProperty(propName);
        return pse != null ? ImmutableSet.copyOf((Iterable)((Iterable)pse.getValue(Type.STRINGS))) : Collections.emptySet();
    }

    private static Set<String> toLowerCase(Set<String> values) {
        HashSet result = Sets.newHashSet();
        for (String val : values) {
            result.add(val.toLowerCase(Locale.ENGLISH));
        }
        return ImmutableSet.copyOf((Collection)result);
    }

    private static List<String> getAllNodeTypes(ReadOnlyNodeTypeManager ntReg) {
        try {
            ArrayList typeNames = Lists.newArrayList();
            NodeTypeIterator ntItr = ntReg.getAllNodeTypes();
            while (ntItr.hasNext()) {
                typeNames.add(ntItr.nextNodeType().getName());
            }
            return typeNames;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private static ReadOnlyNodeTypeManager createNodeTypeManager(final Root root) {
        return new ReadOnlyNodeTypeManager(){

            @NotNull
            protected Tree getTypes() {
                return root.getTree("/jcr:system/jcr:nodeTypes");
            }

            @NotNull
            protected NamePathMapper getNamePathMapper() {
                return NamePathMapper.DEFAULT;
            }
        };
    }

    private static String getPrimaryTypeName(NodeState state) {
        String primaryType = state.getName("jcr:primaryType");
        if (primaryType == null) {
            primaryType = state.getString("jcr:primaryType");
        }
        return primaryType != null ? primaryType : "nt:base";
    }

    private static Iterable<String> getMixinTypeNames(NodeState state) {
        PropertyState property = state.getProperty("jcr:mixinTypes");
        return property != null ? (Iterable)property.getValue(Type.NAMES) : Collections.emptyList();
    }

    private static boolean hasOrderableChildren(NodeState state) {
        return state.hasProperty(OAK_CHILD_ORDER);
    }

    static int getSupportedTypes(NodeState defn, String typePropertyName, int defaultVal) {
        PropertyState pst = defn.getProperty(typePropertyName);
        if (pst != null) {
            int types = 0;
            for (String inc : (Iterable)pst.getValue(Type.STRINGS)) {
                if (TYPES_ALLOW_ALL_NAME.equals(inc)) {
                    return -1;
                }
                try {
                    types |= 1 << PropertyType.valueFromName((String)inc);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Unknown property type: " + inc);
                }
            }
            return types;
        }
        return defaultVal;
    }

    static boolean includePropertyType(int includedPropertyTypes, int type) {
        if (includedPropertyTypes == -1) {
            return true;
        }
        if (includedPropertyTypes == 0) {
            return false;
        }
        return (includedPropertyTypes & 1 << type) != 0;
    }

    private static boolean hasFulltextEnabledIndexRule(List<IndexingRule> rules) {
        for (IndexingRule rule : rules) {
            if (!rule.isFulltextEnabled()) continue;
            return true;
        }
        return false;
    }

    private static void markAsNtUnstructured(NodeBuilder nb) {
        nb.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
    }

    protected static IndexFormatVersion determineIndexFormatVersion(NodeState defn) {
        if (defn.hasProperty("compatVersion")) {
            return IndexDefinition.versionFrom(defn.getProperty("compatVersion"));
        }
        if (defn.hasProperty(INDEX_VERSION)) {
            return IndexDefinition.versionFrom(defn.getProperty(INDEX_VERSION));
        }
        if (!defn.getChildNode(":data").exists()) {
            return IndexDefinition.determineVersionForFreshIndex(defn);
        }
        boolean fullTextEnabled = ConfigUtil.getOptionalValue(defn, "fulltextEnabled", true);
        return fullTextEnabled ? IndexFormatVersion.V1 : IndexFormatVersion.V2;
    }

    static IndexFormatVersion determineVersionForFreshIndex(NodeState defn) {
        return IndexDefinition.determineVersionForFreshIndex(defn.getProperty("fulltextEnabled"), defn.getProperty("compatVersion"), defn.getProperty(INDEX_VERSION));
    }

    static IndexFormatVersion determineVersionForFreshIndex(NodeBuilder defnb) {
        return IndexDefinition.determineVersionForFreshIndex(defnb.getProperty("fulltextEnabled"), defnb.getProperty("compatVersion"), defnb.getProperty(INDEX_VERSION));
    }

    private static IndexFormatVersion determineVersionForFreshIndex(PropertyState fulltext, PropertyState compat, PropertyState version) {
        if (compat != null) {
            return IndexDefinition.versionFrom(compat);
        }
        IndexFormatVersion defaultToUse = IndexFormatVersion.getDefault();
        IndexFormatVersion existing = version != null ? IndexDefinition.versionFrom(version) : null;
        IndexFormatVersion result = defaultToUse;
        if (existing != null) {
            result = IndexFormatVersion.max(result, existing);
        }
        if (fulltext != null && !((Boolean)fulltext.getValue(Type.BOOLEAN)).booleanValue()) {
            return IndexFormatVersion.max(result, IndexFormatVersion.V2);
        }
        return result;
    }

    private static String[] getOptionalStrings(NodeState defn, String propertyName) {
        PropertyState ps = defn.getProperty(propertyName);
        if (ps != null) {
            return (String[])Iterables.toArray((Iterable)((Iterable)ps.getValue(Type.STRINGS)), String.class);
        }
        return null;
    }

    private static IndexFormatVersion versionFrom(PropertyState ps) {
        return IndexFormatVersion.getVersion(Ints.checkedCast((long)((Long)ps.getValue(Type.LONG))));
    }

    private static boolean hasIndexingRules(NodeState defn) {
        return defn.getChildNode("indexRules").exists();
    }

    @Nullable
    protected static String determineUniqueId(NodeState defn) {
        return defn.getChildNode(STATUS_NODE).getString(PROP_UID);
    }

    private static boolean supportsNRTIndexing(NodeState defn) {
        return IndexDefinition.supportsIndexingMode((NodeBuilder)new ReadOnlyBuilder(defn), "nrt");
    }

    private static boolean supportsSyncIndexing(NodeState defn) {
        return IndexDefinition.supportsIndexingMode((NodeBuilder)new ReadOnlyBuilder(defn), "sync");
    }

    public static boolean supportsSyncOrNRTIndexing(NodeBuilder defn) {
        return IndexDefinition.supportsIndexingMode(defn, "nrt") || IndexDefinition.supportsIndexingMode(defn, "sync");
    }

    private static boolean supportsIndexingMode(NodeBuilder defn, String mode) {
        PropertyState async = defn.getProperty("async");
        if (async == null) {
            return false;
        }
        return Iterables.contains((Iterable)((Iterable)async.getValue(Type.STRINGS)), (Object)mode);
    }

    protected static NodeState getIndexDefinitionState(NodeState defn) {
        if (IndexDefinition.isDisableStoredIndexDefinition()) {
            return defn;
        }
        NodeState storedState = defn.getChildNode(INDEX_DEFINITION_NODE);
        return storedState.exists() ? storedState : defn;
    }

    private static Map<String, String> buildMimeTypeMap(NodeState node) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (ChildNodeEntry child : node.getChildNodeEntries()) {
            for (ChildNodeEntry subChild : child.getNodeState().getChildNodeEntries()) {
                StringBuilder typeBuilder = new StringBuilder(child.getName()).append('/').append(subChild.getName());
                PropertyState property = subChild.getNodeState().getProperty("mappedType");
                if (property == null) continue;
                map.put((Object)typeBuilder.toString(), property.getValue(Type.STRING));
            }
        }
        return map.build();
    }

    private static PropertyDefinition createNodeTypeDefinition(IndexingRule rule, String name, boolean sync) {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        builder.setProperty("propertyIndex", (Object)true);
        if (sync) {
            builder.setProperty("sync", (Object)sync);
        }
        builder.setProperty("name", (Object)name);
        return new PropertyDefinition(rule, name, builder.getNodeState());
    }

    static {
        NATIVE_SORT_ORDER = new QueryIndex.OrderEntry("jcr:score", Type.UNDEFINED, QueryIndex.OrderEntry.Order.DESCENDING);
    }

    public static class SecureFacetConfiguration {
        private final long randomSeed;
        private final MODE mode;
        private final int statisticalFacetSampleSize;

        SecureFacetConfiguration(long randomSeed, MODE mode, int statisticalFacetSampleSize) {
            this.randomSeed = randomSeed;
            this.mode = mode;
            this.statisticalFacetSampleSize = statisticalFacetSampleSize;
        }

        public MODE getMode() {
            return this.mode;
        }

        public int getStatisticalFacetSampleSize() {
            return this.statisticalFacetSampleSize;
        }

        public long getRandomSeed() {
            return this.randomSeed;
        }

        static SecureFacetConfiguration getInstance(long randomSeed, NodeState facetConfigRoot) {
            MODE mode;
            if (facetConfigRoot == null) {
                facetConfigRoot = EmptyNodeState.EMPTY_NODE;
            }
            int statisticalFacetSampleSize = (mode = SecureFacetConfiguration.getMode(facetConfigRoot)) == MODE.STATISTICAL ? SecureFacetConfiguration.getStatisticalFacetSampleSize(facetConfigRoot) : -1;
            return new SecureFacetConfiguration(randomSeed, mode, statisticalFacetSampleSize);
        }

        static MODE getMode(@NotNull NodeState facetConfigRoot) {
            String modeString;
            PropertyState securePS = facetConfigRoot.getProperty("secure");
            if (securePS != null) {
                if (securePS.getType() == Type.BOOLEAN) {
                    boolean secure = (Boolean)securePS.getValue(Type.BOOLEAN);
                    return secure ? MODE.SECURE : MODE.INSECURE;
                }
                modeString = (String)securePS.getValue(Type.STRING);
            } else {
                modeString = System.getProperty("oak.facets.secure", "default");
            }
            switch (modeString) {
                case "insecure": {
                    return MODE.INSECURE;
                }
                case "statistical": {
                    return MODE.STATISTICAL;
                }
            }
            return MODE.SECURE;
        }

        static int getStatisticalFacetSampleSize(@NotNull NodeState facetConfigRoot) {
            int statisticalFacetSampleSize = Integer.getInteger("oak.facet.statistical.sampleSize", 1000);
            int statisticalFacetSampleSizePV = ConfigUtil.getOptionalValue(facetConfigRoot, "sampleSize", statisticalFacetSampleSize);
            if (statisticalFacetSampleSizePV > 0) {
                statisticalFacetSampleSize = statisticalFacetSampleSizePV;
            }
            if (statisticalFacetSampleSize < 0) {
                statisticalFacetSampleSize = 1000;
            }
            return statisticalFacetSampleSize;
        }

        public static enum MODE {
            SECURE,
            STATISTICAL,
            INSECURE;

        }
    }

    private static final class NamePattern {
        private final String parentPath;
        private final Pattern pattern;
        private final PropertyDefinition config;

        private NamePattern(String pattern, PropertyDefinition config) {
            if ("^[^\\/]*$".equals(pattern)) {
                this.parentPath = "";
                this.pattern = Pattern.compile(pattern);
            } else {
                this.parentPath = PathUtils.getParentPath((String)pattern);
                this.pattern = Pattern.compile(PathUtils.getName((String)pattern));
            }
            this.config = config;
        }

        boolean matches(String propertyPath) {
            String parentPath = PathUtils.getParentPath((String)propertyPath);
            String propertyName = PathUtils.getName((String)propertyPath);
            if (!this.parentPath.equals(parentPath)) {
                return false;
            }
            return this.pattern.matcher(propertyName).matches();
        }

        PropertyDefinition getConfig() {
            return this.config;
        }
    }

    public class IndexingRule {
        private final String baseNodeType;
        private final String nodeTypeName;
        private final Map<String, PropertyDefinition> propConfigs;
        private final List<NamePattern> namePatterns;
        private final List<PropertyDefinition> nullCheckEnabledProperties;
        private final List<PropertyDefinition> functionRestrictions;
        private final List<PropertyDefinition> notNullCheckEnabledProperties;
        private final List<PropertyDefinition> nodeScopeAnalyzedProps;
        private final List<PropertyDefinition> syncProps;
        private final List<PropertyDefinition> similarityProperties;
        private final boolean indexesAllNodesOfMatchingType;
        private final boolean nodeNameIndexed;
        public final float boost;
        final boolean inherited;
        public final int propertyTypes;
        final boolean fulltextEnabled;
        public final boolean propertyIndexEnabled;
        final boolean nodeFullTextIndexed;
        final Aggregate aggregate;
        final Aggregate propAggregate;

        IndexingRule(String nodeTypeName, NodeState config) {
            this.nodeTypeName = nodeTypeName;
            this.baseNodeType = nodeTypeName;
            this.boost = ConfigUtil.getOptionalValue(config, "boost", 1.0f);
            this.inherited = ConfigUtil.getOptionalValue(config, "inherited", true);
            this.propertyTypes = IndexDefinition.getSupportedTypes(config, "includePropertyTypes", -1);
            ArrayList namePatterns = Lists.newArrayList();
            ArrayList nonExistentProperties = Lists.newArrayList();
            ArrayList functionRestrictions = Lists.newArrayList();
            ArrayList existentProperties = Lists.newArrayList();
            ArrayList nodeScopeAnalyzedProps = Lists.newArrayList();
            ArrayList syncProps = Lists.newArrayList();
            ArrayList similarityProperties = Lists.newArrayList();
            ArrayList propIncludes = Lists.newArrayList();
            this.propConfigs = this.collectPropConfigs(config, namePatterns, propIncludes, nonExistentProperties, existentProperties, nodeScopeAnalyzedProps, functionRestrictions, syncProps, similarityProperties);
            this.propAggregate = new Aggregate(nodeTypeName, propIncludes);
            this.aggregate = this.combine(this.propAggregate, nodeTypeName);
            this.namePatterns = ImmutableList.copyOf((Collection)namePatterns);
            this.nodeScopeAnalyzedProps = ImmutableList.copyOf((Collection)nodeScopeAnalyzedProps);
            this.nullCheckEnabledProperties = ImmutableList.copyOf((Collection)nonExistentProperties);
            this.functionRestrictions = ImmutableList.copyOf((Collection)functionRestrictions);
            this.notNullCheckEnabledProperties = ImmutableList.copyOf((Collection)existentProperties);
            this.similarityProperties = ImmutableList.copyOf((Collection)similarityProperties);
            this.fulltextEnabled = this.aggregate.hasNodeAggregates() || this.hasAnyFullTextEnabledProperty();
            this.nodeFullTextIndexed = this.aggregate.hasNodeAggregates() || this.anyNodeScopeIndexedProperty();
            this.propertyIndexEnabled = this.hasAnyPropertyIndexConfigured();
            this.indexesAllNodesOfMatchingType = this.areAlMatchingNodeByTypeIndexed();
            this.nodeNameIndexed = this.evaluateNodeNameIndexed(config);
            this.syncProps = ImmutableList.copyOf((Collection)syncProps);
            this.validateRuleDefinition();
        }

        IndexingRule(IndexingRule original, String nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
            this.baseNodeType = original.getNodeTypeName();
            this.propConfigs = original.propConfigs;
            this.namePatterns = original.namePatterns;
            this.boost = original.boost;
            this.inherited = original.inherited;
            this.propertyTypes = original.propertyTypes;
            this.propertyIndexEnabled = original.propertyIndexEnabled;
            this.propAggregate = original.propAggregate;
            this.nullCheckEnabledProperties = original.nullCheckEnabledProperties;
            this.notNullCheckEnabledProperties = original.notNullCheckEnabledProperties;
            this.functionRestrictions = original.functionRestrictions;
            this.nodeScopeAnalyzedProps = original.nodeScopeAnalyzedProps;
            this.aggregate = this.combine(this.propAggregate, nodeTypeName);
            this.fulltextEnabled = this.aggregate.hasNodeAggregates() || original.fulltextEnabled;
            this.nodeFullTextIndexed = this.aggregate.hasNodeAggregates() || original.nodeFullTextIndexed;
            this.indexesAllNodesOfMatchingType = this.areAlMatchingNodeByTypeIndexed();
            this.nodeNameIndexed = original.nodeNameIndexed;
            this.syncProps = original.syncProps;
            this.similarityProperties = original.similarityProperties;
        }

        public boolean isIndexed(String propertyName) {
            return this.getConfig(propertyName) != null;
        }

        public String getNodeTypeName() {
            return this.nodeTypeName;
        }

        public String getBaseNodeType() {
            return this.baseNodeType;
        }

        public Iterable<PropertyDefinition> getProperties() {
            return this.propConfigs.values();
        }

        public List<PropertyDefinition> getNullCheckEnabledProperties() {
            return this.nullCheckEnabledProperties;
        }

        public List<PropertyDefinition> getFunctionRestrictions() {
            return this.functionRestrictions;
        }

        public List<PropertyDefinition> getNotNullCheckEnabledProperties() {
            return this.notNullCheckEnabledProperties;
        }

        public List<PropertyDefinition> getNodeScopeAnalyzedProps() {
            return this.nodeScopeAnalyzedProps;
        }

        public List<PropertyDefinition> getSimilarityProperties() {
            return this.similarityProperties;
        }

        public String toString() {
            String str = "IndexRule: " + this.nodeTypeName;
            if (!this.baseNodeType.equals(this.nodeTypeName)) {
                str = str + "(" + this.baseNodeType + ")";
            }
            return str;
        }

        public boolean isAggregated(String nodePath) {
            return this.aggregate.hasRelativeNodeInclude(nodePath);
        }

        public boolean appliesTo(NodeState state) {
            for (String mixinName : IndexDefinition.getMixinTypeNames(state)) {
                if (!this.nodeTypeName.equals(mixinName)) continue;
                return true;
            }
            return this.nodeTypeName.equals(IndexDefinition.getPrimaryTypeName(state));
        }

        public boolean appliesTo(String nodeTypeName) {
            return this.nodeTypeName.equals(nodeTypeName);
        }

        public boolean isNodeNameIndexed() {
            return this.nodeNameIndexed;
        }

        public boolean isFulltextEnabled() {
            return this.fulltextEnabled;
        }

        public boolean isNodeFullTextIndexed() {
            return this.nodeFullTextIndexed;
        }

        @Nullable
        public PropertyDefinition getConfig(String propertyName) {
            PropertyDefinition config = this.propConfigs.get(propertyName.toLowerCase(Locale.ENGLISH));
            if (config != null) {
                return config;
            }
            if (this.namePatterns.size() > 0) {
                for (NamePattern np : this.namePatterns) {
                    if (!np.matches(propertyName)) continue;
                    return np.getConfig();
                }
            }
            return null;
        }

        public boolean includePropertyType(int type) {
            return IndexDefinition.includePropertyType(this.propertyTypes, type);
        }

        public Aggregate getAggregate() {
            return this.aggregate;
        }

        public boolean indexesAllNodesOfMatchingType() {
            return this.indexesAllNodesOfMatchingType;
        }

        public boolean isBasedOnNtBase() {
            return "nt:base".equals(this.baseNodeType);
        }

        private Map<String, PropertyDefinition> collectPropConfigs(NodeState config, List<NamePattern> patterns, List<Aggregate.Include> propAggregate, List<PropertyDefinition> nonExistentProperties, List<PropertyDefinition> existentProperties, List<PropertyDefinition> nodeScopeAnalyzedProps, List<PropertyDefinition> functionRestrictions, List<PropertyDefinition> syncProps, List<PropertyDefinition> similarityProperties) {
            HashMap propDefns = Maps.newHashMap();
            NodeState propNode = config.getChildNode("properties");
            if (propNode.exists() && !IndexDefinition.hasOrderableChildren(propNode)) {
                log.warn("Properties node for [{}] does not have orderable children in [{}]", (Object)this, (Object)IndexDefinition.this);
            }
            if (IndexDefinition.this.nodeTypeIndex) {
                boolean sync = ConfigUtil.getOptionalValue(config, "sync", false);
                PropertyDefinition pdpt = IndexDefinition.createNodeTypeDefinition(this, "jcr:primaryType", sync);
                PropertyDefinition pdmixin = IndexDefinition.createNodeTypeDefinition(this, "jcr:mixinTypes", sync);
                propDefns.put(pdpt.name.toLowerCase(Locale.ENGLISH), pdpt);
                propDefns.put(pdmixin.name.toLowerCase(Locale.ENGLISH), pdmixin);
                if (sync) {
                    syncProps.add(pdpt);
                    syncProps.add(pdmixin);
                }
                if (propNode.getChildNodeCount(1L) > 0L) {
                    log.warn("Index at [{}] has {} enabled and cannot support other property definitions", (Object)IndexDefinition.this.indexPath, (Object)"nodeTypeIndex");
                }
                return ImmutableMap.copyOf((Map)propDefns);
            }
            Tree propTree = TreeFactory.createReadOnlyTree((NodeState)propNode);
            for (Tree prop : propTree.getChildren()) {
                String propName = prop.getName();
                NodeState propDefnNode = propNode.getChildNode(propName);
                if (!propDefnNode.exists() || propDefns.containsKey(propName)) continue;
                PropertyDefinition pd = new PropertyDefinition(this, propName, propDefnNode);
                if (pd.function != null) {
                    String[] properties;
                    functionRestrictions.add(pd);
                    for (String p : properties = FunctionIndexProcessor.getProperties(pd.functionCode)) {
                        if (PathUtils.getDepth((String)p) <= 1) continue;
                        PropertyDefinition pd2 = new PropertyDefinition(this, p, propDefnNode);
                        propAggregate.add(new Aggregate.FunctionInclude(pd2));
                    }
                    continue;
                }
                if (pd.isRegexp) {
                    patterns.add(new NamePattern(pd.name, pd));
                } else {
                    propDefns.put(pd.name.toLowerCase(Locale.ENGLISH), pd);
                }
                if (pd.relative) {
                    propAggregate.add(new Aggregate.PropertyInclude(pd));
                }
                if (pd.nullCheckEnabled) {
                    nonExistentProperties.add(pd);
                }
                if (pd.notNullCheckEnabled) {
                    existentProperties.add(pd);
                }
                if (pd.nodeScopeIndex && pd.analyzed && !pd.isRegexp) {
                    nodeScopeAnalyzedProps.add(pd);
                }
                if (pd.sync) {
                    syncProps.add(pd);
                }
                if (!pd.useInSimilarity) continue;
                similarityProperties.add(pd);
            }
            this.ensureNodeTypeIndexingIsConsistent(propDefns, syncProps);
            return ImmutableMap.copyOf((Map)propDefns);
        }

        private void ensureNodeTypeIndexingIsConsistent(Map<String, PropertyDefinition> propDefns, List<PropertyDefinition> syncProps) {
            PropertyDefinition pd_pr = propDefns.get("jcr:primaryType".toLowerCase(Locale.ENGLISH));
            PropertyDefinition pd_mixin = propDefns.get("jcr:mixinTypes".toLowerCase(Locale.ENGLISH));
            if (pd_pr != null && pd_pr.propertyIndex && pd_mixin == null) {
                pd_mixin = IndexDefinition.createNodeTypeDefinition(this, "jcr:mixinTypes", pd_pr.sync);
                syncProps.add(pd_mixin);
                propDefns.put("jcr:mixinTypes".toLowerCase(Locale.ENGLISH), pd_mixin);
            }
        }

        private boolean hasAnyFullTextEnabledProperty() {
            for (PropertyDefinition pd : this.propConfigs.values()) {
                if (!pd.fulltextEnabled()) continue;
                return true;
            }
            for (NamePattern np : this.namePatterns) {
                if (!np.getConfig().fulltextEnabled()) continue;
                return true;
            }
            return false;
        }

        private boolean hasAnyPropertyIndexConfigured() {
            for (PropertyDefinition pd : this.propConfigs.values()) {
                if (!pd.propertyIndex) continue;
                return true;
            }
            for (NamePattern np : this.namePatterns) {
                if (!np.getConfig().propertyIndex) continue;
                return true;
            }
            return false;
        }

        private boolean anyNodeScopeIndexedProperty() {
            for (PropertyDefinition pd : this.propConfigs.values()) {
                if (!pd.nodeScopeIndex) continue;
                return true;
            }
            for (NamePattern np : this.namePatterns) {
                if (!np.getConfig().nodeScopeIndex) continue;
                return true;
            }
            return false;
        }

        private boolean areAlMatchingNodeByTypeIndexed() {
            if (IndexDefinition.this.nodeTypeIndex) {
                return true;
            }
            if (this.nodeFullTextIndexed) {
                return true;
            }
            for (PropertyDefinition pd : this.nullCheckEnabledProperties) {
                if (pd.relative) continue;
                return true;
            }
            return this.getConfig("jcr:primaryType") != null;
        }

        private boolean evaluateNodeNameIndexed(NodeState config) {
            if (ConfigUtil.getOptionalValue(config, "indexNodeName", false)) {
                return true;
            }
            for (PropertyDefinition pd : this.propConfigs.values()) {
                if (!":nodeName".equals(pd.name)) continue;
                return true;
            }
            return false;
        }

        private Aggregate combine(Aggregate propAggregate, String nodeTypeName) {
            Aggregate nodeTypeAgg = IndexDefinition.this.getAggregate(nodeTypeName);
            ArrayList includes = Lists.newArrayList();
            includes.addAll(propAggregate.getIncludes());
            if (nodeTypeAgg != null) {
                includes.addAll(nodeTypeAgg.getIncludes());
            }
            return new Aggregate(nodeTypeName, includes);
        }

        private void validateRuleDefinition() {
            if (!this.nullCheckEnabledProperties.isEmpty() && this.isBasedOnNtBase()) {
                throw new IllegalStateException("nt:base based rule cannot have a PropertyDefinition with nullCheckEnabled");
            }
        }
    }

    public static class Builder {
        private static final String DEFAULT_UID = "0";
        protected NodeState root;
        private NodeState defn;
        protected String indexPath;
        protected String uid;
        private boolean reindexMode;
        protected IndexFormatVersion version;

        public Builder root(NodeState root) {
            this.root = (NodeState)Preconditions.checkNotNull((Object)root);
            return this;
        }

        public Builder defn(NodeState defn) {
            this.defn = (NodeState)Preconditions.checkNotNull((Object)defn);
            return this;
        }

        public Builder indexPath(String indexPath) {
            this.indexPath = (String)Preconditions.checkNotNull((Object)indexPath);
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder version(IndexFormatVersion version) {
            this.version = version;
            return this;
        }

        public Builder reindex() {
            this.reindexMode = true;
            return this;
        }

        public IndexDefinition build() {
            if (this.version == null) {
                this.version = IndexDefinition.determineIndexFormatVersion(this.defn);
            }
            if (this.uid == null) {
                this.uid = IndexDefinition.determineUniqueId(this.defn);
                if (this.uid == null && !IndexDefinition.hasPersistedIndex(this.defn)) {
                    this.uid = DEFAULT_UID;
                }
            }
            NodeState indexDefnStateToUse = this.defn;
            if (!this.reindexMode) {
                indexDefnStateToUse = IndexDefinition.getIndexDefinitionState(this.defn);
            }
            return this.createInstance(indexDefnStateToUse);
        }

        protected IndexDefinition createInstance(NodeState indexDefnStateToUse) {
            return new IndexDefinition(this.root, indexDefnStateToUse, this.version, this.uid, this.indexPath);
        }
    }
}

