/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.run.cli.CommonOptions;
import org.apache.jackrabbit.oak.run.cli.FileStoreBuilderCustomizer;
import org.apache.jackrabbit.oak.run.cli.Options;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;

class SegmentFixtureProvider {
    SegmentFixtureProvider() {
    }

    static NodeStore create(Options options, BlobStore blobStore, Whiteboard wb, Closer closer, boolean readOnly) throws IOException, InvalidFileStoreVersionException {
        SegmentNodeStore nodeStore;
        StatisticsProvider statisticsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)((StatisticsProvider)WhiteboardUtils.getService((Whiteboard)wb, StatisticsProvider.class)));
        String path = options.getOptionBean(CommonOptions.class).getStoreArg();
        FileStore.Builder builder = FileStore.builder((File)new File(path)).withMaxFileSize(256).withDefaultMemoryMapping();
        FileStoreBuilderCustomizer customizer = (FileStoreBuilderCustomizer)WhiteboardUtils.getService((Whiteboard)wb, FileStoreBuilderCustomizer.class);
        if (customizer != null) {
            customizer.customize(builder);
        }
        if (blobStore != null) {
            builder.withBlobStore(blobStore);
        }
        if (readOnly) {
            FileStore.ReadOnlyStore fileStore = builder.withStatisticsProvider(statisticsProvider).buildReadOnly();
            closer.register((Closeable)fileStore);
            nodeStore = SegmentNodeStore.builder((SegmentStore)fileStore).build();
            wb.register(FileStore.ReadOnlyStore.class, (Object)fileStore, Collections.emptyMap());
        } else {
            FileStore fileStore = builder.withStatisticsProvider(statisticsProvider).build();
            closer.register((Closeable)fileStore);
            nodeStore = SegmentNodeStore.builder((SegmentStore)fileStore).build();
            wb.register(FileStore.class, (Object)fileStore, Collections.emptyMap());
        }
        return nodeStore;
    }
}

