/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.linkedList;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryReader;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.linkedList.NodeStateEntryList;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreTool;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedLinkedList
implements NodeStateEntryList {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedLinkedList.class);
    private static final String COMPACT_STORE_MILLIS_NAME = "oak.indexer.linkedList.compactMillis";
    private final LinkedHashMap<Long, NodeStateEntry> cache;
    private final NodeStateEntryWriter writer;
    private final NodeStateEntryReader reader;
    private final String storeFileName;
    private final int compactStoreMillis = Integer.getInteger("oak.indexer.linkedList.compactMillis", 60000);
    private MVStore store;
    private MVMap<Long, String> map;
    private long headIndex;
    private long tailIndex;
    private long size;
    private long lastLog;
    private long lastCompact;
    private long cacheHits;
    private long cacheMisses;

    public PersistedLinkedList(String fileName, NodeStateEntryWriter writer, NodeStateEntryReader reader, final int cacheSize) {
        LOG.info("Opening store " + fileName);
        this.storeFileName = fileName;
        this.cache = new LinkedHashMap<Long, NodeStateEntry>(cacheSize + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean removeEldestEntry(Map.Entry<Long, NodeStateEntry> eldest) {
                return this.size() > cacheSize;
            }
        };
        File oldFile = new File(fileName);
        if (oldFile.exists()) {
            LOG.info("Deleting " + fileName);
            try {
                FileUtils.forceDelete((File)oldFile);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        this.openStore();
        this.writer = writer;
        this.reader = reader;
        this.lastCompact = System.currentTimeMillis();
    }

    private void openStore() {
        this.store = MVStore.open((String)this.storeFileName);
        this.map = this.store.openMap("list");
    }

    @Override
    public void add(@NotNull NodeStateEntry item) {
        boolean compactNow;
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Can't add null to the list");
        String s = this.writer.toString(item);
        long index = this.tailIndex++;
        this.map.put((Object)index, (Object)s);
        this.cache.put(index, item);
        ++this.size;
        long sizeBytes = this.store.getFileStore().size();
        long now = System.currentTimeMillis();
        if (now >= this.lastLog + 10000L) {
            LOG.info("Entries: " + this.size + " map size: " + this.map.sizeAsLong() + " file size: " + sizeBytes + " bytes");
            this.lastLog = now;
        }
        boolean bl = compactNow = now >= this.lastCompact + (long)this.compactStoreMillis;
        if (compactNow && sizeBytes > 10000000L) {
            LOG.info("Compacting...");
            this.store.close();
            MVStoreTool.compact((String)this.storeFileName, (boolean)true);
            this.openStore();
            this.lastCompact = System.currentTimeMillis();
            LOG.info("New size=" + this.store.getFileStore().size() + " bytes");
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public Iterator<NodeStateEntry> iterator() {
        return new NodeIterator(this.headIndex);
    }

    @Override
    public NodeStateEntry remove() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"Cannot remove item from empty list");
        NodeStateEntry ret = this.get(this.headIndex);
        this.map.remove((Object)this.headIndex);
        this.cache.remove(this.headIndex);
        ++this.headIndex;
        --this.size;
        if (this.size == 0L) {
            this.map.clear();
            this.cache.clear();
        }
        return ret;
    }

    private NodeStateEntry get(long index) {
        NodeStateEntry result = this.cache.get(index);
        if (result == null) {
            ++this.cacheMisses;
            String s = (String)this.map.get((Object)index);
            result = this.reader.read(s);
            this.cache.put(index, result);
        } else {
            ++this.cacheHits;
        }
        return result;
    }

    @Override
    public int size() {
        return (int)this.size;
    }

    @Override
    public void close() {
        this.store.close();
        LOG.info("Cache hits {} misses {}", (Object)this.cacheHits, (Object)this.cacheMisses);
    }

    @Override
    public long estimatedMemoryUsage() {
        return 0L;
    }

    class NodeIterator
    implements Iterator<NodeStateEntry> {
        private long index;

        NodeIterator(long index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < PersistedLinkedList.this.tailIndex;
        }

        @Override
        public NodeStateEntry next() {
            if (this.index < PersistedLinkedList.this.headIndex || this.index >= PersistedLinkedList.this.tailIndex) {
                throw new IllegalStateException();
            }
            return PersistedLinkedList.this.get(this.index++);
        }
    }
}

