/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import com.google.common.base.Stopwatch;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.index.indexer.document.LastModifiedRange;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverser;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverserFactory;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStoreUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.MemoryManager;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.MemoryManagerClient;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.MultithreadedTraverseWithSortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateHolder;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.StateInBytesHolder;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TraverseAndSortTask
implements Callable<List<File>>,
MemoryManagerClient {
    private static final String ID_PREFIX = "TAST-";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeStateEntryTraverser nodeStates;
    private final NodeStateEntryWriter entryWriter;
    private final File storeDir;
    private final boolean compressionEnabled;
    private final Comparator<NodeStateHolder> comparator;
    private long entryCount;
    private long memoryUsed;
    private final File sortWorkDir;
    private final List<File> sortedFiles = new ArrayList<File>();
    private final LinkedList<NodeStateHolder> entryBatch = new LinkedList();
    private NodeStateEntry lastSavedNodeStateEntry;
    private final String taskID;
    private final AtomicReference<Phaser> dataDumpNotifyingPhaserRef = new AtomicReference();
    private final Queue<String> completedTasks;
    private final Queue<Callable<List<File>>> newTasksQueue;
    private final Phaser phaser;
    private final long lastModifiedLowerBound;
    private long lastModifiedUpperBound;
    private final BlobStore blobStore;
    private final NodeStateEntryTraverserFactory nodeStateEntryTraverserFactory;
    private final MemoryManager memoryManager;
    private String registrationID;

    TraverseAndSortTask(LastModifiedRange range, Comparator<NodeStateHolder> comparator, BlobStore blobStore, File storeDir, boolean compressionEnabled, Queue<String> completedTasks, Queue<Callable<List<File>>> newTasksQueue, Phaser phaser, NodeStateEntryTraverserFactory nodeStateEntryTraverserFactory, MemoryManager memoryManager) throws IOException {
        this.nodeStates = nodeStateEntryTraverserFactory.create(range);
        this.taskID = ID_PREFIX + this.nodeStates.getId();
        this.lastModifiedLowerBound = this.nodeStates.getDocumentModificationRange().getLastModifiedFrom();
        this.lastModifiedUpperBound = this.nodeStates.getDocumentModificationRange().getLastModifiedTo();
        this.blobStore = blobStore;
        this.entryWriter = new NodeStateEntryWriter(blobStore);
        this.storeDir = storeDir;
        this.compressionEnabled = compressionEnabled;
        this.comparator = comparator;
        this.completedTasks = completedTasks;
        this.newTasksQueue = newTasksQueue;
        this.phaser = phaser;
        this.nodeStateEntryTraverserFactory = nodeStateEntryTraverserFactory;
        this.memoryManager = memoryManager;
        this.sortWorkDir = MultithreadedTraverseWithSortStrategy.DirectoryHelper.createdSortWorkDir(storeDir, this.taskID, this.lastModifiedLowerBound);
        phaser.register();
        this.log.debug("Task {} registered to phaser", (Object)this.taskID);
    }

    @Override
    public void memoryLow(Phaser phaser) {
        if (this.dataDumpNotifyingPhaserRef.compareAndSet(null, phaser)) {
            this.log.info("{} registering to low memory notification phaser", (Object)this.taskID);
            phaser.register();
        } else {
            this.log.warn("{} already has a low memory notification phaser.", (Object)this.taskID);
        }
    }

    private boolean registerWithMemoryManager() {
        Optional<String> registrationIDOptional = this.memoryManager.registerClient(this);
        registrationIDOptional.ifPresent(s -> {
            this.registrationID = s;
            this.log.debug("{} Registered with memory manager with registration ID {}", (Object)this.taskID, (Object)this.registrationID);
        });
        return registrationIDOptional.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> call() {
        try {
            Random random = new Random();
            while (MemoryManager.Type.JMX_BASED.equals((Object)this.memoryManager.getType()) && !this.registerWithMemoryManager()) {
                int sleepDuration = 1000 + random.nextInt(500);
                this.log.info("{} Could not register to memory manager. Sleeping {} ms before retrying", (Object)this.taskID, (Object)sleepDuration);
                try {
                    Thread.sleep(sleepDuration);
                }
                catch (InterruptedException e) {
                    this.log.warn(this.taskID + " Interrupted while sleeping while trying to register to memory manager", (Throwable)e);
                }
            }
            this.logFlags();
            this.writeToSortedFiles();
            this.log.info("Completed task {}", (Object)this.taskID);
            this.completedTasks.add(this.taskID);
            MultithreadedTraverseWithSortStrategy.DirectoryHelper.markCompleted(this.sortWorkDir);
            List<File> sleepDuration = this.sortedFiles;
            return sleepDuration;
        }
        catch (IOException e) {
            this.log.error(this.taskID + " could not complete download ", (Throwable)e);
        }
        finally {
            this.phaser.arriveAndDeregister();
            this.log.info("{} entered finally block.", (Object)this.taskID);
            Phaser dataDumpPhaser = this.dataDumpNotifyingPhaserRef.get();
            if (dataDumpPhaser != null) {
                this.log.info("{} Data dump phaser not null after task completion. Notifying memory listener.", (Object)this.taskID);
                dataDumpPhaser.arriveAndDeregister();
            }
            if (MemoryManager.Type.JMX_BASED.equals((Object)this.memoryManager.getType())) {
                this.memoryManager.deregisterClient(this.registrationID);
            }
            try {
                this.nodeStates.close();
            }
            catch (IOException e) {
                this.log.error(this.taskID + " could not close NodeStateEntryTraverser", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private void writeToSortedFiles() throws IOException {
        Stopwatch w = Stopwatch.createStarted();
        for (NodeStateEntry e : this.nodeStates) {
            if (e.getLastModified() >= this.lastModifiedUpperBound) break;
            ++this.entryCount;
            this.addEntry(e);
        }
        this.sortAndSaveBatch();
        this.reset();
        this.log.info("{} Dumped {} nodestates in json format in {}", new Object[]{this.taskID, this.entryCount, w});
        this.log.info("{} Created {} sorted files of size {} to merge", new Object[]{this.taskID, this.sortedFiles.size(), IOUtils.humanReadableByteCount((long)FlatFileStoreUtils.sizeOf(this.sortedFiles))});
    }

    private void addEntry(NodeStateEntry e) throws IOException {
        long remainingNumberOfTimestamps;
        if (this.memoryManager.isMemoryLow()) {
            if (this.memoryUsed >= 0x100000L) {
                this.sortAndSaveBatch();
                this.reset();
            } else {
                this.log.trace("{} Memory manager reports low memory but there is not enough data ({}) to dump.", (Object)this.taskID, (Object)IOUtils.humanReadableByteCount((long)this.memoryUsed));
            }
        }
        if ((remainingNumberOfTimestamps = this.lastModifiedUpperBound - e.getLastModified()) > 1L && this.completedTasks.poll() != null) {
            long splitPoint = e.getLastModified() + (long)Math.ceil((double)(this.lastModifiedUpperBound - e.getLastModified()) / 2.0);
            this.log.info("Splitting task {}. New Upper limit for this task {}. New task range - {} to {}", new Object[]{this.taskID, splitPoint, splitPoint, this.lastModifiedUpperBound});
            this.newTasksQueue.add(new TraverseAndSortTask(new LastModifiedRange(splitPoint, this.lastModifiedUpperBound), this.comparator, this.blobStore, this.storeDir, this.compressionEnabled, this.completedTasks, this.newTasksQueue, this.phaser, this.nodeStateEntryTraverserFactory, this.memoryManager));
            this.lastModifiedUpperBound = splitPoint;
        }
        String jsonText = this.entryWriter.asJson(e.getNodeState());
        StateInBytesHolder h = new StateInBytesHolder(e.getPath(), jsonText);
        this.entryBatch.add(h);
        this.lastSavedNodeStateEntry = e;
        this.updateMemoryUsed(h);
    }

    private synchronized void reset() {
        Phaser phaser;
        this.log.trace("{} Reset called ", (Object)this.taskID);
        if (MemoryManager.Type.SELF_MANAGED.equals((Object)this.memoryManager.getType())) {
            this.memoryManager.changeMemoryUsedBy(-1L * this.memoryUsed);
        }
        if ((phaser = this.dataDumpNotifyingPhaserRef.get()) != null) {
            this.log.info("{} Finished saving data to disk. Notifying memory listener.", (Object)this.taskID);
            phaser.arriveAndDeregister();
            this.dataDumpNotifyingPhaserRef.compareAndSet(phaser, null);
        }
        this.memoryUsed = 0L;
    }

    private void sortAndSaveBatch() throws IOException {
        if (this.entryBatch.isEmpty()) {
            return;
        }
        this.entryBatch.sort(this.comparator);
        Stopwatch w = Stopwatch.createStarted();
        File newtmpfile = File.createTempFile("sortInBatch", "flatfile", this.sortWorkDir);
        long textSize = 0L;
        long size = this.entryBatch.size();
        try (BufferedWriter writer = FlatFileStoreUtils.createWriter(newtmpfile, this.compressionEnabled);){
            while (!this.entryBatch.isEmpty()) {
                NodeStateHolder h = this.entryBatch.removeFirst();
                String text = this.entryWriter.toString(h.getPathElements(), h.getLine());
                writer.write(text);
                writer.newLine();
                textSize += (long)(text.length() + 1);
            }
        }
        this.log.info("{} Sorted and stored batch of size {} (uncompressed {}) with {} entries in {}. Last entry lastModified = {}", new Object[]{this.taskID, IOUtils.humanReadableByteCount((long)newtmpfile.length()), IOUtils.humanReadableByteCount((long)textSize), size, w, this.lastSavedNodeStateEntry.getLastModified()});
        MultithreadedTraverseWithSortStrategy.DirectoryHelper.markLastProcessedStatus(this.sortWorkDir, this.lastSavedNodeStateEntry.getLastModified());
        this.sortedFiles.add(newtmpfile);
    }

    private void logFlags() {
        this.log.info("Starting task {}", (Object)this.taskID);
    }

    private void updateMemoryUsed(NodeStateHolder h) {
        this.memoryUsed += (long)h.getMemorySize();
        if (MemoryManager.Type.SELF_MANAGED.equals((Object)this.memoryManager.getType())) {
            this.memoryManager.changeMemoryUsedBy(h.getMemorySize());
        }
    }
}

