/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Stopwatch;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.index.indexer.document.LastModifiedRange;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverser;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverserFactory;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStoreUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntrySorter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.PathElementComparator;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.SortStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StoreAndSortStrategy
implements SortStrategy {
    private static final String OAK_INDEXER_DELETE_ORIGINAL = "oak.indexer.deleteOriginal";
    private static final int LINE_SEP_LENGTH = StandardSystemProperty.LINE_SEPARATOR.value().length();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeStateEntryTraverserFactory nodeStatesFactory;
    private final PathElementComparator comparator;
    private final NodeStateEntryWriter entryWriter;
    private final File storeDir;
    private final boolean compressionEnabled;
    private long entryCount;
    private boolean deleteOriginal = Boolean.parseBoolean(System.getProperty("oak.indexer.deleteOriginal", "true"));
    private int maxMemory = Integer.getInteger("oak.indexer.maxSortMemoryInGB", 2);
    private long textSize;

    public StoreAndSortStrategy(NodeStateEntryTraverserFactory nodeStatesFactory, PathElementComparator comparator, NodeStateEntryWriter entryWriter, File storeDir, boolean compressionEnabled) {
        this.nodeStatesFactory = nodeStatesFactory;
        this.comparator = comparator;
        this.entryWriter = entryWriter;
        this.storeDir = storeDir;
        this.compressionEnabled = compressionEnabled;
    }

    @Override
    public File createSortedStoreFile() throws IOException {
        try (NodeStateEntryTraverser nodeStates = this.nodeStatesFactory.create(new LastModifiedRange(0L, Long.MAX_VALUE));){
            File storeFile = this.writeToStore(nodeStates, this.storeDir, this.getStoreFileName());
            File file = this.sortStoreFile(storeFile);
            return file;
        }
    }

    @Override
    public long getEntryCount() {
        return this.entryCount;
    }

    private File sortStoreFile(File storeFile) throws IOException {
        File sortWorkDir = new File(storeFile.getParent(), "sort-work-dir");
        FileUtils.forceMkdir((File)sortWorkDir);
        File sortedFile = new File(storeFile.getParentFile(), FlatFileStoreUtils.getSortedStoreFileName(this.compressionEnabled));
        NodeStateEntrySorter sorter = new NodeStateEntrySorter(this.comparator, storeFile, sortWorkDir, sortedFile);
        this.logFlags();
        sorter.setUseZip(this.compressionEnabled);
        sorter.setMaxMemoryInGB(this.maxMemory);
        sorter.setDeleteOriginal(this.deleteOriginal);
        sorter.setActualFileSize(this.textSize);
        sorter.sort();
        return sorter.getSortedFile();
    }

    private File writeToStore(NodeStateEntryTraverser nodeStates, File dir, String fileName) throws IOException {
        this.entryCount = 0L;
        File file = new File(dir, fileName);
        Stopwatch sw = Stopwatch.createStarted();
        try (BufferedWriter w = FlatFileStoreUtils.createWriter(file, this.compressionEnabled);){
            for (NodeStateEntry e : nodeStates) {
                String line = this.entryWriter.toString(e);
                w.append(line);
                w.newLine();
                this.textSize += (long)(line.length() + LINE_SEP_LENGTH);
                ++this.entryCount;
            }
        }
        String sizeStr = this.compressionEnabled ? String.format("compressed/%s actual size", IOUtils.humanReadableByteCount((long)this.textSize)) : "";
        this.log.info("Dumped {} nodestates in json format in {} ({} {})", new Object[]{this.entryCount, sw, IOUtils.humanReadableByteCount((long)file.length()), sizeStr});
        return file;
    }

    private void logFlags() {
        this.log.info("Delete original dump from traversal : {} ({})", (Object)this.deleteOriginal, (Object)OAK_INDEXER_DELETE_ORIGINAL);
        this.log.info("Max heap memory (GB) to be used for merge sort : {} ({})", (Object)this.maxMemory, (Object)"oak.indexer.maxSortMemoryInGB");
    }

    private String getStoreFileName() {
        return this.compressionEnabled ? "store.json.gz" : "store.json";
    }
}

