/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

public class PathElementComparator
implements Comparator<Iterable<String>> {
    private final Set<String> preferred;

    public PathElementComparator() {
        this(Collections.emptySet());
    }

    public PathElementComparator(Iterable<String> preferredPathElements) {
        this.preferred = ImmutableSet.copyOf(preferredPathElements);
    }

    @Override
    public int compare(Iterable<String> p1, Iterable<String> p2) {
        Iterator<String> i1 = p1.iterator();
        Iterator<String> i2 = p2.iterator();
        while (i1.hasNext() || i2.hasNext()) {
            if (!i1.hasNext()) {
                return -1;
            }
            if (!i2.hasNext()) {
                return 1;
            }
            String pe1 = i1.next();
            String pe2 = i2.next();
            boolean pe1Preferred = this.preferred.contains(pe1);
            boolean pe2Preferred = this.preferred.contains(pe2);
            if (pe1Preferred && !pe2Preferred) {
                return -1;
            }
            if (pe2Preferred && !pe1Preferred) {
                return 1;
            }
            int compare = pe1.compareTo(pe2);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

