/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.json.JsonSerializer;
import org.apache.jackrabbit.oak.plugins.blob.serializer.BlobIdSerializer;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class NodeStateEntryWriter {
    private static final String OAK_CHILD_ORDER = ":childOrder";
    private static final String DELIMITER = "|";
    private final JsopBuilder jw = new JsopBuilder();
    private final JsonSerializer serializer;
    private final Joiner pathJoiner = Joiner.on((char)'/');

    public NodeStateEntryWriter(BlobStore blobStore) {
        this.serializer = new JsonSerializer((JsopWriter)this.jw, (BlobSerializer)new BlobIdSerializer(blobStore));
    }

    public String toString(NodeStateEntry e) {
        return this.toString(e.getPath(), this.asJson(e.getNodeState()));
    }

    public String toString(String path, String nodeStateAsJson) {
        StringBuilder sb = new StringBuilder(nodeStateAsJson.length() + path.length() + 1);
        sb.append(path).append(DELIMITER).append(nodeStateAsJson);
        return sb.toString();
    }

    public String toString(List<String> pathElements, String nodeStateAsJson) {
        int pathStringSize = pathElements.stream().mapToInt(String::length).sum();
        StringBuilder sb = new StringBuilder(nodeStateAsJson.length() + pathStringSize + pathElements.size() + 1);
        sb.append('/');
        this.pathJoiner.appendTo(sb, pathElements);
        sb.append(DELIMITER).append(nodeStateAsJson);
        return sb.toString();
    }

    public String asJson(NodeState nodeState) {
        this.jw.resetWriter();
        this.jw.object();
        for (PropertyState ps : nodeState.getProperties()) {
            String name = ps.getName();
            if (!this.include(name)) continue;
            this.jw.key(name);
            this.serializer.serialize(ps);
        }
        this.jw.endObject();
        return this.jw.toString();
    }

    private boolean include(String propertyName) {
        return !OAK_CHILD_ORDER.equals(propertyName);
    }

    public static String getPath(String entryLine) {
        return entryLine.substring(0, NodeStateEntryWriter.getDelimiterPosition(entryLine));
    }

    public static String[] getParts(String line) {
        int pos = NodeStateEntryWriter.getDelimiterPosition(line);
        return new String[]{line.substring(0, pos), line.substring(pos + 1)};
    }

    private static int getDelimiterPosition(String entryLine) {
        int indexOfPipe = entryLine.indexOf(DELIMITER);
        Preconditions.checkState((indexOfPipe > 0 ? 1 : 0) != 0, (String)"Invalid path entry [%s]", (Object[])new Object[]{entryLine});
        return indexOfPipe;
    }
}

