/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.sort.ExternalSort;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStoreUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateHolder;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.SimpleNodeStateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeStateEntrySorter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULTMAXTEMPFILES = 1024;
    private final File nodeStateFile;
    private final File workDir;
    private final Charset charset = Charsets.UTF_8;
    private final Comparator<Iterable<String>> pathComparator;
    private File sortedFile;
    private boolean useZip;
    private boolean deleteOriginal;
    private long maxMemory = 0x140000000L;
    private long actualFileSize;

    public NodeStateEntrySorter(Comparator<Iterable<String>> pathComparator, File nodeStateFile, File workDir) {
        this(pathComparator, nodeStateFile, workDir, NodeStateEntrySorter.getSortedFileName(nodeStateFile));
    }

    public NodeStateEntrySorter(Comparator<Iterable<String>> pathComparator, File nodeStateFile, File workDir, File sortedFile) {
        this.nodeStateFile = nodeStateFile;
        this.workDir = workDir;
        this.sortedFile = sortedFile;
        this.pathComparator = pathComparator;
    }

    public void setUseZip(boolean useZip) {
        this.useZip = useZip;
    }

    public void setDeleteOriginal(boolean deleteOriginal) {
        this.deleteOriginal = deleteOriginal;
    }

    public void setMaxMemoryInGB(long maxMemoryInGb) {
        this.maxMemory = maxMemoryInGb * 0x40000000L;
    }

    public void setActualFileSize(long actualFileSize) {
        this.actualFileSize = actualFileSize;
    }

    public void sort() throws IOException {
        long estimatedMemory = NodeStateEntrySorter.estimateAvailableMemory();
        long memory = Math.min(estimatedMemory, this.maxMemory);
        this.log.info("Sorting with memory {} (estimated {})", (Object)IOUtils.humanReadableByteCount((long)memory), (Object)IOUtils.humanReadableByteCount((long)estimatedMemory));
        Stopwatch w = Stopwatch.createStarted();
        Comparator comparator = (e1, e2) -> this.pathComparator.compare(e1.getPathElements(), e2.getPathElements());
        Function<String, NodeStateHolder> func1 = line -> line == null ? null : new SimpleNodeStateHolder((String)line);
        Function<NodeStateHolder, String> func2 = holder -> holder == null ? null : holder.getLine();
        List<File> sortedFiles = this.sortInBatch(memory, comparator, func1, func2);
        this.log.info("Batch sorting done in {} with {} files of size {} to merge", new Object[]{w, sortedFiles.size(), IOUtils.humanReadableByteCount((long)FlatFileStoreUtils.sizeOf(sortedFiles))});
        if (this.deleteOriginal) {
            this.log.info("Removing the original file {}", (Object)this.nodeStateFile.getAbsolutePath());
            FileUtils.forceDelete((File)this.nodeStateFile);
        }
        Stopwatch w2 = Stopwatch.createStarted();
        this.mergeSortedFiles(comparator, func1, func2, sortedFiles);
        this.log.info("Merging of sorted files completed in {}", (Object)w2);
        this.log.info("Sorting completed in {}", (Object)w);
    }

    private void mergeSortedFiles(Comparator<NodeStateHolder> comparator, Function<String, NodeStateHolder> func1, Function<NodeStateHolder, String> func2, List<File> sortedFiles) throws IOException {
        try (BufferedWriter writer = FlatFileStoreUtils.createWriter(this.sortedFile, this.useZip);){
            ExternalSort.mergeSortedFiles(sortedFiles, (BufferedWriter)writer, comparator, (Charset)this.charset, (boolean)true, (boolean)this.useZip, func2, func1);
        }
    }

    private List<File> sortInBatch(long memory, Comparator<NodeStateHolder> comparator, Function<String, NodeStateHolder> func1, Function<NodeStateHolder, String> func2) throws IOException {
        if (this.useZip) {
            try (BufferedReader reader = FlatFileStoreUtils.createReader(this.nodeStateFile, this.useZip);){
                List list = ExternalSort.sortInBatch((BufferedReader)reader, (long)this.actualFileSize, comparator, (int)1024, (long)memory, (Charset)this.charset, (File)this.workDir, (boolean)true, (int)0, (boolean)this.useZip, func2, func1);
                return list;
            }
        }
        return ExternalSort.sortInBatch((File)this.nodeStateFile, comparator, (int)1024, (long)memory, (Charset)this.charset, (File)this.workDir, (boolean)true, (int)0, (boolean)this.useZip, func2, func1);
    }

    public File getSortedFile() {
        return this.sortedFile;
    }

    private static File getSortedFileName(File file) {
        String extension = FilenameUtils.getExtension((String)file.getName());
        String baseName = FilenameUtils.getBaseName((String)file.getName());
        return new File(file.getParentFile(), baseName + "-sorted." + extension);
    }

    private static long estimateAvailableMemory() {
        System.gc();
        Runtime r = Runtime.getRuntime();
        long allocatedMemory = r.totalMemory() - r.freeMemory();
        long presFreeMemory = r.maxMemory() - allocatedMemory;
        return presFreeMemory;
    }
}

