/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class FlatFileStoreUtils {
    FlatFileStoreUtils() {
    }

    public static BufferedReader createReader(File file, boolean compressionEnabled) {
        try {
            FileInputStream in = new FileInputStream(file);
            BufferedReader br = compressionEnabled ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream((InputStream)in, 2048), Charsets.UTF_8)) : new BufferedReader(new InputStreamReader((InputStream)in, Charsets.UTF_8));
            return br;
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening file " + file, e);
        }
    }

    public static BufferedWriter createWriter(File file, boolean compressionEnabled) throws IOException {
        OutputStream out = new FileOutputStream(file);
        if (compressionEnabled) {
            out = new GZIPOutputStream(out, 2048){
                {
                    this.def.setLevel(1);
                }
            };
        }
        return new BufferedWriter(new OutputStreamWriter(out, Charsets.UTF_8));
    }

    public static long sizeOf(List<File> sortedFiles) {
        return sortedFiles.stream().mapToLong(File::length).sum();
    }

    public static String getSortedStoreFileName(boolean compressionEnabled) {
        return compressionEnabled ? "store-sorted.json.gz" : "store-sorted.json";
    }
}

