/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.LineIterator;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStoreIterator;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStoreUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryReader;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public class FlatFileStore
implements Iterable<NodeStateEntry>,
Closeable {
    private final Closer closer = Closer.create();
    private final BlobStore blobStore;
    private final File storeFile;
    private final NodeStateEntryReader entryReader;
    private final Set<String> preferredPathElements;
    private final boolean compressionEnabled;
    private long entryCount = -1L;

    public FlatFileStore(BlobStore blobStore, File storeFile, NodeStateEntryReader entryReader, Set<String> preferredPathElements, boolean compressionEnabled) {
        this.blobStore = blobStore;
        this.storeFile = storeFile;
        this.entryReader = entryReader;
        this.preferredPathElements = preferredPathElements;
        this.compressionEnabled = compressionEnabled;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(long entryCount) {
        this.entryCount = entryCount;
    }

    @Override
    public Iterator<NodeStateEntry> iterator() {
        String fileName = new File(this.storeFile.getParent(), "linkedList").getAbsolutePath();
        FlatFileStoreIterator it = new FlatFileStoreIterator(this.blobStore, fileName, this.createBaseIterator(), this.preferredPathElements);
        this.closer.register(it::close);
        return it;
    }

    private Iterator<NodeStateEntry> createBaseIterator() {
        final LineIterator itr = new LineIterator((Reader)FlatFileStoreUtils.createReader(this.storeFile, this.compressionEnabled));
        this.closer.register(() -> ((LineIterator)itr).close());
        return new AbstractIterator<NodeStateEntry>(){

            protected NodeStateEntry computeNext() {
                if (itr.hasNext()) {
                    return FlatFileStore.this.convert(itr.nextLine());
                }
                LineIterator.closeQuietly((LineIterator)itr);
                return (NodeStateEntry)this.endOfData();
            }
        };
    }

    private NodeStateEntry convert(String line) {
        return this.entryReader.read(line);
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

