/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.index.indexer.document.CompositeException;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverserFactory;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.DefaultMemoryManager;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStore;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.MemoryManager;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.MultithreadedTraverseWithSortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryReader;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.PathElementComparator;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.SortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.StoreAndSortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.TraverseWithSortStrategy;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFileNodeStoreBuilder {
    private static final String FLAT_FILE_STORE_DIR_NAME_PREFIX = "flat-fs-";
    public static final String OAK_INDEXER_USE_ZIP = "oak.indexer.useZip";
    static final String OAK_INDEXER_TRAVERSE_WITH_SORT = "oak.indexer.traverseWithSortStrategy";
    static final String OAK_INDEXER_SORT_STRATEGY_TYPE = "oak.indexer.sortStrategyType";
    private static final String OAK_INDEXER_SORTED_FILE_PATH = "oak.indexer.sortedFilePath";
    static final String DEFAULT_NUMBER_OF_DATA_DUMP_THREADS = "4";
    static final String PROP_THREAD_POOL_SIZE = "oak.indexer.dataDumpThreadPoolSize";
    static final String OAK_INDEXER_MAX_SORT_MEMORY_IN_GB = "oak.indexer.maxSortMemoryInGB";
    static final int OAK_INDEXER_MAX_SORT_MEMORY_IN_GB_DEFAULT = 2;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<Long> lastModifiedBreakPoints;
    private final File workDir;
    private final List<File> existingDataDumpDirs = new ArrayList<File>();
    private Set<String> preferredPathElements = Collections.emptySet();
    private BlobStore blobStore;
    private PathElementComparator comparator;
    private NodeStateEntryWriter entryWriter;
    private NodeStateEntryTraverserFactory nodeStateEntryTraverserFactory;
    private long entryCount = 0L;
    private File flatFileStoreDir;
    private final MemoryManager memoryManager;
    private final boolean useZip = Boolean.parseBoolean(System.getProperty("oak.indexer.useZip", "true"));
    private final boolean useTraverseWithSort = Boolean.parseBoolean(System.getProperty("oak.indexer.traverseWithSortStrategy", "true"));
    private final String sortStrategyTypeString = System.getProperty("oak.indexer.sortStrategyType");
    private final SortStrategyType sortStrategyType = this.sortStrategyTypeString != null ? SortStrategyType.valueOf(this.sortStrategyTypeString) : (this.useTraverseWithSort ? SortStrategyType.TRAVERSE_WITH_SORT : SortStrategyType.STORE_AND_SORT);

    public FlatFileNodeStoreBuilder(File workDir, MemoryManager memoryManager) {
        this.workDir = workDir;
        this.memoryManager = memoryManager;
    }

    public FlatFileNodeStoreBuilder(File workDir) {
        this.workDir = workDir;
        this.memoryManager = new DefaultMemoryManager();
    }

    public FlatFileNodeStoreBuilder withLastModifiedBreakPoints(List<Long> lastModifiedBreakPoints) {
        this.lastModifiedBreakPoints = lastModifiedBreakPoints;
        return this;
    }

    public FlatFileNodeStoreBuilder withBlobStore(BlobStore blobStore) {
        this.blobStore = blobStore;
        return this;
    }

    public FlatFileNodeStoreBuilder withPreferredPathElements(Set<String> preferredPathElements) {
        this.preferredPathElements = preferredPathElements;
        return this;
    }

    public FlatFileNodeStoreBuilder addExistingDataDumpDir(File existingDataDumpDir) {
        if (existingDataDumpDir != null) {
            this.existingDataDumpDirs.add(existingDataDumpDir);
        }
        return this;
    }

    public FlatFileNodeStoreBuilder withNodeStateEntryTraverserFactory(NodeStateEntryTraverserFactory factory) {
        this.nodeStateEntryTraverserFactory = factory;
        return this;
    }

    public FlatFileStore build() throws IOException, CompositeException {
        this.logFlags();
        this.comparator = new PathElementComparator(this.preferredPathElements);
        this.entryWriter = new NodeStateEntryWriter(this.blobStore);
        FlatFileStore store = new FlatFileStore(this.blobStore, this.createdSortedStoreFile(), new NodeStateEntryReader(this.blobStore), Collections.unmodifiableSet(this.preferredPathElements), this.useZip);
        if (this.entryCount > 0L) {
            store.setEntryCount(this.entryCount);
        }
        return store;
    }

    private File createdSortedStoreFile() throws IOException, CompositeException {
        String sortedFilePath = System.getProperty(OAK_INDEXER_SORTED_FILE_PATH);
        if (sortedFilePath != null) {
            File sortedFile = new File(sortedFilePath);
            if (sortedFile.exists() && sortedFile.isFile() && sortedFile.canRead()) {
                this.log.info("Reading from provided sorted file [{}] (via system property '{}')", (Object)sortedFile.getAbsolutePath(), (Object)OAK_INDEXER_SORTED_FILE_PATH);
                return sortedFile;
            }
            String msg = String.format("Cannot read sorted file at [%s] configured via system property '%s'", sortedFile.getAbsolutePath(), OAK_INDEXER_SORTED_FILE_PATH);
            throw new IllegalArgumentException(msg);
        }
        this.createStoreDir();
        SortStrategy strategy = this.createSortStrategy(this.flatFileStoreDir);
        File result = strategy.createSortedStoreFile();
        this.entryCount = strategy.getEntryCount();
        return result;
    }

    SortStrategy createSortStrategy(File dir) throws IOException {
        switch (this.sortStrategyType) {
            case STORE_AND_SORT: {
                this.log.info("Using StoreAndSortStrategy");
                return new StoreAndSortStrategy(this.nodeStateEntryTraverserFactory, this.comparator, this.entryWriter, dir, this.useZip);
            }
            case TRAVERSE_WITH_SORT: {
                this.log.info("Using TraverseWithSortStrategy");
                return new TraverseWithSortStrategy(this.nodeStateEntryTraverserFactory, this.comparator, this.entryWriter, dir, this.useZip);
            }
            case MULTITHREADED_TRAVERSE_WITH_SORT: {
                this.log.info("Using MultithreadedTraverseWithSortStrategy");
                return new MultithreadedTraverseWithSortStrategy(this.nodeStateEntryTraverserFactory, this.lastModifiedBreakPoints, this.comparator, this.blobStore, dir, this.existingDataDumpDirs, this.useZip, this.memoryManager);
            }
        }
        throw new IllegalStateException("Not a valid sort strategy value " + (Object)((Object)this.sortStrategyType));
    }

    private void logFlags() {
        this.log.info("Preferred path elements are {}", (Object)Iterables.toString(this.preferredPathElements));
        this.log.info("Compression enabled while sorting : {} ({})", (Object)this.useZip, (Object)OAK_INDEXER_USE_ZIP);
        this.log.info("Sort strategy : {} ({})", (Object)this.sortStrategyType, (Object)OAK_INDEXER_TRAVERSE_WITH_SORT);
    }

    File createStoreDir() throws IOException {
        this.flatFileStoreDir = Files.createTempDirectory(this.workDir.toPath(), FLAT_FILE_STORE_DIR_NAME_PREFIX, new FileAttribute[0]).toFile();
        return this.flatFileStoreDir;
    }

    public File getFlatFileStoreDir() {
        return this.flatFileStoreDir;
    }

    public static enum SortStrategyType {
        STORE_AND_SORT,
        TRAVERSE_WITH_SORT,
        MULTITHREADED_TRAVERSE_WITH_SORT;

    }
}

