/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.commons.codec.binary.Base64;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.MemoryManager;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.MemoryManagerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMemoryManager
implements MemoryManager {
    private static final String OAK_INDEXER_MIN_MEMORY = "oak.indexer.minMemoryForWork";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean sufficientMemory = new AtomicBoolean(true);
    private final long maxMemoryBytes;
    private final long minMemoryBytes;
    private final AtomicLong memoryUsed;
    private final MemoryPoolMXBean pool = DefaultMemoryManager.getMemoryPool();
    private final ConcurrentHashMap<String, MemoryManagerClient> clients;
    private final MemoryManager.Type type;
    private final Random random;

    public DefaultMemoryManager() {
        this((long)Integer.getInteger(OAK_INDEXER_MIN_MEMORY, 2).intValue() * 0x40000000L, (long)Integer.getInteger("oak.indexer.maxSortMemoryInGB", 2).intValue() * 0x40000000L);
    }

    public DefaultMemoryManager(long minMemoryInBytes, long maxMemoryInBytes) {
        this.memoryUsed = new AtomicLong(0L);
        this.clients = new ConcurrentHashMap();
        this.random = ThreadLocalRandom.current();
        if (this.pool == null) {
            this.maxMemoryBytes = maxMemoryInBytes;
            this.minMemoryBytes = 0L;
            this.type = MemoryManager.Type.SELF_MANAGED;
            this.log.warn("Unable to setup monitoring of available memory. Would use configured maxMemory limit of {} GB", (Object)(maxMemoryInBytes / 0x40000000L));
        } else {
            this.maxMemoryBytes = 0L;
            MemoryUsage usage = this.pool.getCollectionUsage();
            long maxAvailable = usage.getMax();
            long l = this.minMemoryBytes = minMemoryInBytes < maxAvailable ? minMemoryInBytes : (long)(0.5 * (double)maxAvailable);
            if (this.minMemoryBytes != minMemoryInBytes) {
                this.log.warn("Provided minimum memory {} GB more than available memory ({}).Overriding configuration and setting min memory to 50% of available memory ({}).", new Object[]{minMemoryInBytes / 0x40000000L, IOUtils.humanReadableByteCount((long)maxAvailable), IOUtils.humanReadableByteCount((long)this.minMemoryBytes)});
            }
            this.type = MemoryManager.Type.JMX_BASED;
            this.configureMemoryListener();
        }
        this.logFlags();
    }

    private void configureMemoryListener() {
        NotificationEmitter emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        MemoryListener listener = new MemoryListener();
        emitter.addNotificationListener(listener, null, null);
        MemoryUsage usage = this.pool.getCollectionUsage();
        long maxMemory = usage.getMax();
        this.log.info("Setting up a listener to monitor pool '{}' and trigger batch save if memory drop below {} GB (max {})", new Object[]{this.pool.getName(), this.minMemoryBytes / 0x40000000L, IOUtils.humanReadableByteCount((long)maxMemory)});
        this.pool.setCollectionUsageThreshold(this.minMemoryBytes);
    }

    @Override
    public MemoryManager.Type getType() {
        return this.type;
    }

    @Override
    public boolean isMemoryLow() {
        if (this.type == MemoryManager.Type.SELF_MANAGED) {
            return this.memoryUsed.get() > this.maxMemoryBytes;
        }
        return !this.sufficientMemory.get();
    }

    @Override
    public void changeMemoryUsedBy(long memory) {
        if (this.type != MemoryManager.Type.SELF_MANAGED) {
            throw new UnsupportedOperationException("Not a self managed memory manager");
        }
        this.memoryUsed.addAndGet(memory);
    }

    @Override
    public Optional<String> registerClient(MemoryManagerClient client) {
        if (this.type != MemoryManager.Type.JMX_BASED) {
            throw new UnsupportedOperationException("Not a JMX based memory manager");
        }
        if (!this.sufficientMemory.get()) {
            this.log.info("Can't register new client now. Not enough memory.");
            return Optional.empty();
        }
        String registrationID = this.generateRegistrationID();
        for (int retryCount = 0; retryCount < 5; ++retryCount) {
            MemoryManagerClient oldClient = this.clients.putIfAbsent(registrationID, client);
            if (oldClient == null) {
                this.log.debug("Registered client with registration_id={}", (Object)registrationID);
                return Optional.of(registrationID);
            }
            registrationID = this.generateRegistrationID();
        }
        return Optional.empty();
    }

    @Override
    public boolean deregisterClient(String registrationID) {
        boolean removed;
        if (this.type != MemoryManager.Type.JMX_BASED) {
            throw new UnsupportedOperationException("Not a JMX based memory manager");
        }
        if (this.clients.remove(registrationID) != null) {
            this.log.debug("Client with registration_id={} deregistered", (Object)registrationID);
            removed = true;
        } else {
            this.log.warn("No client found with registration_id={}", (Object)registrationID);
            removed = false;
        }
        return removed;
    }

    private String generateRegistrationID() {
        byte[] r = new byte[8];
        this.random.nextBytes(r);
        return Base64.encodeBase64String((byte[])r) + "-" + System.currentTimeMillis();
    }

    private long getAvailableMemory(MemoryUsage usage) {
        return usage.getMax() - usage.getUsed();
    }

    private void checkMemory(MemoryUsage usage) {
        long avail = this.getAvailableMemory(usage);
        if (avail > this.minMemoryBytes) {
            this.sufficientMemory.set(true);
            this.log.info("Available memory level {} is good.", (Object)IOUtils.humanReadableByteCount((long)avail));
        } else {
            boolean couldSet = this.sufficientMemory.compareAndSet(true, false);
            if (couldSet) {
                Phaser phaser = new Phaser();
                this.clients.forEach((r, c) -> c.memoryLow(phaser));
                this.log.info("Available memory level {} (required {}) is low. Enabling flag to trigger batch save", (Object)IOUtils.humanReadableByteCount((long)avail), (Object)(this.minMemoryBytes / 0x40000000L));
                new Thread(() -> {
                    this.log.info("Waiting for all tasks to finish dumping their data");
                    phaser.awaitAdvance(phaser.getPhase());
                    this.log.info("All tasks have finished dumping their data");
                    this.sufficientMemory.set(true);
                }, "Wait-For-Dump").start();
            }
        }
    }

    private static MemoryPoolMXBean getMemoryPool() {
        long maxSize = 0L;
        MemoryPoolMXBean maxPool = null;
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            long poolSize;
            if (MemoryType.HEAP != pool.getType() || !pool.isCollectionUsageThresholdSupported() || (poolSize = pool.getCollectionUsage().getMax()) <= maxSize) continue;
            maxPool = pool;
        }
        return maxPool;
    }

    private void logFlags() {
        if (this.type.equals((Object)MemoryManager.Type.JMX_BASED)) {
            this.log.info("Min heap memory (GB) to be required : {} ({})", (Object)(this.minMemoryBytes / 0x40000000L), (Object)OAK_INDEXER_MIN_MEMORY);
        }
        if (this.type.equals((Object)MemoryManager.Type.SELF_MANAGED)) {
            this.log.info("Max heap memory (GB) to be used for merge sort : {} ({})", (Object)(this.maxMemoryBytes / 0x40000000L), (Object)"oak.indexer.maxSortMemoryInGB");
        }
    }

    private class MemoryListener
    implements NotificationListener {
        private MemoryListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification.getType().equals("java.management.memory.collection.threshold.exceeded") && DefaultMemoryManager.this.sufficientMemory.get()) {
                CompositeData cd = (CompositeData)notification.getUserData();
                MemoryNotificationInfo info = MemoryNotificationInfo.from(cd);
                DefaultMemoryManager.this.checkMemory(info.getUsage());
            }
        }
    }
}

